/*
 * Decompiled with CFR 0.152.
 */
package kamon.context.generated.binary.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Arrays;
import java.util.InputMismatchException;
import kamon.context.generated.binary.context.BooleanTag;
import kamon.context.generated.binary.context.LongTag;
import kamon.context.generated.binary.context.StringTag;

public class Tags
implements Serializable {
    public static int colferSizeMax = 0x1000000;
    public static int colferListMax = 65536;
    public StringTag[] strings;
    public LongTag[] longs;
    public BooleanTag[] booleans;
    private static final StringTag[] _zeroStrings = new StringTag[0];
    private static final LongTag[] _zeroLongs = new LongTag[0];
    private static final BooleanTag[] _zeroBooleans = new BooleanTag[0];
    private static final long serialVersionUID = 3L;

    public Tags() {
        this.init();
    }

    private void init() {
        this.strings = _zeroStrings;
        this.longs = _zeroLongs;
        this.booleans = _zeroBooleans;
    }

    public byte[] marshal(OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        if (byArray == null || byArray.length == 0) {
            byArray = new byte[Math.min(colferSizeMax, 2048)];
        }
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferOverflowException bufferOverflowException) {
                byArray = new byte[Math.min(colferSizeMax, byArray.length * 4)];
                continue;
            }
            break;
        }
        outputStream.write(byArray, 0, n);
        return byArray;
    }

    public int marshal(byte[] byArray, int n) {
        int n2 = n;
        try {
            Serializable serializable;
            int n3;
            int n4;
            Serializable[] serializableArray;
            if (this.strings.length != 0) {
                byArray[n2++] = 0;
                serializableArray = this.strings;
                n4 = serializableArray.length;
                if (n4 > colferListMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.Tags.strings length %d exceeds %d elements", n4, colferListMax));
                }
                while (n4 > 127) {
                    byArray[n2++] = (byte)(n4 | 0x80);
                    n4 >>>= 7;
                }
                byArray[n2++] = (byte)n4;
                for (n3 = 0; n3 < serializableArray.length; ++n3) {
                    serializable = serializableArray[n3];
                    if (serializable == null) {
                        serializableArray[n3] = serializable = new StringTag();
                    }
                    n2 = ((StringTag)serializable).marshal(byArray, n2);
                }
            }
            if (this.longs.length != 0) {
                byArray[n2++] = 1;
                serializableArray = this.longs;
                n4 = serializableArray.length;
                if (n4 > colferListMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.Tags.longs length %d exceeds %d elements", n4, colferListMax));
                }
                while (n4 > 127) {
                    byArray[n2++] = (byte)(n4 | 0x80);
                    n4 >>>= 7;
                }
                byArray[n2++] = (byte)n4;
                for (n3 = 0; n3 < serializableArray.length; ++n3) {
                    serializable = serializableArray[n3];
                    if (serializable == null) {
                        serializableArray[n3] = serializable = new LongTag();
                    }
                    n2 = ((LongTag)serializable).marshal(byArray, n2);
                }
            }
            if (this.booleans.length != 0) {
                byArray[n2++] = 2;
                serializableArray = this.booleans;
                n4 = serializableArray.length;
                if (n4 > colferListMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.Tags.booleans length %d exceeds %d elements", n4, colferListMax));
                }
                while (n4 > 127) {
                    byArray[n2++] = (byte)(n4 | 0x80);
                    n4 >>>= 7;
                }
                byArray[n2++] = (byte)n4;
                for (n3 = 0; n3 < serializableArray.length; ++n3) {
                    serializable = serializableArray[n3];
                    if (serializable == null) {
                        serializableArray[n3] = serializable = new BooleanTag();
                    }
                    n2 = ((BooleanTag)serializable).marshal(byArray, n2);
                }
            }
            byArray[n2++] = 127;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n2 - n > colferSizeMax) {
                throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.Tags exceeds %d bytes", colferSizeMax));
            }
            if (n2 > byArray.length) {
                throw new BufferOverflowException();
            }
            throw arrayIndexOutOfBoundsException;
        }
    }

    public int unmarshal(byte[] byArray, int n) {
        return this.unmarshal(byArray, n, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unmarshal(byte[] byArray, int n, int n2) {
        int n3;
        block21: {
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            n3 = n;
            try {
                Serializable serializable;
                Serializable[] serializableArray;
                int n4;
                int n5;
                byte by = byArray[n3++];
                if (by == 0) {
                    n5 = 0;
                    int n6 = 0;
                    while (true) {
                        n4 = byArray[n3++];
                        n5 |= (n4 & 0x7F) << n6;
                        if (n6 == 28 || n4 >= 0) break;
                        n6 += 7;
                    }
                    if (n5 < 0 || n5 > colferListMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.Tags.strings length %d exceeds %d elements", n5, colferListMax));
                    }
                    serializableArray = new StringTag[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        serializable = new StringTag();
                        n3 = ((StringTag)serializable).unmarshal(byArray, n3, n2);
                        serializableArray[n4] = serializable;
                    }
                    this.strings = serializableArray;
                    by = byArray[n3++];
                }
                if (by == 1) {
                    n5 = 0;
                    int n7 = 0;
                    while (true) {
                        n4 = byArray[n3++];
                        n5 |= (n4 & 0x7F) << n7;
                        if (n7 == 28 || n4 >= 0) break;
                        n7 += 7;
                    }
                    if (n5 < 0 || n5 > colferListMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.Tags.longs length %d exceeds %d elements", n5, colferListMax));
                    }
                    serializableArray = new LongTag[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        serializable = new LongTag();
                        n3 = ((LongTag)serializable).unmarshal(byArray, n3, n2);
                        serializableArray[n4] = serializable;
                    }
                    this.longs = serializableArray;
                    by = byArray[n3++];
                }
                if (by == 2) {
                    n5 = 0;
                    int n8 = 0;
                    while (true) {
                        n4 = byArray[n3++];
                        n5 |= (n4 & 0x7F) << n8;
                        if (n8 == 28 || n4 >= 0) break;
                        n8 += 7;
                    }
                    if (n5 < 0 || n5 > colferListMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.Tags.booleans length %d exceeds %d elements", n5, colferListMax));
                    }
                    BooleanTag[] booleanTagArray = new BooleanTag[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        serializable = new BooleanTag();
                        n3 = ((BooleanTag)serializable).unmarshal(byArray, n3, n2);
                        booleanTagArray[n4] = serializable;
                    }
                    this.booleans = booleanTagArray;
                    by = byArray[n3++];
                }
                if (by != 127) {
                    throw new InputMismatchException(String.format("colfer: unknown header at byte %d", n3 - 1));
                }
                if (n3 <= n2 || n2 - n >= colferSizeMax) break block21;
            }
            catch (Throwable throwable) {
                if (n3 > n2 && n2 - n < colferSizeMax) {
                    throw new BufferUnderflowException();
                }
                if (n3 < 0 || n3 - n > colferSizeMax) {
                    throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.Tags exceeds %d bytes", colferSizeMax));
                }
                if (n3 > n2) {
                    throw new BufferUnderflowException();
                }
                throw throwable;
            }
            throw new BufferUnderflowException();
        }
        if (n3 < 0 || n3 - n > colferSizeMax) {
            throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.Tags exceeds %d bytes", colferSizeMax));
        }
        if (n3 > n2) {
            throw new BufferUnderflowException();
        }
        return n3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                byArray = new byte[4 * byArray.length];
                continue;
            }
            break;
        }
        objectOutputStream.writeInt(n);
        objectOutputStream.write(byArray, 0, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.init();
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        this.unmarshal(byArray, 0);
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.init();
    }

    public StringTag[] getStrings() {
        return this.strings;
    }

    public void setStrings(StringTag[] stringTagArray) {
        this.strings = stringTagArray;
    }

    public Tags withStrings(StringTag[] stringTagArray) {
        this.strings = stringTagArray;
        return this;
    }

    public LongTag[] getLongs() {
        return this.longs;
    }

    public void setLongs(LongTag[] longTagArray) {
        this.longs = longTagArray;
    }

    public Tags withLongs(LongTag[] longTagArray) {
        this.longs = longTagArray;
        return this;
    }

    public BooleanTag[] getBooleans() {
        return this.booleans;
    }

    public void setBooleans(BooleanTag[] booleanTagArray) {
        this.booleans = booleanTagArray;
    }

    public Tags withBooleans(BooleanTag[] booleanTagArray) {
        this.booleans = booleanTagArray;
        return this;
    }

    public final int hashCode() {
        int n = 1;
        for (StringTag serializable : this.strings) {
            n = 31 * n + (serializable == null ? 0 : serializable.hashCode());
        }
        for (Serializable serializable : this.longs) {
            n = 31 * n + (serializable == null ? 0 : ((LongTag)serializable).hashCode());
        }
        for (Serializable serializable : this.booleans) {
            n = 31 * n + (serializable == null ? 0 : ((BooleanTag)serializable).hashCode());
        }
        return n;
    }

    public final boolean equals(Object object) {
        return object instanceof Tags && this.equals((Tags)object);
    }

    public final boolean equals(Tags tags) {
        if (tags == null) {
            return false;
        }
        if (tags == this) {
            return true;
        }
        return tags.getClass() == Tags.class && Arrays.equals(this.strings, tags.strings) && Arrays.equals(this.longs, tags.longs) && Arrays.equals(this.booleans, tags.booleans);
    }

    public static class Unmarshaller {
        protected InputStream in;
        public byte[] buf;
        protected int offset;
        protected int i;

        public Unmarshaller(InputStream inputStream, byte[] byArray) {
            if (byArray == null || byArray.length == 0) {
                byArray = new byte[Math.min(colferSizeMax, 2048)];
            }
            this.buf = byArray;
            this.reset(inputStream);
        }

        public void reset(InputStream inputStream) {
            if (this.i != this.offset) {
                throw new IllegalStateException("colfer: pending data");
            }
            this.in = inputStream;
            this.offset = 0;
            this.i = 0;
        }

        public Tags next() throws IOException {
            if (this.in == null) {
                return null;
            }
            while (true) {
                if (this.i > this.offset) {
                    try {
                        Tags tags = new Tags();
                        this.offset = tags.unmarshal(this.buf, this.offset, this.i);
                        return tags;
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        // empty catch block
                    }
                }
                if (this.i <= this.offset) {
                    this.offset = 0;
                    this.i = 0;
                } else if (this.i == this.buf.length) {
                    byte[] byArray = this.buf;
                    if (this.offset == 0) {
                        this.buf = new byte[Math.min(colferSizeMax, this.buf.length * 4)];
                    }
                    System.arraycopy(byArray, this.offset, this.buf, 0, this.i - this.offset);
                    this.i -= this.offset;
                    this.offset = 0;
                }
                assert (this.i < this.buf.length);
                int n = this.in.read(this.buf, this.i, this.buf.length - this.i);
                if (n < 0) {
                    if (this.i > this.offset) {
                        throw new InputMismatchException("colfer: pending data with EOF");
                    }
                    return null;
                }
                assert (n > 0);
                this.i += n;
            }
        }
    }
}

