/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.common.handlers.EscapeHandler;
import org.dbunit.dataset.common.handlers.IllegalInputCharacterException;
import org.dbunit.dataset.common.handlers.IsAlnumHandler;
import org.dbunit.dataset.common.handlers.Pipeline;
import org.dbunit.dataset.common.handlers.PipelineException;
import org.dbunit.dataset.common.handlers.QuoteHandler;
import org.dbunit.dataset.common.handlers.SeparatorHandler;
import org.dbunit.dataset.common.handlers.TransparentHandler;
import org.dbunit.dataset.common.handlers.WhitespacesHandler;
import org.dbunit.dataset.csv.CsvParser;
import org.dbunit.dataset.csv.CsvParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvParserImpl
implements CsvParser {
    private static final Logger logger = LoggerFactory.getLogger(CsvParserImpl.class);
    private Pipeline pipeline;

    public CsvParserImpl() {
        this.resetThePipeline();
    }

    private void resetThePipeline() {
        logger.debug("resetThePipeline() - start");
        this.pipeline = new Pipeline();
        this.getPipeline().putFront(SeparatorHandler.ENDPIECE());
        this.getPipeline().putFront(EscapeHandler.ACCEPT());
        this.getPipeline().putFront(IsAlnumHandler.QUOTE());
        this.getPipeline().putFront(QuoteHandler.QUOTE());
        this.getPipeline().putFront(EscapeHandler.ESCAPE());
        this.getPipeline().putFront(WhitespacesHandler.IGNORE());
        this.getPipeline().putFront(TransparentHandler.IGNORE());
    }

    @Override
    public List parse(String csv) throws PipelineException, IllegalInputCharacterException {
        logger.debug("parse(csv={}) - start", (Object)csv);
        this.getPipeline().resetProducts();
        StringCharacterIterator iterator = new StringCharacterIterator(csv);
        char c = iterator.first();
        while (c != '\uffff') {
            this.getPipeline().handle(c);
            c = iterator.next();
        }
        this.getPipeline().noMoreInput();
        this.getPipeline().thePieceIsDone();
        return this.getPipeline().getProducts();
    }

    @Override
    public List parse(File file) throws IOException, CsvParserException {
        logger.debug("parse(file={}) - start", (Object)file);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            List list = this.parse(reader, file.getAbsolutePath().toString());
            return list;
        }
    }

    @Override
    public List parse(URL url) throws IOException, CsvParserException {
        logger.debug("parse(url={}) - start", (Object)url);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            List list = this.parse(reader, url.toString());
            return list;
        }
    }

    public List parse(Reader reader, String source) throws IOException, CsvParserException {
        logger.debug("parse(reader={}, source={}) - start", (Object)reader, (Object)source);
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        ArrayList rows = new ArrayList();
        List columnsInFirstLine = this.parseFirstLine(lineNumberReader, source, rows);
        this.parseTheData(columnsInFirstLine, lineNumberReader, rows);
        return rows;
    }

    private List parseFirstLine(LineNumberReader lineNumberReader, String source, List rows) throws IOException, CsvParserException {
        String firstLine;
        if (logger.isDebugEnabled()) {
            logger.debug("parseFirstLine(lineNumberReader={}, source={}, rows={}) - start", new Object[]{lineNumberReader, source, rows});
        }
        if ((firstLine = lineNumberReader.readLine()) == null) {
            throw new CsvParserException("The first line of " + source + " is null");
        }
        List columnsInFirstLine = this.parse(firstLine);
        rows.add(columnsInFirstLine);
        return columnsInFirstLine;
    }

    private void parseTheData(List columnsInFirstLine, LineNumberReader lineNumberReader, List rows) throws IOException, CsvParserException {
        List columns;
        logger.debug("parseTheData(columnsInFirstLine={}, lineNumberReader={}, rows={}) - start", new Object[]{columnsInFirstLine, lineNumberReader, rows});
        int nColumns = columnsInFirstLine.size();
        while ((columns = this.collectExpectedNumberOfColumns(nColumns, lineNumberReader)) != null) {
            rows.add(columns);
        }
    }

    private List collectExpectedNumberOfColumns(int expectedNumberOfColumns, LineNumberReader lineNumberReader) throws IOException, CsvParserException {
        if (logger.isDebugEnabled()) {
            logger.debug("collectExpectedNumberOfColumns(expectedNumberOfColumns={}, lineNumberReader={}) - start", (Object)String.valueOf(expectedNumberOfColumns), (Object)lineNumberReader);
        }
        List columns = null;
        int columnsCollectedSoFar = 0;
        StringBuffer buffer = new StringBuffer();
        String anotherLine = lineNumberReader.readLine();
        if (anotherLine == null) {
            return null;
        }
        boolean shouldProceed = false;
        while (columnsCollectedSoFar < expectedNumberOfColumns) {
            try {
                buffer.append(anotherLine);
                columns = this.parse(buffer.toString());
                columnsCollectedSoFar = columns.size();
            }
            catch (IllegalStateException e) {
                this.resetThePipeline();
                anotherLine = lineNumberReader.readLine();
                if (anotherLine == null) break;
                buffer.append("\n");
                shouldProceed = true;
            }
            if (!shouldProceed) break;
        }
        if (columnsCollectedSoFar != expectedNumberOfColumns) {
            String message = new StringBuffer("Expected ").append(expectedNumberOfColumns).append(" columns on line ").append(lineNumberReader.getLineNumber()).append(", got ").append(columnsCollectedSoFar).append(". Offending line: ").append(buffer).toString();
            throw new CsvParserException(message);
        }
        return columns;
    }

    Pipeline getPipeline() {
        logger.debug("getPipeline() - start");
        return this.pipeline;
    }

    void setPipeline(Pipeline pipeline) {
        logger.debug("setPipeline(pipeline={}) - start", (Object)pipeline);
        this.pipeline = pipeline;
    }
}

