/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.CompositeTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.LowerCaseTableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowerCaseDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(LowerCaseDataSet.class);
    private final IDataSet _dataSet;

    public LowerCaseDataSet(ITable table) throws DataSetException {
        this(new DefaultDataSet(table));
    }

    public LowerCaseDataSet(ITable[] tables) throws DataSetException {
        this(new DefaultDataSet(tables));
    }

    public LowerCaseDataSet(IDataSet dataSet) throws DataSetException {
        this._dataSet = dataSet;
    }

    private ITable createLowerTable(ITable table) throws DataSetException {
        logger.debug("createLowerTable(table={}) - start", (Object)table);
        return new CompositeTable((ITableMetaData)new LowerCaseTableMetaData(table.getTableMetaData()), table);
    }

    @Override
    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        return new LowerCaseIterator(reversed ? this._dataSet.reverseIterator() : this._dataSet.iterator());
    }

    @Override
    public String[] getTableNames() throws DataSetException {
        logger.debug("getTableNames() - start");
        String[] tableNames = super.getTableNames();
        int i = 0;
        while (i < tableNames.length) {
            tableNames[i] = tableNames[i].toLowerCase();
            ++i;
        }
        return tableNames;
    }

    @Override
    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName={}) - start", (Object)tableName);
        return new LowerCaseTableMetaData(super.getTableMetaData(tableName));
    }

    @Override
    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName={}) - start", (Object)tableName);
        return this.createLowerTable(super.getTable(tableName));
    }

    private class LowerCaseIterator
    implements ITableIterator {
        private final ITableIterator _iterator;

        public LowerCaseIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        @Override
        public boolean next() throws DataSetException {
            return this._iterator.next();
        }

        @Override
        public ITableMetaData getTableMetaData() throws DataSetException {
            return new LowerCaseTableMetaData(this._iterator.getTableMetaData());
        }

        @Override
        public ITable getTable() throws DataSetException {
            return LowerCaseDataSet.this.createLowerTable(this._iterator.getTable());
        }
    }
}

