/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.statement;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dbunit.database.statement.AbstractBatchStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStatement
extends AbstractBatchStatement {
    private static final Logger logger = LoggerFactory.getLogger(SimpleStatement.class);
    private final List _list = new ArrayList();

    SimpleStatement(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        logger.debug("addBatch(sql={}) - start", (Object)sql);
        this._list.add(sql);
    }

    @Override
    public int executeBatch() throws SQLException {
        logger.debug("executeBatch() - start");
        int result = 0;
        int i = 0;
        while (i < this._list.size()) {
            boolean r;
            String sql = (String)this._list.get(i);
            if (logger.isDebugEnabled()) {
                logger.debug("DbUnit SQL: " + sql);
            }
            if (!(r = this._statement.execute(sql))) {
                result += this._statement.getUpdateCount();
            }
            ++i;
        }
        return result;
    }

    @Override
    public void clearBatch() throws SQLException {
        logger.debug("clearBatch() - start");
        this._list.clear();
    }
}

