/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion.comparer.value.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dbunit.assertion.comparer.value.ValueComparer;
import org.dbunit.assertion.comparer.value.builder.ColumnValueComparerMapBuilder;

public class TableColumnValueComparerMapBuilder {
    private Map<String, Map<String, ValueComparer>> comparers = new HashMap<String, Map<String, ValueComparer>>();

    public TableColumnValueComparerMapBuilder add(Map<String, Map<String, ValueComparer>> tableColumnValueComparers) {
        this.comparers.putAll(tableColumnValueComparers);
        return this;
    }

    public TableColumnValueComparerMapBuilder add(TableColumnValueComparerMapBuilder tableColumnValueComparerMapBuilder) {
        Map<String, Map<String, ValueComparer>> map = tableColumnValueComparerMapBuilder.build();
        this.comparers.putAll(map);
        return this;
    }

    public TableColumnValueComparerMapBuilder add(String tableName, Map<String, ValueComparer> columnValueComparers) {
        Map<String, ValueComparer> map = this.findOrMakeColumnMap(tableName);
        map.putAll(columnValueComparers);
        return this;
    }

    public TableColumnValueComparerMapBuilder add(String tableName, ColumnValueComparerMapBuilder columnValueComparerMapBuilder) {
        Map<String, ValueComparer> map = this.findOrMakeColumnMap(tableName);
        Map<String, ValueComparer> columnMap = columnValueComparerMapBuilder.build();
        map.putAll(columnMap);
        return this;
    }

    public TableColumnValueComparerMapBuilder add(String tableName, String columnName, ValueComparer valueComparer) {
        Map<String, ValueComparer> map = this.findOrMakeColumnMap(tableName);
        map.put(columnName, valueComparer);
        return this;
    }

    public Map<String, Map<String, ValueComparer>> build() {
        return Collections.unmodifiableMap(this.comparers);
    }

    protected Map<String, ValueComparer> findOrMakeColumnMap(String tableName) {
        Map<String, ValueComparer> map = this.comparers.get(tableName);
        if (map == null) {
            map = this.makeColumnToValueComparerMap();
            this.comparers.put(tableName, map);
        }
        return map;
    }

    protected Map<String, ValueComparer> makeColumnToValueComparerMap() {
        return new HashMap<String, ValueComparer>();
    }
}

