/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Priority;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.interception.jaxrs.ServerReaderInterceptorContext;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyConfiguration;

@Provider
@Priority(value=4000)
public class GZIPDecodingInterceptor
implements ReaderInterceptor {
    private static final int DEFAULT_MAX_SIZE = 10000000;
    private int maxSize;

    public GZIPDecodingInterceptor(int maxSize) {
        this.maxSize = maxSize;
    }

    public GZIPDecodingInterceptor() {
        this.maxSize = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundReadFrom", (Object)this.getClass().getName());
        Object encoding = context.getHeaders().getFirst((Object)"Content-Encoding");
        if (encoding != null && encoding.toString().equalsIgnoreCase("gzip")) {
            InputStream old = context.getInputStream();
            FinishableGZIPInputStream is = new FinishableGZIPInputStream(old, context instanceof ServerReaderInterceptorContext, this.getMaxSize());
            context.setInputStream((InputStream)is);
            try {
                Object object = context.proceed();
                return object;
            }
            finally {
                if (!context.getType().equals(InputStream.class)) {
                    is.finish();
                }
                context.setInputStream(old);
            }
        }
        return context.proceed();
    }

    private int getMaxSize() {
        String s;
        if (this.maxSize != -1) {
            return this.maxSize;
        }
        int size = -1;
        ResteasyConfiguration context = ResteasyContext.getContextData(ResteasyConfiguration.class);
        if (context != null && (s = context.getParameter("resteasy.gzip.max.input")) != null) {
            try {
                size = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                LogMessages.LOGGER.invalidFormat("resteasy.gzip.max.input", Integer.toString(10000000));
            }
        }
        if (size == -1) {
            size = 10000000;
        }
        return size;
    }

    public static class FinishableGZIPInputStream
    extends GZIPInputStream {
        private int maxSize;
        private int count;
        private boolean server;

        public FinishableGZIPInputStream(InputStream is) throws IOException {
            this(is, true, 10000000);
        }

        public FinishableGZIPInputStream(InputStream is, boolean server) throws IOException {
            this(is, server, 10000000);
        }

        public FinishableGZIPInputStream(InputStream is, boolean server, int maxSize) throws IOException {
            super(is);
            this.server = server;
            this.maxSize = maxSize;
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            LogMessages.LOGGER.debugf("Interceptor : %s,  Method : read", (Object)this.getClass().getName());
            int n = super.read(buf, off, len);
            if (n > -1) {
                this.count += n;
            }
            if (this.count > this.maxSize) {
                this.finish();
                this.close();
                if (this.server) {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.REQUEST_ENTITY_TOO_LARGE).entity((Object)Messages.MESSAGES.gzipExceedsMaxSize(this.maxSize)).build());
                }
                throw new ProcessingException(Messages.MESSAGES.gzipExceedsMaxSize(this.maxSize));
            }
            return n;
        }

        public void finish() {
            this.inf.end();
        }
    }
}

