/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.JoseHeader;
import org.springframework.security.oauth2.client.endpoint.JwtClaimsSet;
import org.springframework.security.oauth2.client.endpoint.NimbusJwsEncoder;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jose.JwaAlgorithm;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class NimbusJwtClientAuthenticationParametersConverter<T extends AbstractOAuth2AuthorizationGrantRequest>
implements Converter<T, MultiValueMap<String, String>> {
    private static final String INVALID_KEY_ERROR_CODE = "invalid_key";
    private static final String INVALID_ALGORITHM_ERROR_CODE = "invalid_algorithm";
    private static final String CLIENT_ASSERTION_TYPE_VALUE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    private final Function<ClientRegistration, JWK> jwkResolver;
    private final Map<String, JwsEncoderHolder> jwsEncoders = new ConcurrentHashMap<String, JwsEncoderHolder>();

    public NimbusJwtClientAuthenticationParametersConverter(Function<ClientRegistration, JWK> jwkResolver) {
        Assert.notNull(jwkResolver, (String)"jwkResolver cannot be null");
        this.jwkResolver = jwkResolver;
    }

    public MultiValueMap<String, String> convert(T authorizationGrantRequest) {
        Assert.notNull(authorizationGrantRequest, (String)"authorizationGrantRequest cannot be null");
        ClientRegistration clientRegistration = ((AbstractOAuth2AuthorizationGrantRequest)authorizationGrantRequest).getClientRegistration();
        if (!ClientAuthenticationMethod.PRIVATE_KEY_JWT.equals((Object)clientRegistration.getClientAuthenticationMethod()) && !ClientAuthenticationMethod.CLIENT_SECRET_JWT.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            return null;
        }
        JWK jwk = this.jwkResolver.apply(clientRegistration);
        if (jwk == null) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_KEY_ERROR_CODE, "Failed to resolve JWK signing key for client registration '" + clientRegistration.getRegistrationId() + "'.", null);
            throw new OAuth2AuthorizationException(oauth2Error);
        }
        JwsAlgorithm jwsAlgorithm = NimbusJwtClientAuthenticationParametersConverter.resolveAlgorithm(jwk);
        if (jwsAlgorithm == null) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_ALGORITHM_ERROR_CODE, "Unable to resolve JWS (signing) algorithm from JWK associated to client registration '" + clientRegistration.getRegistrationId() + "'.", null);
            throw new OAuth2AuthorizationException(oauth2Error);
        }
        JoseHeader.Builder headersBuilder = JoseHeader.withAlgorithm((JwaAlgorithm)jwsAlgorithm);
        Instant issuedAt = Instant.now();
        Instant expiresAt = issuedAt.plus(Duration.ofSeconds(60L));
        JwtClaimsSet.Builder claimsBuilder = JwtClaimsSet.builder().issuer(clientRegistration.getClientId()).subject(clientRegistration.getClientId()).audience(Collections.singletonList(clientRegistration.getProviderDetails().getTokenUri())).id(UUID.randomUUID().toString()).issuedAt(issuedAt).expiresAt(expiresAt);
        JoseHeader joseHeader = headersBuilder.build();
        JwtClaimsSet jwtClaimsSet = claimsBuilder.build();
        JwsEncoderHolder jwsEncoderHolder = this.jwsEncoders.compute(clientRegistration.getRegistrationId(), (clientRegistrationId, currentJwsEncoderHolder) -> {
            if (currentJwsEncoderHolder != null && ((JwsEncoderHolder)currentJwsEncoderHolder).getJwk().equals((Object)jwk)) {
                return currentJwsEncoderHolder;
            }
            ImmutableJWKSet jwkSource = new ImmutableJWKSet(new JWKSet(jwk));
            return new JwsEncoderHolder(new NimbusJwsEncoder((JWKSource<SecurityContext>)jwkSource), jwk);
        });
        NimbusJwsEncoder jwsEncoder = jwsEncoderHolder.getJwsEncoder();
        Jwt jws = jwsEncoder.encode(joseHeader, jwtClaimsSet);
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"client_assertion_type", (Object)CLIENT_ASSERTION_TYPE_VALUE);
        parameters.set((Object)"client_assertion", (Object)jws.getTokenValue());
        return parameters;
    }

    private static JwsAlgorithm resolveAlgorithm(JWK jwk) {
        SignatureAlgorithm jwsAlgorithm = null;
        if (jwk.getAlgorithm() != null && (jwsAlgorithm = SignatureAlgorithm.from((String)jwk.getAlgorithm().getName())) == null) {
            jwsAlgorithm = MacAlgorithm.from((String)jwk.getAlgorithm().getName());
        }
        if (jwsAlgorithm == null) {
            if (KeyType.RSA.equals((Object)jwk.getKeyType())) {
                jwsAlgorithm = SignatureAlgorithm.RS256;
            } else if (KeyType.EC.equals((Object)jwk.getKeyType())) {
                jwsAlgorithm = SignatureAlgorithm.ES256;
            } else if (KeyType.OCT.equals((Object)jwk.getKeyType())) {
                jwsAlgorithm = MacAlgorithm.HS256;
            }
        }
        return jwsAlgorithm;
    }

    private static final class JwsEncoderHolder {
        private final NimbusJwsEncoder jwsEncoder;
        private final JWK jwk;

        private JwsEncoderHolder(NimbusJwsEncoder jwsEncoder, JWK jwk) {
            this.jwsEncoder = jwsEncoder;
            this.jwk = jwk;
        }

        private NimbusJwsEncoder getJwsEncoder() {
            return this.jwsEncoder;
        }

        private JWK getJwk() {
            return this.jwk;
        }
    }
}

