/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampDataType
extends AbstractDataType {
    private static final BigInteger ONE_BILLION = new BigInteger("1000000000");
    private static final Pattern TIMEZONE_REGEX = Pattern.compile("(.*)(?:\\W([+-][0-2][0-9][0-5][0-9]))");
    private static final Logger logger = LoggerFactory.getLogger(TimestampDataType.class);

    TimestampDataType() {
        super("TIMESTAMP", 93, Timestamp.class, false);
    }

    @Override
    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof Timestamp) {
            return value;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return new Timestamp(date.getTime());
        }
        if (value instanceof Long) {
            Long date = (Long)value;
            return new Timestamp(date);
        }
        if (value instanceof String) {
            String stringValue = value.toString();
            if (TimestampDataType.isExtendedSyntax(stringValue)) {
                try {
                    LocalDateTime datetime = RELATIVE_DATE_TIME_PARSER.parse(stringValue);
                    return Timestamp.valueOf(datetime);
                }
                catch (IllegalArgumentException | DateTimeParseException e) {
                    throw new TypeCastException(value, this, e);
                }
            }
            String zoneValue = null;
            Matcher tzMatcher = TIMEZONE_REGEX.matcher(stringValue);
            if (tzMatcher.matches() && tzMatcher.group(2) != null) {
                stringValue = tzMatcher.group(1);
                zoneValue = tzMatcher.group(2);
            }
            Timestamp ts = null;
            if (stringValue.length() == 10) {
                try {
                    long time = java.sql.Date.valueOf(stringValue).getTime();
                    ts = new Timestamp(time);
                }
                catch (IllegalArgumentException time) {
                    // empty catch block
                }
            }
            if (ts == null) {
                try {
                    ts = Timestamp.valueOf(stringValue);
                }
                catch (IllegalArgumentException e) {
                    throw new TypeCastException(value, this, e);
                }
            }
            if (zoneValue != null) {
                TimeZone localTZ = TimeZone.getDefault();
                BigInteger localTZOffset = BigInteger.valueOf(localTZ.getRawOffset());
                BigInteger time = BigInteger.valueOf(ts.getTime() / 1000L * 1000L).add(localTZOffset).multiply(ONE_BILLION).add(BigInteger.valueOf(ts.getNanos()));
                int hours = Integer.parseInt(zoneValue.substring(1, 3));
                int minutes = Integer.parseInt(zoneValue.substring(3, 5));
                BigInteger offsetAsSeconds = BigInteger.valueOf(hours * 3600 + minutes * 60);
                BigInteger offsetAsNanos = offsetAsSeconds.multiply(BigInteger.valueOf(1000L)).multiply(ONE_BILLION);
                time = zoneValue.charAt(0) == '+' ? time.subtract(offsetAsNanos) : time.add(offsetAsNanos);
                BigInteger[] components = time.divideAndRemainder(ONE_BILLION);
                ts = new Timestamp(components[0].longValue());
                ts.setNanos(components[1].intValue());
            }
            return ts;
        }
        throw new TypeCastException(value, this);
    }

    @Override
    public boolean isDateTime() {
        logger.debug("isDateTime() - start");
        return true;
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        Timestamp value;
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        if ((value = resultSet.getTimestamp(column)) == null || resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, new Integer(column), statement});
        }
        statement.setTimestamp(column, (Timestamp)this.typeCast(value));
    }
}

