/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.dbunit.database.CachedResultSetTable;
import org.dbunit.database.ForwardOnlyResultSetTable;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IResultSetTable;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedResultSetTableFactory
implements IResultSetTableFactory {
    private static final Logger logger = LoggerFactory.getLogger(CachedResultSetTableFactory.class);

    @Override
    public IResultSetTable createTable(String tableName, String selectStatement, IDatabaseConnection connection) throws SQLException, DataSetException {
        if (logger.isTraceEnabled()) {
            logger.trace("createTable(tableName={}, selectStatement={}, connection={}) - start", new Object[]{tableName, selectStatement, connection});
        }
        return new CachedResultSetTable(new ForwardOnlyResultSetTable(tableName, selectStatement, connection));
    }

    @Override
    public IResultSetTable createTable(ITableMetaData metaData, IDatabaseConnection connection) throws SQLException, DataSetException {
        logger.trace("createTable(metaData={}, connection={}) - start", (Object)metaData, (Object)connection);
        ForwardOnlyResultSetTable resultSetTable = new ForwardOnlyResultSetTable(metaData, connection);
        return new CachedResultSetTable(resultSetTable);
    }

    @Override
    public IResultSetTable createTable(String tableName, PreparedStatement preparedStatement, IDatabaseConnection connection) throws SQLException, DataSetException {
        if (logger.isTraceEnabled()) {
            logger.trace("createTable(tableName={}, preparedStatement={}, connection={}) - start", new Object[]{tableName, preparedStatement, connection});
        }
        ForwardOnlyResultSetTable table = new ForwardOnlyResultSetTableFactory().createForwardOnlyResultSetTable(tableName, preparedStatement, connection);
        return new CachedResultSetTable(table);
    }
}

