/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.MultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.SharedFieldCache;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparator;

public class SharedFieldSortComparator
extends SortComparator {
    static final SortComparator PROPERTIES = new SharedFieldSortComparator(FieldNames.PROPERTIES);
    private final String field;
    private final boolean createComparatorValues;

    public SharedFieldSortComparator(String fieldname) {
        this(fieldname, false);
    }

    public SharedFieldSortComparator(String fieldname, boolean createComparatorValues) {
        this.field = fieldname;
        this.createComparatorValues = createComparatorValues;
    }

    public ScoreDocComparator newComparator(IndexReader reader, String propertyName) throws IOException {
        final ArrayList readers = new ArrayList();
        this.getIndexReaders(readers, reader);
        final SharedFieldCache.StringIndex[] indexes = new SharedFieldCache.StringIndex[readers.size()];
        int maxDoc = 0;
        final int[] starts = new int[readers.size() + 1];
        for (int i = 0; i < readers.size(); ++i) {
            IndexReader r = (IndexReader)readers.get(i);
            starts[i] = maxDoc;
            maxDoc += r.maxDoc();
            indexes[i] = SharedFieldCache.INSTANCE.getStringIndex(r, this.field, FieldNames.createNamedValue(propertyName, ""), this, this.createComparatorValues);
        }
        starts[readers.size()] = maxDoc;
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                String jTerm;
                int idx1 = this.readerIndex(i.doc);
                int idx2 = this.readerIndex(j.doc);
                String iTerm = indexes[idx1].getTerm(i.doc - starts[idx1]);
                if (iTerm == (jTerm = indexes[idx2].getTerm(j.doc - starts[idx2]))) {
                    return 0;
                }
                if (iTerm == null) {
                    return -1;
                }
                if (jTerm == null) {
                    return 1;
                }
                return iTerm.compareTo(jTerm);
            }

            public Comparable sortValue(ScoreDoc i) {
                if (SharedFieldSortComparator.this.createComparatorValues) {
                    int idx = this.readerIndex(i.doc);
                    return indexes[idx].getTerm(i.doc - starts[idx]);
                }
                return "";
            }

            public int sortType() {
                return 9;
            }

            private int readerIndex(int n) {
                int lo = 0;
                int hi = readers.size() - 1;
                while (hi >= lo) {
                    int mid = lo + hi >> 1;
                    int midValue = starts[mid];
                    if (n < midValue) {
                        hi = mid - 1;
                        continue;
                    }
                    if (n > midValue) {
                        lo = mid + 1;
                        continue;
                    }
                    while (mid + 1 < readers.size() && starts[mid + 1] == midValue) {
                        ++mid;
                    }
                    return mid;
                }
                return hi;
            }
        };
    }

    protected Comparable getComparable(String termtext) {
        throw new UnsupportedOperationException();
    }

    private void getIndexReaders(List readers, IndexReader reader) {
        if (reader instanceof MultiIndexReader) {
            IndexReader[] r = ((MultiIndexReader)reader).getIndexReaders();
            for (int i = 0; i < r.length; ++i) {
                this.getIndexReaders(readers, r[i]);
            }
        } else {
            readers.add(reader);
        }
    }
}

