/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import ai.digital.deploy.sql.model.LoginProvider;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.platform.sso.oidc.authentication.CustomOidcIdTokenDecoderFactory;
import com.xebialabs.platform.sso.oidc.exceptions.UnsupportedOidcConfigurationException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.GrantedAuthoritiesExtractor;
import com.xebialabs.platform.sso.oidc.service.XLOidcUserService;
import com.xebialabs.platform.sso.oidc.web.CustomAuthorizationRequestResolver;
import com.xebialabs.platform.sso.oidc.web.OidcLogoutSuccessHandler;
import com.xebialabs.xldeploy.authentication.oidc.conf.OidcConfig;
import com.xebialabs.xlplatform.config.ConfigLoader$;
import com.xebialabs.xlplatform.config.ConfigurationHolder$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ConditionalOnProperty(name={"deploy.server.security.auth.provider"}, havingValue="oidc")
@EnableWebSecurity
@Configuration
@ComponentScan(value={"com.xebialabs.xldeploy.auth.oidc.config"})
@ScalaSignature(bytes="\u0006\u0005\tug\u0001B\u000e\u001d\u0001%BQ\u0001\u000f\u0001\u0005\u0002eBQ\u0001\u0010\u0001\u0005\u0002uBQA\u0014\u0001\u0005\u0002=CQa\u0018\u0001\u0005\u0002=CQ!\u0019\u0001\u0005\u0002\tDQ\u0001\u001d\u0001\u0005\u0002EDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA=\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!!.\u0001\t\u0003\t9\fC\u0004\u0002H\u0002!\t!!3\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"9\u0011Q\u001d\u0001\u0005\u0002\u0005\u001d\bbBA{\u0001\u0011\u0005\u0011q\u001f\u0005\b\u0005\u0003\u0001A\u0011\u0002B\u0002\u0011\u001d\u0011)\u0001\u0001C\u0005\u0005\u000fAqAa\u0006\u0001\t\u0013\u0011I\u0002C\u0004\u0003*\u0001!IAa\u000b\t\u000f\tm\u0003\u0001\"\u0003\u0003^!9!1\u000e\u0001\u0005\n\t5\u0004b\u0002B>\u0001\u0011%!Q\u0010\u0005\b\u0005\u000b\u0003A\u0011\u0001BD\u0005My\u0005/\u001a8JI\u000e{gN\\3di\u000e{gNZ5h\u0015\tib$\u0001\u0003d_:4'BA\u0010!\u0003\u0011y\u0017\u000eZ2\u000b\u0005\u0005\u0012\u0013AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003G\u0011\n\u0001\u0002\u001f7eKBdw.\u001f\u0006\u0003K\u0019\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u001d\n1aY8n\u0007\u0001\u00192\u0001\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0006g24GG\u001b\u0006\u0002k\u0005AqM]5{u2,G-\u0003\u00028e\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001;!\tY\u0004!D\u0001\u001d\u0003)y\u0017\u000eZ2D_:4\u0017nZ\u000b\u0002}A\u00111hP\u0005\u0003\u0001r\u0011!bT5eG\u000e{gNZ5hQ\t\u0011!\t\u0005\u0002D\u00196\tAI\u0003\u0002F\r\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u001dC\u0015aB2p]R,\u0007\u0010\u001e\u0006\u0003\u0013*\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0017\u0006\u0019qN]4\n\u00055#%\u0001\u0002\"fC:\f\u0011c\\5eG2{w-\u001b8Qe>4\u0018\u000eZ3s+\u0005\u0001\u0006CA)]\u001b\u0005\u0011&BA*U\u0003\u0015iw\u000eZ3m\u0015\t)f+A\u0002tc2T!a\u0016-\u0002\r\u0011,\u0007\u000f\\8z\u0015\tI&,A\u0004eS\u001eLG/\u00197\u000b\u0003m\u000b!!Y5\n\u0005u\u0013&!\u0004'pO&t\u0007K]8wS\u0012,'\u000f\u000b\u0002\u0004\u0005\u0006\u0011Bn\\2bY2{w-\u001b8Qe>4\u0018\u000eZ3sQ\t!!)\u0001\u000fdY&,g\u000e\u001e*fO&\u001cHO]1uS>t'+\u001a9pg&$xN]=\u0016\u0003\r\u0004\"\u0001Z7\u000e\u0003\u0015T!AZ4\u0002\u0019I,w-[:ue\u0006$\u0018n\u001c8\u000b\u0005!L\u0017AB2mS\u0016tGO\u0003\u0002kW\u00061q.Y;uQJR!\u0001\u001c%\u0002\u0011M,7-\u001e:jifL!A\\3\u0003I%sW*Z7pef\u001cE.[3oiJ+w-[:ue\u0006$\u0018n\u001c8SKB|7/\u001b;pefD#!\u0002\"\u0002A\rd\u0017-[7t)><%/\u00198uK\u0012\fU\u000f\u001e5pe&$\u0018.Z:Q_2L7-_\u000b\u0002eB\u00111/`\u0007\u0002i*\u0011QO^\u0001\u0005S6\u0004HN\u0003\u0002xq\u00061\u0001o\u001c7jGfT!aH=\u000b\u0005i\\\u0018aA:t_*\u0011A\u0010J\u0001\ta2\fGOZ8s[&\u0011a\u0010\u001e\u0002(\t\u00164\u0017-\u001e7u\u00072\f\u0017.\\:U_\u001e\u0013\u0018M\u001c;fI\u0006+H\u000f[8sSRLWm\u001d)pY&\u001c\u0017\u0010\u000b\u0002\u0007\u0005\u0006\u00113-^:u_6\fU\u000f\u001e5pe&T\u0018\r^5p]J+\u0017/^3tiJ+7o\u001c7wKJ$B!!\u0002\u0002\u0012A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\fa\f1a^3c\u0013\u0011\ty!!\u0003\u0003E\r+8\u000f^8n\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8SKF,Xm\u001d;SKN|GN^3s\u0011\u0019\tw\u00011\u0001\u0002\u0014A\u0019A-!\u0006\n\u0007\u0005]QM\u0001\u000fDY&,g\u000e\u001e*fO&\u001cHO]1uS>t'+\u001a9pg&$xN]=)\u0007\u001d\tY\u0002\u0005\u0003\u0002\u001e\u0005%RBAA\u0010\u0015\r)\u0015\u0011\u0005\u0006\u0005\u0003G\t)#A\u0004gC\u000e$xN]=\u000b\u0007\u0005\u001d\u0002*A\u0003cK\u0006t7/\u0003\u0003\u0002,\u0005}!!C!vi><\u0018N]3eQ\t9!)A\fbkRDwN]5{K\u0012\u001cE.[3oiN+'O^5dKR!\u00111GA\u001e!\u0011\t)$a\u000e\u000e\u0003\u001dL1!!\u000fh\u0005\u0015Je.T3n_JLx*Q;uQJ\nU\u000f\u001e5pe&TX\rZ\"mS\u0016tGoU3sm&\u001cW\r\u0003\u0004b\u0011\u0001\u0007\u00111\u0003\u0015\u0004\u0011\u0005m\u0001F\u0001\u0005C\u0003EAHnT5eGV\u001bXM]*feZL7-\u001a\u000b\u0005\u0003\u000b\n\t\u0006\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tY\u0005_\u0001\bg\u0016\u0014h/[2f\u0013\u0011\ty%!\u0013\u0003#acu*\u001b3d+N,'oU3sm&\u001cW\r\u0003\u0004q\u0013\u0001\u0007\u00111\u000b\t\u0005\u0003+\n9&D\u0001w\u0013\r\tIF\u001e\u0002!\u00072\f\u0017.\\:U_\u001e\u0013\u0018M\u001c;fI\u0006+H\u000f[8sSRLWm\u001d)pY&\u001c\u0017\u0010K\u0002\n\u00037A#!\u0003\"\u00025\u0005,H\u000f[8sSj,Gm\u00117jK:$(+\u001a9pg&$xN]=\u0015\t\u0005\r\u0014Q\u000e\t\u0005\u0003K\nI'\u0004\u0002\u0002h)\u0019\u00111B4\n\t\u0005-\u0014q\r\u00027\u0003V$\b.\u001a8uS\u000e\fG/\u001a3Qe&t7-\u001b9bY>\u000bU\u000f\u001e53\u0003V$\bn\u001c:ju\u0016$7\t\\5f]R\u0014V\r]8tSR|'/\u001f\u0005\b\u0003_Q\u0001\u0019AA8!\u0011\t)$!\u001d\n\u0007\u0005MtMA\u000fP\u0003V$\bNM!vi\"|'/\u001b>fI\u000ec\u0017.\u001a8u'\u0016\u0014h/[2fQ\rQ\u00111\u0004\u0015\u0003\u0015\t\u000bQ#\u001b3U_.,g\u000eR3d_\u0012,'OR1di>\u0014\u00180\u0006\u0002\u0002~A1\u0011qPAC\u0003\u0013k!!!!\u000b\u0007\u0005\r\u0015.A\u0002koRLA!a\"\u0002\u0002\n\t\"j\u001e;EK\u000e|G-\u001a:GC\u000e$xN]=\u0011\u0007\u0011\fY)C\u0002\u0002\u000e\u0016\u0014!c\u00117jK:$(+Z4jgR\u0014\u0018\r^5p]\"\u00121BQ\u0001\u000bU^$H)Z2pI\u0016\u0014XCAAK!\u0011\ty(a&\n\t\u0005e\u0015\u0011\u0011\u0002\u000b\u0015^$H)Z2pI\u0016\u0014\bF\u0001\u0007C\u0003iQw\u000f^!vi\",g\u000e^5dCRLwN\\\"p]Z,'\u000f^3s+\t\t\t\u000b\u0005\u0003\u0002$\u0006=VBAAS\u0015\r\t\u0013q\u0015\u0006\u0005\u0003S\u000bY+\u0001\u0005sKN|WO]2f\u0015\r\ti+[\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005E\u0016Q\u0015\u0002\u001b\u0015^$\u0018)\u001e;iK:$\u0018nY1uS>t7i\u001c8wKJ$XM\u001d\u0015\u0003\u001b\t\u000bA%Y;uQ>\u0014\u0018N_1uS>t7i\u001c3f)>\\WM\u001c*fgB|gn]3DY&,g\u000e^\u000b\u0003\u0003s\u0003B!a/\u0002B6\u0011\u0011Q\u0018\u0006\u0004\u0003\u007f;\u0017\u0001C3oIB|\u0017N\u001c;\n\t\u0005\r\u0017Q\u0018\u0002,\t\u00164\u0017-\u001e7u\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8D_\u0012,Gk\\6f]J+7\u000f]8og\u0016\u001cE.[3oi\"\u0012aBQ\u0001\u0018_&$7\rT8hS:4\u0015-\u001b7ve\u0016D\u0015M\u001c3mKJ,\"!a3\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fT1!IAi\u0015\r\tYa[\u0005\u0005\u0003+\fyM\u0001\u000fBkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3IC:$G.\u001a:)\u0005=\u0011\u0015A\u0006=mI2{w-\u001b8GC&dWO]3IC:$G.\u001a:\u0016\u0005\u0005u\u0007\u0003BAg\u0003?LA!!9\u0002P\n)3+[7qY\u0016,&\u000f\\!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a%b]\u0012dWM\u001d\u0015\u0003!\t\u000b!d\u001c9f]&#Gj\\4pkR\u001cVoY2fgND\u0015M\u001c3mKJ$B!!;\u0002pB!\u0011qAAv\u0013\u0011\ti/!\u0003\u00031=KGm\u0019'pO>,HoU;dG\u0016\u001c8\u000fS1oI2,'\u000f\u0003\u0004b#\u0001\u0007\u00111\u0003\u0015\u0004#\u0005m\u0001FA\tC\u0003\u0001bwnZ5o+Jd\u0017)\u001e;iK:$\u0018nY1uS>tWI\u001c;ssB{\u0017N\u001c;\u0016\u0005\u0005e\b\u0003BAg\u0003wLA!!@\u0002P\n\u0001Cj\\4j]V\u0013H.Q;uQ\u0016tG/[2bi&|g.\u00128uef\u0004v.\u001b8uQ\t\u0011\")\u0001\ndY&,g\u000e\u001e*fO&\u001cHO]1uS>tWCAAE\u0003q9W\r^\"mS\u0016tGOU3hSN$(/\u0019;j_:\u0014U/\u001b7eKJ,\"A!\u0003\u0011\t\t-!\u0011\u0003\b\u0004I\n5\u0011b\u0001B\bK\u0006\u00112\t\\5f]R\u0014VmZ5tiJ\fG/[8o\u0013\u0011\u0011\u0019B!\u0006\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0019!qB3\u00021\rd\u0017.\u001a8u\u0011R$\bOU3rk\u0016\u001cHOR1di>\u0014\u00180\u0006\u0002\u0003\u001cA!!Q\u0004B\u0013\u001b\t\u0011yBC\u0002i\u0005CQ1Aa\tI\u0003\u0011AG\u000f\u001e9\n\t\t\u001d\"q\u0004\u0002\u0019\u00072LWM\u001c;IiR\u0004(+Z9vKN$h)Y2u_JL\u0018aD4fi*;8/\u00117h_JLG\u000f[7\u0015\r\t5\"Q\bB,!\u0011\u0011yC!\u000f\u000e\u0005\tE\"\u0002\u0002B\u001a\u0005k\t1A[<t\u0015\r\u00119$[\u0001\u0005U>\u001cX-\u0003\u0003\u0003<\tE\"\u0001\u0004&xg\u0006cwm\u001c:ji\"l\u0007b\u0002B -\u0001\u0007!\u0011I\u0001\rU^\u001c\u0018\t\\4pe&$\b.\u001c\t\u0005\u0005\u0007\u0012\tF\u0004\u0003\u0003F\t5\u0003c\u0001B$Y5\u0011!\u0011\n\u0006\u0004\u0005\u0017B\u0013A\u0002\u001fs_>$h(C\u0002\u0003P1\na\u0001\u0015:fI\u00164\u0017\u0002\u0002B*\u0005+\u0012aa\u0015;sS:<'b\u0001B(Y!9!\u0011\f\fA\u0002\t\u0005\u0013\u0001\u00049s_B,'\u000f^=OC6,\u0017aE4fi\u000ec\u0017.\u001a8u\u0003V$\b.T3uQ>$WC\u0001B0!\u0011\u0011\tGa\u001a\u000e\u0005\t\r$b\u0001B3S\u0006!1m\u001c:f\u0013\u0011\u0011IGa\u0019\u00035\rc\u0017.\u001a8u\u0003V$\b.\u001a8uS\u000e\fG/[8o\u001b\u0016$\bn\u001c3\u00025\u001d,GOS<u\u001f\u0006+H\u000f\u001b\u001aU_.,gNV1mS\u0012\fGo\u001c:\u0016\u0005\t=\u0004C\u0002B1\u0005c\u0012)(\u0003\u0003\u0003t\t\r$\u0001F(BkRD'\u0007V8lK:4\u0016\r\\5eCR|'\u000f\u0005\u0003\u0002\u0000\t]\u0014\u0002\u0002B=\u0003\u0003\u00131AS<u\u0003e1\u0018\r\\5eCR,w*\u001b3d\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0005\t}\u0004cA\u0016\u0003\u0002&\u0019!1\u0011\u0017\u0003\tUs\u0017\u000e^\u0001\u001eO\u0016$XI\u001d:pe6+7o]1hK\u001a{'\u000f\u00157bG\u0016Dw\u000e\u001c3feR!!\u0011\tBE\u0011\u001d\u0011YI\u0007a\u0001\u0005\u0003\n1\u0002\u001d7bG\u0016Dw\u000e\u001c3fe\":\u0001Aa$\u0003\u0016\n]\u0005cA\"\u0003\u0012&\u0019!1\u0013#\u0003\u001b\r{W\u000e]8oK:$8kY1o\u0003\u00151\u0018\r\\;fY\t\u0011I*\t\u0002\u0003\u001c\u000693m\\7/q\u0016\u0014\u0017.\u00197bENt\u0003\u0010\u001c3fa2|\u0017PL1vi\"ts.\u001b3d]\r|gNZ5hQ\r\u0001!q\u0014\t\u0004\u0007\n\u0005\u0016b\u0001BR\t\ni1i\u001c8gS\u001e,(/\u0019;j_:D3\u0001\u0001BT!\u0011\u0011IKa.\u000e\u0005\t-&\u0002\u0002BW\u0005_\u000bQbY8oM&<WO]1uS>t'\u0002BA\u0006\u0005cS1!\u0012BZ\u0015\r\u0011)l[\u0001\u0007G>tg-[4\n\t\te&1\u0016\u0002\u0012\u000b:\f'\r\\3XK\n\u001cVmY;sSRL\bf\u0003\u0001\u0003>\nE'1\u001bBm\u00057\u0004BAa0\u0003N6\u0011!\u0011\u0019\u0006\u0005\u0005\u0007\u0014)-A\u0005d_:$\u0017\u000e^5p]*!!q\u0019Be\u00035\tW\u000f^8d_:4\u0017nZ;sK*\u0019!1\u001a%\u0002\t\t|w\u000e^\u0005\u0005\u0005\u001f\u0014\tMA\u000bD_:$\u0017\u000e^5p]\u0006dwJ\u001c)s_B,'\u000f^=\u0002\t9\fW.\u001a\u0017\u0003\u0005+\f#Aa6\u0002I\u0011,\u0007\u000f\\8z]M,'O^3s]M,7-\u001e:jift\u0013-\u001e;i]A\u0014xN^5eKJ\f1\u0002[1wS:<g+\u00197vK\u0006\nq\u0004")
public class OpenIdConnectConfig
implements Logging {
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        OpenIdConnectConfig openIdConnectConfig = this;
        synchronized (openIdConnectConfig) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean
    public OidcConfig oidcConfig() {
        return new OidcConfig(ConfigLoader$.MODULE$.loadWithDynamic(ConfigurationHolder$.MODULE$.get(), ConfigLoader$.MODULE$.loadWithDynamic$default$2()), ServerConfiguration.getInstance());
    }

    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.oidcConfig().loginMethodDescription(), new StringBuilder(1).append(".").append(this.oidcConfig().external_login()).toString(), "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    public InMemoryClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
    }

    @Bean
    public DefaultClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.oidcConfig().rolesClaimName());
    }

    @Bean
    @Autowired
    public CustomAuthorizationRequestResolver customAuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        return new CustomAuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
    }

    @Bean
    @Autowired
    public InMemoryOAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @Autowired
    public XLOidcUserService xlOidcUserService(ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        return new XLOidcUserService(claimsToGrantedAuthoritiesPolicy);
    }

    @Bean
    @Autowired
    public AuthenticatedPrincipalOAuth2AuthorizedClientRepository authorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        void var3_3;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().idTokenJWSAlg(), "idTokenJWSAlg");
        CustomOidcIdTokenDecoderFactory idTokenDecoderFactory = new CustomOidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwsAlgorithmResolver(x$1 -> jwsAlgorithm);
        idTokenDecoderFactory.setRestOperations((RestOperations)restTemplate);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtDecoder jwtDecoder() {
        void var3_9;
        NimbusJwtDecoder nimbusJwtDecoder;
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().accessTokenJWSAlg(), "jwsAlg");
        JwsAlgorithm jwsAlgorithm2 = jwsAlgorithm;
        if (jwsAlgorithm2 instanceof SignatureAlgorithm) {
            SignatureAlgorithm signatureAlgorithm = (SignatureAlgorithm)jwsAlgorithm2;
            String jwkSetUri = Strings.isNotBlank((String)this.oidcConfig().accessTokenKeyUri()) ? this.oidcConfig().accessTokenKeyUri() : this.clientRegistration().getProviderDetails().getJwkSetUri();
            nimbusJwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(signatureAlgorithm).build();
        } else if (jwsAlgorithm2 instanceof MacAlgorithm) {
            MacAlgorithm macAlgorithm = (MacAlgorithm)jwsAlgorithm2;
            scala.collection.immutable.Map mappings = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MacAlgorithm.HS256), (Object)"HmacSHA256"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MacAlgorithm.HS384), (Object)"HmacSHA384"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MacAlgorithm.HS512), (Object)"HmacSHA512")}));
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenSecretKey()), (String)"No configuration setting found for key 'deploy.security.auth.providers.oidc.access-token.secretKey'", (Object[])new Object[0]);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.oidcConfig().accessTokenSecretKey().getBytes(StandardCharsets.UTF_8), (String)mappings.get((Object)macAlgorithm));
            nimbusJwtDecoder = NimbusJwtDecoder.withSecretKey((SecretKey)secretKeySpec).macAlgorithm(macAlgorithm).build();
        } else {
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        NimbusJwtDecoder jwtDecoder = nimbusJwtDecoder;
        jwtDecoder.setJwtValidator(this.getJwtOAuth2TokenValidator());
        return var3_9;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtAuthenticationConverter jwtAuthenticationConverter() {
        void var1_1;
        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setPrincipalClaimName(this.oidcConfig().userNameClaimName());
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new GrantedAuthoritiesExtractor((ClaimsToGrantedAuthoritiesPolicy)this.claimsToGrantedAuthoritiesPolicy()));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient() {
        void var3_3;
        ListBuffer messageConverter = new ListBuffer();
        messageConverter.$plus$eq((Object)new FormHttpMessageConverter());
        messageConverter.$plus$eq((Object)new OAuth2AccessTokenResponseHttpMessageConverter());
        RestTemplate restTemplate = new RestTemplate(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)messageConverter.toList()).asJava());
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
        authorizationCodeTokenResponseClient.setRestOperations((RestOperations)restTemplate);
        return var3_3;
    }

    @Bean
    public AuthenticationFailureHandler oidcLoginFailureHandler() {
        return (x$2, response, x$3) -> response.sendRedirect(this.oidcConfig().external_login());
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler xldLoginFailureHandler() {
        return new SimpleUrlAuthenticationFailureHandler();
    }

    @Bean
    @Autowired
    public OidcLogoutSuccessHandler openIdLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        return new OidcLogoutSuccessHandler(clientRegistrationRepository, this.oidcConfig().postLogoutRedirectUri(), "/login");
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.oidcConfig().external_login());
    }

    private ClientRegistration clientRegistration() {
        BoxedUnit boxedUnit;
        ClientRegistration.Builder clientRegistrationBuilder = this.getClientRegistrationBuilder();
        ClientAuthenticationMethod authenticationMethod = this.getClientAuthMethod();
        clientRegistrationBuilder.clientId(this.oidcConfig().clientId()).clientAuthenticationMethod(authenticationMethod).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri(this.oidcConfig().redirectUri()).userInfoUri("").scope(this.oidcConfig().scopes()).userNameAttributeName(this.oidcConfig().userNameClaimName());
        ClientAuthenticationMethod clientAuthenticationMethod = authenticationMethod;
        ClientAuthenticationMethod clientAuthenticationMethod2 = ClientAuthenticationMethod.NONE;
        if (clientAuthenticationMethod == null ? clientAuthenticationMethod2 != null : !clientAuthenticationMethod.equals(clientAuthenticationMethod2)) {
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().clientSecret()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.clientSecret"), (Object[])new Object[0]);
            boxedUnit = clientRegistrationBuilder.clientSecret(this.oidcConfig().clientSecret());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()) ? clientRegistrationBuilder.authorizationUri(this.oidcConfig().userAuthorizationUri()) : BoxedUnit.UNIT;
        Object object2 = Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()) ? clientRegistrationBuilder.tokenUri(this.oidcConfig().accessTokenUri()) : BoxedUnit.UNIT;
        Object object3 = Strings.isNotBlank((String)this.oidcConfig().jwks_uri()) ? clientRegistrationBuilder.jwkSetUri(this.oidcConfig().jwks_uri()) : BoxedUnit.UNIT;
        ClientRegistration clientRegistration = clientRegistrationBuilder.build();
        Map configurationMetadata = clientRegistration.getProviderDetails().getConfigurationMetadata();
        HashMap<String, String> updatedConfigurationMetadata = new HashMap<String, String>(configurationMetadata);
        updatedConfigurationMetadata.put("rolesClaim", this.oidcConfig().rolesClaimName());
        Object object4 = Strings.isNotBlank((String)this.oidcConfig().logoutUri()) ? updatedConfigurationMetadata.put("end_session_endpoint", this.oidcConfig().logoutUri()) : BoxedUnit.UNIT;
        return ClientRegistration.withClientRegistration((ClientRegistration)clientRegistration).providerConfigurationMetadata(updatedConfigurationMetadata).build();
    }

    private ClientRegistration.Builder getClientRegistrationBuilder() {
        ClientRegistration.Builder builder;
        try {
            if (!this.oidcConfig().issuer().matches("\\S+")) {
                throw new UnsupportedOidcConfigurationException(new StringBuilder(148).append("Whitespace characters in issuer url [").append(this.oidcConfig().issuer()).append("] is not supported. Recommendation is to avoid using spaces in URLs, and instead use hyphens to separate words.").toString());
            }
            builder = ClientRegistrations.fromOidcIssuerLocation((String)this.oidcConfig().issuer()).registrationId(this.oidcConfig().registrationId());
        }
        catch (RuntimeException re) {
            RuntimeException runtimeException = re;
            if (runtimeException instanceof IllegalArgumentException) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(62).append("Unable to resolve Configuration with the provided Issuer of [").append(this.oidcConfig().issuer()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (runtimeException instanceof UnsupportedOidcConfigurationException) {
                this.logger().warn((Function0 & Serializable)() -> re.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)runtimeException);
            }
            this.validateOidcConfiguration();
            builder = ClientRegistration.withRegistrationId((String)this.oidcConfig().registrationId());
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private ClientHttpRequestFactory clientHttpRequestFactory() {
        void var1_1;
        block0: {
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            if (!Strings.isNotEmpty((String)this.oidcConfig().proxyHost())) break block0;
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.oidcConfig().proxyHost(), Predef$.MODULE$.Integer2int(this.oidcConfig().proxyPort()))));
        }
        return var1_1;
    }

    private JwsAlgorithm getJwsAlgorithm(String jwsAlgorithm, String propertyName) {
        scala.collection.immutable.Map jwsAlgorithms = (scala.collection.immutable.Map)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SignatureAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MacAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return (JwsAlgorithm)jwsAlgorithms.getOrElse((Object)jwsAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(77).append(propertyName).append(" value [").append(jwsAlgorithm).append("] is not supported. Ensure you have configured a valid JWS Algorithm.").toString());
        });
    }

    private ClientAuthenticationMethod getClientAuthMethod() {
        scala.collection.immutable.Map clientAuthMethods = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_basic"), (Object)ClientAuthenticationMethod.BASIC), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_post"), (Object)ClientAuthenticationMethod.POST), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"none"), (Object)ClientAuthenticationMethod.NONE)}));
        return (ClientAuthenticationMethod)clientAuthMethods.getOrElse((Object)this.oidcConfig().clientAuthMethod().toLowerCase(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(108).append("clientAuthMethod value [").append(this.oidcConfig().clientAuthMethod()).append(" is not supported. Ensure you have configured a valid client authentication method.]").toString());
        });
    }

    private OAuth2TokenValidator<Jwt> getJwtOAuth2TokenValidator() {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(Strings.isNotBlank((String)this.oidcConfig().accessTokenIssuer()) ? this.oidcConfig().accessTokenIssuer() : this.oidcConfig().issuer()));
        validators.add(new JwtClaimValidator("aud", aud -> aud.contains(Strings.isNotBlank((String)this.oidcConfig().accessTokenAudience()) ? this.oidcConfig().accessTokenAudience() : this.oidcConfig().clientId())));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    private void validateOidcConfiguration() {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.userAuthorizationUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.accessTokenUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().jwks_uri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.keyRetrievalUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().logoutUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.logoutUri"), (Object[])new Object[0]);
    }

    public String getErrorMessageForPlaceholder(String placeholder) {
        return new StringBuilder(41).append("No configuration setting found for key '").append(placeholder).append("'").toString();
    }

    public OpenIdConnectConfig() {
        Logging.$init$((Logging)this);
    }
}

