/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.ExceptionHandler;
import org.jboss.resteasy.core.InternalDispatcher;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.PostResourceMethodInvokers;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext;
import org.jboss.resteasy.plugins.server.Cleanable;
import org.jboss.resteasy.plugins.server.Cleanables;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.specimpl.RequestImpl;
import org.jboss.resteasy.spi.Dispatcher;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpRequestPreprocessor;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnhandledException;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;

public class SynchronousDispatcher
implements Dispatcher {
    protected ResteasyProviderFactory providerFactory;
    protected Registry registry;
    protected List<HttpRequestPreprocessor> requestPreprocessors = new ArrayList<HttpRequestPreprocessor>();
    protected Map<Class, Object> defaultContextObjects = new HashMap<Class, Object>();
    protected Set<String> unwrappedExceptions = new HashSet<String>();
    protected boolean bufferExceptionEntityRead = false;
    protected boolean bufferExceptionEntity = true;

    public SynchronousDispatcher(ResteasyProviderFactory providerFactory) {
        LogMessages logMessages = LogMessages.LOGGER;
        this.providerFactory = providerFactory;
        this.registry = new ResourceMethodRegistry(providerFactory);
        this.defaultContextObjects.put(Providers.class, providerFactory);
        this.defaultContextObjects.put(Registry.class, this.registry);
        this.defaultContextObjects.put(Dispatcher.class, this);
        this.defaultContextObjects.put(InternalDispatcher.class, InternalDispatcher.getInstance());
    }

    public SynchronousDispatcher(ResteasyProviderFactory providerFactory, ResourceMethodRegistry registry) {
        this(providerFactory);
        this.registry = registry;
        this.defaultContextObjects.put(Registry.class, registry);
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Map<Class, Object> getDefaultContextObjects() {
        return this.defaultContextObjects;
    }

    public Set<String> getUnwrappedExceptions() {
        return this.unwrappedExceptions;
    }

    public Response preprocess(HttpRequest request) {
        RESTEasyTracingLogger.initTracingSupport((Configuration)this.providerFactory, request);
        Response aborted = null;
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(request);
        try {
            long totalTimestamp = tracingLogger.timestamp("PRE_MATCH_SUMMARY");
            for (HttpRequestPreprocessor preprocessor : this.requestPreprocessors) {
                long timestamp = tracingLogger.timestamp("PRE_MATCH");
                preprocessor.preProcess(request);
                tracingLogger.logDuration("PRE_MATCH", timestamp, preprocessor.getClass().toString());
            }
            tracingLogger.logDuration("PRE_MATCH_SUMMARY", totalTimestamp, this.requestPreprocessors.size());
            ContainerRequestFilter[] requestFilters = (ContainerRequestFilter[])this.providerFactory.getContainerRequestFilterRegistry().preMatch();
            PreMatchContainerRequestContext requestContext = new PreMatchContainerRequestContext(request, requestFilters, null);
            aborted = requestContext.filter();
        }
        catch (Exception e) {
            aborted = new ExceptionHandler(this.providerFactory, this.unwrappedExceptions).handleException(request, e);
        }
        return aborted;
    }

    protected void preprocess(HttpRequest request, HttpResponse response, Runnable continuation) {
        BuiltResponse aborted = null;
        PreMatchContainerRequestContext requestContext = null;
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(request);
        try {
            long totalTimestamp = tracingLogger.timestamp("PRE_MATCH_SUMMARY");
            for (HttpRequestPreprocessor preprocessor : this.requestPreprocessors) {
                long timestamp = tracingLogger.timestamp("PRE_MATCH");
                preprocessor.preProcess(request);
                tracingLogger.logDuration("PRE_MATCH", timestamp, preprocessor.getClass().toString());
            }
            tracingLogger.logDuration("PRE_MATCH_SUMMARY", totalTimestamp, this.requestPreprocessors.size());
            ContainerRequestFilter[] requestFilters = (ContainerRequestFilter[])this.providerFactory.getContainerRequestFilterRegistry().preMatch();
            requestContext = new PreMatchContainerRequestContext(request, requestFilters, () -> {
                continuation.run();
                return null;
            });
            aborted = requestContext.filter();
        }
        catch (Exception e) {
            if (requestContext == null || !requestContext.startedContinuation()) {
                this.writeException(request, response, e, t -> {});
                return;
            }
            SynchronousDispatcher.rethrow(e);
        }
        if (aborted != null) {
            tracingLogger.log("FINISHED", response.getStatus());
            tracingLogger.flush((MultivaluedMap<String, Object>)response.getOutputHeaders());
            this.writeResponse(request, response, aborted);
            return;
        }
    }

    public static <T extends Throwable> void rethrow(Throwable t) throws T {
        throw t;
    }

    @Deprecated
    public void writeException(HttpRequest request, HttpResponse response, Throwable e) {
        this.writeException(request, response, e, t -> {});
    }

    public void writeException(HttpRequest request, HttpResponse response, Throwable e, Consumer<Throwable> onComplete) {
        if (!this.bufferExceptionEntityRead) {
            String s;
            this.bufferExceptionEntityRead = true;
            ResteasyConfiguration context = ResteasyContext.getContextData(ResteasyConfiguration.class);
            if (context != null && (s = context.getParameter("resteasy.buffer.exception.entity")) != null) {
                this.bufferExceptionEntity = Boolean.parseBoolean(s);
            }
        }
        if (response.isCommitted() && response.suppressExceptionDuringChunkedTransfer()) {
            LogMessages.LOGGER.debug((Object)Messages.MESSAGES.responseIsCommitted());
            onComplete.accept(null);
            return;
        }
        Response handledResponse = new ExceptionHandler(this.providerFactory, this.unwrappedExceptions).handleException(request, e);
        if (handledResponse == null) {
            throw new UnhandledException(e);
        }
        if (!this.bufferExceptionEntity) {
            response.getOutputHeaders().add((Object)"resteasy.buffer.exception.entity", (Object)"false");
        }
        try {
            ServerResponseWriter.writeNomapResponse((BuiltResponse)handledResponse, request, response, this.providerFactory, onComplete);
        }
        catch (Exception e1) {
            try {
                throw new UnhandledException((Throwable)e1);
            }
            catch (Throwable throwable) {
                RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(request);
                tracingLogger.log("FINISHED", response.getStatus());
                tracingLogger.flush((MultivaluedMap<String, Object>)response.getOutputHeaders());
                throw throwable;
            }
        }
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(request);
        tracingLogger.log("FINISHED", response.getStatus());
        tracingLogger.flush((MultivaluedMap<String, Object>)response.getOutputHeaders());
    }

    public void invoke(HttpRequest request, HttpResponse response) {
        RESTEasyTracingLogger.initTracingSupport((Configuration)this.providerFactory, request);
        RESTEasyTracingLogger.logStart(request);
        try {
            this.pushContextObjects(request, response);
            this.preprocess(request, response, () -> {
                ResourceInvoker invoker = null;
                try {
                    try {
                        invoker = this.getInvoker(request);
                    }
                    catch (Exception exception) {
                        this.writeException(request, response, exception, t -> {});
                        this.clearContextData();
                        return;
                    }
                    this.invoke(request, response, invoker);
                }
                finally {
                    this.clearContextData();
                }
            });
        }
        finally {
            this.clearContextData();
        }
    }

    public void invokePropagateNotFound(HttpRequest request, HttpResponse response) throws NotFoundException {
        try {
            this.pushContextObjects(request, response);
            this.preprocess(request, response, () -> {
                ResourceInvoker invoker = null;
                try {
                    try {
                        invoker = this.getInvoker(request);
                    }
                    catch (Exception failure) {
                        if (failure instanceof NotFoundException) {
                            throw (NotFoundException)failure;
                        }
                        this.writeException(request, response, failure, t -> {});
                        this.clearContextData();
                        return;
                    }
                    this.invoke(request, response, invoker);
                }
                finally {
                    this.clearContextData();
                }
            });
        }
        finally {
            this.clearContextData();
        }
    }

    public ResourceInvoker getInvoker(HttpRequest request) throws Failure {
        LogMessages.LOGGER.pathInfo(request.getUri().getPath());
        if (!request.isInitial()) {
            throw new InternalServerErrorException(Messages.MESSAGES.isNotInitialRequest(request.getUri().getPath()));
        }
        ResourceInvoker invoker = this.registry.getResourceInvoker(request);
        if (invoker == null) {
            throw new NotFoundException(Messages.MESSAGES.unableToFindJaxRsResource(request.getUri().getPath()));
        }
        RESTEasyTracingLogger logger = RESTEasyTracingLogger.getInstance(request);
        logger.log("MATCH_RESOURCE", invoker);
        logger.log("MATCH_RESOURCE_METHOD", invoker.getMethod());
        return invoker;
    }

    public void pushContextObjects(final HttpRequest request, final HttpResponse response) {
        Map<Class<?>, Object> contextDataMap = ResteasyContext.getContextDataMap();
        contextDataMap.put(HttpRequest.class, request);
        contextDataMap.put(HttpResponse.class, response);
        contextDataMap.put(HttpHeaders.class, request.getHttpHeaders());
        contextDataMap.put(UriInfo.class, request.getUri());
        contextDataMap.put(Request.class, new RequestImpl(request, response));
        contextDataMap.put(ResteasyAsynchronousContext.class, request.getAsyncContext());
        ResourceContext resourceContext = new ResourceContext(){

            public <T> T getResource(Class<T> resourceClass) {
                return (T)SynchronousDispatcher.this.providerFactory.injectedInstance(resourceClass, request, response);
            }

            public <T> T initResource(T resource) {
                SynchronousDispatcher.this.providerFactory.injectProperties(resource, request, response);
                return resource;
            }
        };
        contextDataMap.put(ResourceContext.class, resourceContext);
        contextDataMap.putAll(this.defaultContextObjects);
        contextDataMap.put(Cleanables.class, new Cleanables());
        contextDataMap.put(PostResourceMethodInvokers.class, new PostResourceMethodInvokers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response internalInvocation(HttpRequest request, HttpResponse response, Object entity) {
        ResteasyContext.addContextDataLevel();
        boolean pushedBody = false;
        try {
            MessageBodyParameterInjector.pushBody(entity);
            pushedBody = true;
            ResourceInvoker invoker = this.getInvoker(request);
            if (invoker != null) {
                this.pushContextObjects(request, response);
                Response response2 = this.execute(request, response, invoker);
                return response2;
            }
            Response response3 = null;
            return response3;
        }
        finally {
            ResteasyContext.removeContextDataLevel();
            if (pushedBody) {
                MessageBodyParameterInjector.popBody();
            }
        }
    }

    public void clearContextData() {
        Cleanables cleanables;
        Map<Class<?>, Object> map = ResteasyContext.getContextDataMap(false);
        Cleanables cleanables2 = cleanables = map != null ? (Cleanables)map.get(Cleanables.class) : null;
        if (cleanables != null) {
            Iterator<Cleanable> it = cleanables.getCleanables().iterator();
            while (it.hasNext()) {
                try {
                    it.next().clean();
                }
                catch (Exception exception) {}
            }
            ResteasyContext.clearContextData();
        }
        MessageBodyParameterInjector.clearBodies();
    }

    public Response execute(HttpRequest request, HttpResponse response, ResourceInvoker invoker) {
        Response jaxrsResponse;
        block5: {
            jaxrsResponse = null;
            try {
                RESTEasyTracingLogger logger = RESTEasyTracingLogger.getInstance(request);
                logger.log("DISPATCH_RESPONSE", jaxrsResponse);
                request.getAsyncContext().initialRequestStarted();
                jaxrsResponse = invoker.invoke(request, response);
                request.getAsyncContext().initialRequestEnded();
                if (request.getAsyncContext().isSuspended()) {
                    request.getAsyncContext().getAsyncResponse().initialRequestThreadFinished();
                    jaxrsResponse = null;
                }
            }
            catch (CompletionException e) {
                jaxrsResponse = new ExceptionHandler(this.providerFactory, this.unwrappedExceptions).handleException(request, e.getCause());
                if (jaxrsResponse == null) {
                    throw new UnhandledException(e.getCause());
                }
            }
            catch (Exception e) {
                jaxrsResponse = new ExceptionHandler(this.providerFactory, this.unwrappedExceptions).handleException(request, e);
                if (jaxrsResponse != null) break block5;
                throw new UnhandledException((Throwable)e);
            }
        }
        return jaxrsResponse;
    }

    public void invoke(HttpRequest request, HttpResponse response, ResourceInvoker invoker) {
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(request);
        Response jaxrsResponse = null;
        try {
            request.getAsyncContext().initialRequestStarted();
            jaxrsResponse = invoker.invoke(request, response);
            request.getAsyncContext().initialRequestEnded();
            tracingLogger.log("DISPATCH_RESPONSE", jaxrsResponse);
            if (request.getAsyncContext().isSuspended()) {
                request.getAsyncContext().getAsyncResponse().initialRequestThreadFinished();
                jaxrsResponse = null;
            }
        }
        catch (CompletionException e) {
            this.writeException(request, response, e.getCause(), t -> {});
            return;
        }
        catch (Exception e) {
            invoker.getMethodStatisticsLogger().incFailureCnt();
            this.writeException(request, response, e, t -> {});
            return;
        }
        if (jaxrsResponse != null) {
            this.writeResponse(request, response, jaxrsResponse);
        }
    }

    @Deprecated
    public void asynchronousDelivery(HttpRequest request, HttpResponse response, Response jaxrsResponse) throws IOException {
        this.asynchronousDelivery(request, response, jaxrsResponse, t -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asynchronousDelivery(HttpRequest request, HttpResponse response, Response jaxrsResponse, Consumer<Throwable> onComplete) throws IOException {
        if (jaxrsResponse == null) {
            return;
        }
        try {
            this.pushContextObjects(request, response);
            ServerResponseWriter.writeNomapResponse((BuiltResponse)jaxrsResponse, request, response, this.providerFactory, onComplete);
        }
        finally {
            ResteasyContext.removeContextDataLevel();
        }
    }

    public void unhandledAsynchronousException(HttpResponse response, Throwable ex) {
        LogMessages.LOGGER.unhandledAsynchronousException(ex);
        if (!response.isCommitted()) {
            try {
                response.reset();
                response.sendError(500);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public void asynchronousExceptionDelivery(HttpRequest request, HttpResponse response, Throwable exception) {
        this.asynchronousExceptionDelivery(request, response, exception, t -> {});
    }

    public void asynchronousExceptionDelivery(HttpRequest request, HttpResponse response, Throwable exception, Consumer<Throwable> onComplete) {
        try {
            this.pushContextObjects(request, response);
            this.writeException(request, response, exception, t -> {
                if (t != null) {
                    this.unhandledAsynchronousException(response, (Throwable)t);
                }
                onComplete.accept(null);
                ResteasyContext.removeContextDataLevel();
            });
        }
        catch (Throwable ex) {
            this.unhandledAsynchronousException(response, ex);
            onComplete.accept(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResponse(HttpRequest request, HttpResponse response, Response jaxrsResponse) {
        try {
            ServerResponseWriter.writeNomapResponse((BuiltResponse)jaxrsResponse, request, response, this.providerFactory, t -> {
                if (t != null) {
                    if (request.getAsyncContext().isSuspended() && !request.getAsyncContext().isOnInitialRequest()) {
                        try {
                            this.writeException(request, response, (Throwable)t, t2 -> {});
                        }
                        catch (Throwable ex) {
                            this.unhandledAsynchronousException(response, ex);
                        }
                    } else {
                        SynchronousDispatcher.rethrow(t);
                    }
                }
            });
        }
        catch (Exception e) {
            try {
                this.writeException(request, response, e, t -> {});
            }
            catch (Throwable throwable) {
                RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(request);
                tracingLogger.log("FINISHED", response.getStatus());
                tracingLogger.flush((MultivaluedMap<String, Object>)response.getOutputHeaders());
                throw throwable;
            }
            RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(request);
            tracingLogger.log("FINISHED", response.getStatus());
            tracingLogger.flush((MultivaluedMap<String, Object>)response.getOutputHeaders());
        }
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(request);
        tracingLogger.log("FINISHED", response.getStatus());
        tracingLogger.flush((MultivaluedMap<String, Object>)response.getOutputHeaders());
    }

    public void addHttpPreprocessor(HttpRequestPreprocessor httpPreprocessor) {
        this.requestPreprocessors.add(httpPreprocessor);
    }
}

