/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.postgresql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UuidType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger(UuidType.class);

    public UuidType() {
        super("uuid", 1111, String.class, false);
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        return resultSet.getString(column);
    }

    @Override
    public void setSqlValue(Object uuid, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        statement.setObject(column, this.getUUID(uuid, statement.getConnection()));
    }

    @Override
    public Object typeCast(Object arg0) throws TypeCastException {
        return arg0.toString();
    }

    private Object getUUID(Object value, Connection connection) throws TypeCastException {
        logger.debug("getUUID(value={}, connection={}) - start", value, (Object)connection);
        Object tempUUID = null;
        try {
            Class aPGObjectClass = super.loadClass("org.postgresql.util.PGobject", connection);
            Constructor ct = aPGObjectClass.getConstructor(null);
            tempUUID = ct.newInstance(null);
            Method setTypeMethod = aPGObjectClass.getMethod("setType", String.class);
            setTypeMethod.invoke(tempUUID, "uuid");
            Method setValueMethod = aPGObjectClass.getMethod("setValue", String.class);
            setValueMethod.invoke(tempUUID, value.toString());
        }
        catch (ClassNotFoundException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (InvocationTargetException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (NoSuchMethodException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (IllegalAccessException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (InstantiationException e) {
            throw new TypeCastException(value, this, e);
        }
        return tempUUID;
    }
}

