/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest.v1.impl;

import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionRequest;
import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionWithPrincipalsRequest;
import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionWithReferencesAndPrincipalsRequest;
import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionWithReferencesRequest;
import ai.digital.deploy.permissions.api.rest.dto.ReferencedPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithGlobalPermissionsConverter$;
import ai.digital.deploy.permissions.api.rest.v1.PermissionResource;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.service.GlobalPermissionService;
import ai.digital.deploy.permissions.service.ReferencedPermissionService;
import ai.digital.deploy.permissions.service.RoleService;
import java.io.Serializable;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@RestController
@RequestMapping(value={"/v1/permissions/all"})
@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001\u0002\u0007\u000e\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!AA\u0007\u0001B\u0001B\u0003%Q\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0003@\u0001\u0011\u0005\u0003\tC\u0003@\u0001\u0011\u00053\u000e\u0003\u0004@\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u001d\tY\u0003\u0001C!\u00037Bq!a\u000b\u0001\t\u0003\n\t\bC\u0004\u0002,\u0001!\t%!$\u0003)A+'/\\5tg&|gnQ8oiJ|G\u000e\\3s\u0015\tqq\"\u0001\u0003j[Bd'B\u0001\t\u0012\u0003\t1\u0018G\u0003\u0002\u0013'\u0005!!/Z:u\u0015\t!R#A\u0002ba&T!AF\f\u0002\u0017A,'/\\5tg&|gn\u001d\u0006\u00031e\ta\u0001Z3qY>L(B\u0001\u000e\u001c\u0003\u001d!\u0017nZ5uC2T\u0011\u0001H\u0001\u0003C&\u001c\u0001aE\u0002\u0001?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014(\u001b\u0005y\u0011B\u0001\u0015\u0010\u0005I\u0001VM]7jgNLwN\u001c*fg>,(oY3\u0002\u0017I|G.Z*feZL7-\u001a\t\u0003W9j\u0011\u0001\f\u0006\u0003[U\tqa]3sm&\u001cW-\u0003\u00020Y\tY!k\u001c7f'\u0016\u0014h/[2f\u0003m\u0011XMZ3sK:\u001cW\r\u001a)fe6L7o]5p]N+'O^5dKB\u00111FM\u0005\u0003g1\u00121DU3gKJ,gnY3e!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0017aF4m_\n\fG\u000eU3s[&\u001c8/[8o'\u0016\u0014h/[2f!\tYc'\u0003\u00028Y\t9r\t\\8cC2\u0004VM]7jgNLwN\\*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\tibTH\u0010\t\u0003w\u0001i\u0011!\u0004\u0005\u0006S\u0011\u0001\rA\u000b\u0005\u0006a\u0011\u0001\r!\r\u0005\u0006i\u0011\u0001\r!N\u0001\u0005e\u0016\fG\r\u0006\u0002B\u000fB\u0011!)R\u0007\u0002\u0007*\u0011A)E\u0001\u0004IR|\u0017B\u0001$D\u0005Y\u0011v\u000e\\3XSRD\u0007+\u001a:nSN\u001c\u0018n\u001c8t\tR|\u0007\"\u0002%\u0006\u0001\u0004I\u0015\u0001\u0003:pY\u0016t\u0015-\\3\u0011\u0005)\u000bfBA&P!\ta\u0015%D\u0001N\u0015\tqU$\u0001\u0004=e>|GOP\u0005\u0003!\u0006\na\u0001\u0015:fI\u00164\u0017B\u0001*T\u0005\u0019\u0019FO]5oO*\u0011\u0001+\t\u0015\u0003\u000fV\u0003\"AV1\u000e\u0003]S!\u0001W-\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002[7\u0006!!-\u001b8e\u0015\taV,A\u0002xK\nT!AX0\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001Y\u0001\u0004_J<\u0017B\u00012X\u00051\u0001\u0016\r\u001e5WCJL\u0017M\u00197fQ\u0011)Am\u001a5\u0011\u0005Y+\u0017B\u00014X\u0005)9U\r^'baBLgnZ\u0001\u0006m\u0006dW/\u001a\u0017\u0002S\u0006\n!.A\u00060wJ|G.\u001a(b[\u0016lHC\u00017v!\ri'/\u0011\b\u0003]Bt!\u0001T8\n\u0003\tJ!!]\u0011\u0002\u000fA\f7m[1hK&\u00111\u000f\u001e\u0002\u0005\u0019&\u001cHO\u0003\u0002rC!)aO\u0002a\u0001o\u0006I!o\u001c7f\u001d\u0006lWm\u001d\t\u0004[JL\u0005FA;z!\t1&0\u0003\u0002|/\nY!+Z9vKN$(i\u001c3zQ\u00111AmZ?-\u0003y\f\u0013a`\u0001\u0007_I|G.Z:\u0015\r\u0005\r\u00111CA\r!\u0015\t)!a\u0004B\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011A\u00023p[\u0006LgNC\u0002\u0002\u000eu\u000bA\u0001Z1uC&!\u0011\u0011CA\u0004\u0005\u0011\u0001\u0016mZ3\t\r\u0005Uq\u00011\u0001x\u0003\u0015q\u0017-\\3tQ\r\t\u0019\"\u001f\u0005\b\u000379\u0001\u0019AA\u000f\u0003!\u0001\u0018mZ3bE2,\u0007\u0003BA\u0003\u0003?IA!!\t\u0002\b\tA\u0001+Y4fC\ndW\rK\u0003\bI\u001e\f)\u0003\f\u0002\u0002(\u0005\u0012\u0011\u0011F\u0001\u000e_I|G.Z:0M&dG/\u001a:\u0002\u001f\rDWmY6QKJl\u0017n]:j_:$B!a\f\u00026A\u0019\u0001%!\r\n\u0007\u0005M\u0012EA\u0004C_>dW-\u00198\t\u000f\u0005]\u0002\u00021\u0001\u0002:\u000512\r[3dWB+'/\\5tg&|gNU3rk\u0016\u001cH\u000fE\u0002C\u0003wI1!!\u0010D\u0005Y\u0019\u0005.Z2l!\u0016\u0014X.[:tS>t'+Z9vKN$\bfAA\u001bs\"\"\u0011QGA\"!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\n!B^1mS\u0012\fG/[8o\u0015\t\ti%A\u0003kCZ\f\u00070\u0003\u0003\u0002R\u0005\u001d#!\u0002,bY&$\u0007&\u0002\u0005eO\u0006UCFAA,C\t\tI&\u0001\u00040G\",7m\u001b\u000b\u0005\u0003_\ti\u0006C\u0004\u00028%\u0001\r!a\u0018\u0011\u0007\t\u000b\t'C\u0002\u0002d\r\u0013Ae\u00115fG.\u0004VM]7jgNLwN\\,ji\"\u0004&/\u001b8dSB\fGn\u001d*fcV,7\u000f\u001e\u0015\u0004\u0003;J\b\u0006BA/\u0003\u0007BS!\u00033h\u0003Wb#!!\u001c\"\u0005\u0005=\u0014!E\u0018dQ\u0016\u001c7n\f9sS:\u001c\u0017\u000e]1mgR!\u00111OA=!\u0019Q\u0015QO%\u00020%\u0019\u0011qO*\u0003\u00075\u000b\u0007\u000fC\u0004\u00028)\u0001\r!a\u001f\u0011\u0007\t\u000bi(C\u0002\u0002\u0000\r\u0013Ae\u00115fG.\u0004VM]7jgNLwN\\,ji\"\u0014VMZ3sK:\u001cWm\u001d*fcV,7\u000f\u001e\u0015\u0004\u0003sJ\b\u0006BA=\u0003\u0007BSA\u00033h\u0003\u000fc#!!#\"\u0005\u0005-\u0015!E\u0018sK\u001a,'/\u001a8dKN|3\r[3dWR!\u00111OAH\u0011\u001d\t9d\u0003a\u0001\u0003#\u00032AQAJ\u0013\r\t)j\u0011\u00022\u0007\",7m\u001b)fe6L7o]5p]^KG\u000f\u001b*fM\u0016\u0014XM\\2fg\u0006sG\r\u0015:j]\u000eL\u0007/\u00197t%\u0016\fX/Z:uQ\r\ty)\u001f\u0015\u0005\u0003\u001f\u000b\u0019\u0005K\u0003\fI\u001e\fi\n\f\u0002\u0002 \u0006\u0012\u0011\u0011U\u0001\u001d_I,g-\u001a:f]\u000e,7oL2iK\u000e\\w\u0006\u001d:j]\u000eL\u0007/\u00197tQ\u0019\u0001\u0011QU4\u0002,B\u0019a+a*\n\u0007\u0005%vK\u0001\bSKF,Xm\u001d;NCB\u0004\u0018N\\4-\u0005\u00055\u0016EAAX\u0003Myc/M\u0018qKJl\u0017n]:j_:\u001cx&\u00197mQ\r\u0001\u00111\u0017\t\u0004-\u0006U\u0016bAA\\/\nq!+Z:u\u0007>tGO]8mY\u0016\u0014\b")
public class PermissionController
implements PermissionResource {
    private final RoleService roleService;
    private final ReferencedPermissionService referencedPermissionService;
    private final GlobalPermissionService globalPermissionService;

    @Override
    @GetMapping(value={"/{roleName}"})
    public RoleWithPermissionsDto read(@PathVariable String roleName) {
        List globalPermissions = this.globalPermissionService.read(roleName).map((Function1 & Serializable)x$1 -> x$1.permissionName());
        Map referencedPermissions = this.referencedPermissionService.read(roleName).groupBy((Function1 & Serializable)x$2 -> x$2.reference());
        Role role = (Role)this.roleService.read(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(roleName);
        });
        List referencedPermissionsDto = ((IterableOnceOps)referencedPermissions.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$3 -> x$3.permissionName())))).toList();
        return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), globalPermissions, referencedPermissionsDto);
    }

    @Override
    @GetMapping(value={"/roles"})
    public List<RoleWithPermissionsDto> read(@RequestBody List<String> roleNames) {
        Map globalPermissions = this.globalPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$4 -> x$4.role().name());
        Map referencedPermissions = this.referencedPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$5 -> x$5.role().name());
        List roles = this.roleService.read(roleNames);
        return roles.map((Function1 & Serializable)role -> {
            Map referencedPermissionsForRole = ((IterableOps)referencedPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())).groupBy((Function1 & Serializable)x$6 -> x$6.reference());
            List referencedPermissionsDto = ((IterableOnceOps)referencedPermissionsForRole.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$7 -> x$7.permissionName())))).toList();
            return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto((List)globalPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), referencedPermissionsDto);
        });
    }

    @Override
    @GetMapping(value={"/roles/filter"})
    public Page<RoleWithPermissionsDto> read(@RequestBody List<String> names, Pageable pageable) {
        Page roles = this.roleService.read(names, pageable);
        List roleNames = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)roles).asScala().toList().map((Function1 & Serializable)x$8 -> x$8.name());
        Map globalPermissions = this.globalPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$9 -> x$9.role().name());
        Map referencedPermissions = this.referencedPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$10 -> x$10.role().name());
        List dtos = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)roles).asScala().toList().map((Function1 & Serializable)role -> {
            Map referencedPermissionsForRole = ((IterableOps)referencedPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())).groupBy((Function1 & Serializable)x$11 -> x$11.reference());
            List referencedPermissionsDto = ((IterableOnceOps)referencedPermissionsForRole.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$12 -> x$12.permissionName())))).toList();
            return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto((List)globalPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), referencedPermissionsDto);
        });
        return new PageImpl(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dtos).asJava(), pageable, roles.getTotalElements());
    }

    @Override
    @GetMapping(value={"/check"})
    public boolean checkPermission(@Valid @RequestBody CheckPermissionRequest checkPermissionRequest) {
        return BoxesRunTime.unboxToBoolean((Object)checkPermissionRequest.referenceMaybe().map((Function1 & Serializable)referenceId -> BoxesRunTime.boxToBoolean((boolean)this.referencedPermissionService.checkPermission(referenceId, checkPermissionRequest.permissions(), checkPermissionRequest.allRoles()))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.globalPermissionService.checkPermission(checkPermissionRequest.permissions(), checkPermissionRequest.allRoles())));
    }

    @Override
    @GetMapping(value={"/check/principals"})
    public boolean checkPermission(@Valid @RequestBody CheckPermissionWithPrincipalsRequest checkPermissionRequest) {
        return BoxesRunTime.unboxToBoolean((Object)checkPermissionRequest.referenceMaybe().map((Function1 & Serializable)referenceId -> BoxesRunTime.boxToBoolean((boolean)this.referencedPermissionService.checkPermission(referenceId, checkPermissionRequest.permissions(), checkPermissionRequest.allRoles(), checkPermissionRequest.principals()))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.globalPermissionService.checkPermission(checkPermissionRequest.permissions(), checkPermissionRequest.allRoles(), checkPermissionRequest.principals())));
    }

    @Override
    @GetMapping(value={"/references/check"})
    public Map<String, Object> checkPermission(@Valid @RequestBody CheckPermissionWithReferencesRequest checkPermissionRequest) {
        return checkPermissionRequest.references().isEmpty() ? (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"global"), (Object)BoxesRunTime.boxToBoolean((boolean)this.globalPermissionService.checkPermission(checkPermissionRequest.permissions(), checkPermissionRequest.allRoles())))})) : checkPermissionRequest.references().map((Function1 & Serializable)reference -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reference.toString()), (Object)BoxesRunTime.boxToBoolean((boolean)$this.referencedPermissionService.checkPermission(reference, checkPermissionRequest.permissions(), checkPermissionRequest.allRoles())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    @GetMapping(value={"/references/check/principals"})
    public Map<String, Object> checkPermission(@Valid @RequestBody CheckPermissionWithReferencesAndPrincipalsRequest checkPermissionRequest) {
        return checkPermissionRequest.references().isEmpty() ? (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"global"), (Object)BoxesRunTime.boxToBoolean((boolean)this.globalPermissionService.checkPermission(checkPermissionRequest.permissions(), checkPermissionRequest.allRoles(), checkPermissionRequest.principals())))})) : checkPermissionRequest.references().map((Function1 & Serializable)reference -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reference.toString()), (Object)BoxesRunTime.boxToBoolean((boolean)$this.referencedPermissionService.checkPermission(reference, checkPermissionRequest.permissions(), checkPermissionRequest.allRoles(), checkPermissionRequest.principals())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public PermissionController(RoleService roleService, ReferencedPermissionService referencedPermissionService, GlobalPermissionService globalPermissionService) {
        this.roleService = roleService;
        this.referencedPermissionService = referencedPermissionService;
        this.globalPermissionService = globalPermissionService;
    }
}

