/*
 * Decompiled with CFR 0.152.
 */
package akka.pki.pem;

import akka.annotation.ApiMayChange;
import akka.pki.pem.PEMDecoder;
import akka.pki.pem.PEMLoadingException;
import com.hierynomus.asn1.ASN1InputStream;
import com.hierynomus.asn1.encodingrules.ASN1Decoder;
import com.hierynomus.asn1.encodingrules.der.DERDecoder;
import com.hierynomus.asn1.types.ASN1Object;
import com.hierynomus.asn1.types.constructed.ASN1Sequence;
import com.hierynomus.asn1.types.primitive.ASN1Integer;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class DERPrivateKeyLoader$ {
    public static final DERPrivateKeyLoader$ MODULE$ = new DERPrivateKeyLoader$();

    @ApiMayChange
    public PrivateKey load(PEMDecoder.DERData derData) throws PEMLoadingException {
        PrivateKey privateKey;
        block7: {
            String string;
            block5: {
                block6: {
                    string = derData.label();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -170985982: {
                            if (!"PRIVATE KEY".equals(string)) break block5;
                            break block6;
                        }
                        case 2121838594: {
                            if ("RSA PRIVATE KEY".equals(string)) {
                                break;
                            }
                            break block5;
                        }
                        default: {
                            break block5;
                        }
                    }
                    privateKey = this.loadPkcs1PrivateKey(derData.bytes());
                    break block7;
                }
                privateKey = this.loadPkcs8PrivateKey(derData.bytes());
                break block7;
            }
            throw new PEMLoadingException(new StringBuilder(64).append("Don't know how to read a private key from PEM data with label [").append(string).append("]").toString());
        }
        return privateKey;
    }

    private PrivateKey loadPkcs1PrivateKey(byte[] bytes) {
        RSAPrivateKeySpec rSAPrivateKeySpec;
        ASN1Sequence aSN1Sequence;
        try (ASN1InputStream derInputStream = new ASN1InputStream((ASN1Decoder)new DERDecoder(), bytes);){
            aSN1Sequence = (ASN1Sequence)derInputStream.readObject();
        }
        ASN1Sequence sequence = aSN1Sequence;
        int version = this.getInteger(sequence, 0, "version").intValueExact();
        if (version < 0 || version > 1) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Unsupported PKCS1 version: ").append(version).toString());
        }
        BigInteger modulus = this.getInteger(sequence, 1, "modulus");
        BigInteger publicExponent = this.getInteger(sequence, 2, "publicExponent");
        BigInteger privateExponent = this.getInteger(sequence, 3, "privateExponent");
        BigInteger prime1 = this.getInteger(sequence, 4, "prime1");
        BigInteger prime2 = this.getInteger(sequence, 5, "prime2");
        BigInteger exponent1 = this.getInteger(sequence, 6, "exponent1");
        BigInteger exponent2 = this.getInteger(sequence, 7, "exponent2");
        BigInteger coefficient = this.getInteger(sequence, 8, "coefficient");
        if (version == 0) {
            rSAPrivateKeySpec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient);
        } else {
            ASN1Sequence otherPrimeInfosSequence = this.getSequence(sequence, 9, "otherPrimeInfos");
            RSAOtherPrimeInfo[] otherPrimeInfos = (RSAOtherPrimeInfo[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), otherPrimeInfosSequence.size()).map((Function1 & Serializable)i -> DERPrivateKeyLoader$.$anonfun$loadPkcs1PrivateKey$1(otherPrimeInfosSequence, BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(RSAOtherPrimeInfo.class));
            rSAPrivateKeySpec = new RSAMultiPrimePrivateCrtKeySpec(modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient, otherPrimeInfos);
        }
        RSAPrivateCrtKeySpec keySpec = rSAPrivateKeySpec;
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    private BigInteger getInteger(ASN1Sequence sequence, int index, String name) {
        ASN1Object aSN1Object = sequence.get(index);
        if (!(aSN1Object instanceof ASN1Integer)) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Expected integer tag for ").append(name).append(" at index ").append(index).append(", but got: ").append(aSN1Object.getTag()).toString());
        }
        ASN1Integer aSN1Integer = (ASN1Integer)aSN1Object;
        BigInteger bigInteger = aSN1Integer.getValue();
        return bigInteger;
    }

    private ASN1Sequence getSequence(ASN1Sequence sequence, int index, String name) {
        ASN1Sequence aSN1Sequence;
        ASN1Object aSN1Object = sequence.get(index);
        if (!(aSN1Object instanceof ASN1Sequence)) {
            throw new IllegalArgumentException(new StringBuilder(47).append("Expected sequence tag for ").append(name).append(" at index ").append(index).append(", but got: ").append(aSN1Object.getTag()).toString());
        }
        ASN1Sequence aSN1Sequence2 = aSN1Sequence = (ASN1Sequence)aSN1Object;
        return aSN1Sequence2;
    }

    private PrivateKey loadPkcs8PrivateKey(byte[] bytes) {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    public static final /* synthetic */ RSAOtherPrimeInfo $anonfun$loadPkcs1PrivateKey$1(ASN1Sequence otherPrimeInfosSequence$1, int i) {
        String name = new StringBuilder(17).append("otherPrimeInfos[").append(i).append("]").toString();
        ASN1Sequence seq = MODULE$.getSequence(otherPrimeInfosSequence$1, i, name);
        BigInteger prime = MODULE$.getInteger(seq, 0, new StringBuilder(6).append(name).append(".prime").toString());
        BigInteger exponent = MODULE$.getInteger(seq, 1, new StringBuilder(9).append(name).append(".exponent").toString());
        BigInteger coefficient = MODULE$.getInteger(seq, 2, new StringBuilder(12).append(name).append(".coefficient").toString());
        return new RSAOtherPrimeInfo(prime, exponent, coefficient);
    }

    private DERPrivateKeyLoader$() {
    }
}

