/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.util.Collection;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;

public final class CloseHelper {
    private CloseHelper() {
    }

    public static void quietClose(AutoCloseable closeable) {
        try {
            if (null != closeable) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void quietCloseAll(Collection<? extends AutoCloseable> closeables) {
        if (closeables == null || closeables.isEmpty()) {
            return;
        }
        for (AutoCloseable autoCloseable : closeables) {
            if (autoCloseable == null) continue;
            try {
                autoCloseable.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void quietCloseAll(AutoCloseable ... closeables) {
        if (closeables == null || closeables.length == 0) {
            return;
        }
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void close(AutoCloseable closeable) {
        try {
            if (null != closeable) {
                closeable.close();
            }
        }
        catch (Throwable ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    public static void closeAll(Collection<? extends AutoCloseable> closeables) {
        if (closeables == null || closeables.isEmpty()) {
            return;
        }
        Throwable error = null;
        for (AutoCloseable autoCloseable : closeables) {
            if (autoCloseable == null) continue;
            try {
                autoCloseable.close();
            }
            catch (Throwable ex) {
                if (error == null) {
                    error = ex;
                    continue;
                }
                error.addSuppressed(ex);
            }
        }
        if (error != null) {
            LangUtil.rethrowUnchecked(error);
        }
    }

    public static void closeAll(AutoCloseable ... closeables) {
        if (closeables == null || closeables.length == 0) {
            return;
        }
        Throwable error = null;
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Throwable ex) {
                if (error == null) {
                    error = ex;
                    continue;
                }
                error.addSuppressed(ex);
            }
        }
        if (error != null) {
            LangUtil.rethrowUnchecked(error);
        }
    }

    public static void close(ErrorHandler errorHandler, AutoCloseable closeable) {
        try {
            if (null != closeable) {
                closeable.close();
            }
        }
        catch (Throwable ex) {
            errorHandler.onError(ex);
        }
    }

    public static void closeAll(ErrorHandler errorHandler, Collection<? extends AutoCloseable> closeables) {
        if (closeables == null || closeables.isEmpty()) {
            return;
        }
        for (AutoCloseable autoCloseable : closeables) {
            if (autoCloseable == null) continue;
            try {
                autoCloseable.close();
            }
            catch (Throwable ex) {
                errorHandler.onError(ex);
            }
        }
    }

    public static void closeAll(ErrorHandler errorHandler, AutoCloseable ... closeables) {
        if (closeables == null || closeables.length == 0) {
            return;
        }
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Throwable ex) {
                errorHandler.onError(ex);
            }
        }
    }
}

