/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueColdProducerFields;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.MpscAccess;
import com.github.benmanes.caffeine.cache.UnsafeMpscAccess;
import com.github.benmanes.caffeine.cache.VarHandleMpscAccess;
import java.util.Iterator;

abstract class BaseMpscLinkedArrayQueue<E>
extends BaseMpscLinkedArrayQueueColdProducerFields<E> {
    static final MpscAccess ACCESS = BaseMpscLinkedArrayQueue.makeAccess();
    private static final Object JUMP = new Object();

    BaseMpscLinkedArrayQueue(int initialCapacity) {
        if (initialCapacity < 2) {
            throw new IllegalArgumentException("Initial capacity must be 2 or more");
        }
        int p2capacity = Caffeine.ceilingPowerOfTwo(initialCapacity);
        long mask = (long)p2capacity - 1L << 1;
        E[] buffer = BaseMpscLinkedArrayQueue.allocate(p2capacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.getAccess().soProducerLimit(this, mask);
    }

    protected MpscAccess getAccess() {
        return ACCESS;
    }

    static MpscAccess makeAccess() {
        try {
            return new UnsafeMpscAccess();
        }
        catch (Throwable ignored) {
            return new VarHandleMpscAccess();
        }
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    @Override
    public boolean offer(E e) {
        Object[] buffer;
        long mask;
        long pIndex;
        if (null == e) {
            throw new NullPointerException();
        }
        block6: while (true) {
            long producerLimit = this.lvProducerLimit();
            pIndex = this.getAccess().lvProducerIndex(this);
            if ((pIndex & 1L) == 1L) continue;
            mask = this.producerMask;
            buffer = this.producerBuffer;
            if (producerLimit <= pIndex) {
                int result = this.offerSlowPath(mask, pIndex, producerLimit);
                switch (result) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, e);
                        return true;
                    }
                }
            }
            if (this.getAccess().casProducerIndex(this, pIndex, pIndex + 2L)) break;
        }
        long offset = this.getAccess().modifiedCalcElementOffset(pIndex, mask);
        this.getAccess().soElement(buffer, offset, e);
        return true;
    }

    private int offerSlowPath(long mask, long pIndex, long producerLimit) {
        long cIndex = this.getAccess().lvConsumerIndex(this);
        long bufferCapacity = this.getCurrentBufferCapacity(mask);
        int result = 0;
        if (cIndex + bufferCapacity > pIndex) {
            if (!this.getAccess().casProducerLimit(this, producerLimit, cIndex + bufferCapacity)) {
                result = 1;
            }
        } else {
            result = this.availableInQueue(pIndex, cIndex) <= 0L ? 2 : (this.getAccess().casProducerIndex(this, pIndex, pIndex + 1L) ? 3 : 1);
        }
        return result;
    }

    protected abstract long availableInQueue(long var1, long var3);

    @Override
    public E poll() {
        Object[] buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = this.getAccess().modifiedCalcElementOffset(index, mask);
        Object e = this.getAccess().lvElement(buffer, offset);
        if (e == null) {
            if (index != this.getAccess().lvProducerIndex(this)) {
                while ((e = this.getAccess().lvElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        if (e == JUMP) {
            Object[] nextBuffer = this.getNextBuffer(buffer, mask);
            return (E)this.newBufferPoll(nextBuffer, index);
        }
        this.getAccess().soElement(buffer, offset, null);
        this.getAccess().soConsumerIndex(this, index + 2L);
        return (E)e;
    }

    @Override
    public E peek() {
        Object[] buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = this.getAccess().modifiedCalcElementOffset(index, mask);
        Object e = this.getAccess().lvElement(buffer, offset);
        if (e == null && index != this.getAccess().lvProducerIndex(this)) {
            while ((e = this.getAccess().lvElement(buffer, offset)) == null) {
            }
        }
        if (e == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(buffer, mask), index);
        }
        return (E)e;
    }

    private E[] getNextBuffer(E[] buffer, long mask) {
        long nextArrayOffset = this.nextArrayOffset(mask);
        Object[] nextBuffer = (Object[])this.getAccess().lvElement(buffer, nextArrayOffset);
        this.getAccess().soElement(buffer, nextArrayOffset, null);
        return nextBuffer;
    }

    private long nextArrayOffset(long mask) {
        return this.getAccess().modifiedCalcElementOffset(mask + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(E[] nextBuffer, long index) {
        long offsetInNew = this.newBufferAndOffset(nextBuffer, index);
        E n = this.getAccess().lvElement(nextBuffer, offsetInNew);
        if (n == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        this.getAccess().soElement(nextBuffer, offsetInNew, null);
        this.getAccess().soConsumerIndex(this, index + 2L);
        return n;
    }

    private E newBufferPeek(E[] nextBuffer, long index) {
        long offsetInNew = this.newBufferAndOffset(nextBuffer, index);
        E n = this.getAccess().lvElement(nextBuffer, offsetInNew);
        if (null == n) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return n;
    }

    private long newBufferAndOffset(E[] nextBuffer, long index) {
        this.consumerBuffer = nextBuffer;
        this.consumerMask = (long)nextBuffer.length - 2L << 1;
        long offsetInNew = this.getAccess().modifiedCalcElementOffset(index, this.consumerMask);
        return offsetInNew;
    }

    @Override
    public final int size() {
        long currentProducerIndex;
        long before;
        long after = this.getAccess().lvConsumerIndex(this);
        do {
            before = after;
            currentProducerIndex = this.getAccess().lvProducerIndex(this);
        } while (before != (after = this.getAccess().lvConsumerIndex(this)));
        long size = currentProducerIndex - after >> 1;
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public final boolean isEmpty() {
        return this.getAccess().lvConsumerIndex(this) == this.getAccess().lvProducerIndex(this);
    }

    private long lvProducerLimit() {
        return this.producerLimit;
    }

    public long currentProducerIndex() {
        return this.getAccess().lvProducerIndex(this) / 2L;
    }

    public long currentConsumerIndex() {
        return this.getAccess().lvConsumerIndex(this) / 2L;
    }

    public abstract int capacity();

    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    public E relaxedPoll() {
        Object[] buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = this.getAccess().modifiedCalcElementOffset(index, mask);
        Object e = this.getAccess().lvElement(buffer, offset);
        if (e == null) {
            return null;
        }
        if (e == JUMP) {
            Object[] nextBuffer = this.getNextBuffer(buffer, mask);
            return (E)this.newBufferPoll(nextBuffer, index);
        }
        this.getAccess().soElement(buffer, offset, null);
        this.getAccess().soConsumerIndex(this, index + 2L);
        return (E)e;
    }

    public E relaxedPeek() {
        Object[] buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = this.getAccess().modifiedCalcElementOffset(index, mask);
        Object e = this.getAccess().lvElement(buffer, offset);
        if (e == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(buffer, mask), index);
        }
        return (E)e;
    }

    private void resize(long oldMask, E[] oldBuffer, long pIndex, E e) {
        int newBufferLength = this.getNextBufferSize(oldBuffer);
        E[] newBuffer = BaseMpscLinkedArrayQueue.allocate(newBufferLength);
        this.producerBuffer = newBuffer;
        int newMask = newBufferLength - 2 << 1;
        this.producerMask = newMask;
        long offsetInOld = this.getAccess().modifiedCalcElementOffset(pIndex, oldMask);
        long offsetInNew = this.getAccess().modifiedCalcElementOffset(pIndex, newMask);
        this.getAccess().soElement(newBuffer, offsetInNew, e);
        this.getAccess().soElement(oldBuffer, this.nextArrayOffset(oldMask), newBuffer);
        long cIndex = this.getAccess().lvConsumerIndex(this);
        long availableInQueue = this.availableInQueue(pIndex, cIndex);
        if (availableInQueue <= 0L) {
            throw new IllegalStateException();
        }
        this.getAccess().soProducerLimit(this, pIndex + Math.min((long)newMask, availableInQueue));
        this.getAccess().soProducerIndex(this, pIndex + 2L);
        this.getAccess().soElement(oldBuffer, offsetInOld, JUMP);
    }

    public static <E> E[] allocate(int capacity) {
        return new Object[capacity];
    }

    protected abstract int getNextBufferSize(E[] var1);

    protected abstract long getCurrentBufferCapacity(long var1);
}

