/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.plugin.api.flow.Step;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStep
implements StepState,
Serializable {
    private final Step implementation;
    private final Map<String, String> metadata = new HashMap<String, String>();
    private final boolean skippable;
    private volatile StepExecutionState state;
    private transient Thread runningThread;
    private AtomicInteger failureCount;
    private List<String> previousAttemptsLogs = new ArrayList<String>();
    private StringBuilder logBuilder;
    private DateTime startDate;
    private DateTime completionDate;
    private DateTime lastModificationDate;
    private String description;
    static final Logger logger = LoggerFactory.getLogger(TaskStep.class);

    public TaskStep(Step step) {
        this.implementation = step;
        this.state = StepExecutionState.PENDING;
        this.failureCount = new AtomicInteger();
        this.logBuilder = new StringBuilder();
        this.description = step.getDescription();
        this.skippable = step.skippable();
    }

    public Step getImplementation() {
        return this.implementation;
    }

    void setState(StepExecutionState state) {
        this.state = state;
        if (state == StepExecutionState.FAILED) {
            this.failureCount.incrementAndGet();
        }
        this.touch();
    }

    void recordStart() {
        this.startDate = new DateTime(DateTimeZone.UTC);
        this.touch();
    }

    void recordCompletion() {
        this.completionDate = new DateTime(DateTimeZone.UTC);
        this.touch();
    }

    public synchronized void markNextAttempt() {
        if (this.getFailureCount() > 0 && this.getState() == StepExecutionState.FAILED) {
            this.previousAttemptsLogs.add(this.logBuilder.toString());
            this.logBuilder = new StringBuilder();
        }
    }

    void touch() {
        this.lastModificationDate = new DateTime(DateTimeZone.UTC);
    }

    public boolean isMarkedForSkip() {
        return this.getState() == StepExecutionState.SKIP;
    }

    public boolean canSkip() {
        return this.skippable && (this.getState() == StepExecutionState.PENDING || this.getState() == StepExecutionState.FAILED || this.getState() == StepExecutionState.SKIP);
    }

    public boolean hasExecuted() {
        return this.state == StepExecutionState.DONE || this.state == StepExecutionState.SKIPPED;
    }

    public String toString() {
        return "[" + this.description + "]";
    }

    public StepExecutionState getState() {
        return this.state;
    }

    public synchronized String getLog() {
        return this.logBuilder.toString();
    }

    public List<String> getPreviousAttemptsLogs() {
        return new ArrayList<String>(this.previousAttemptsLogs);
    }

    public void setLogs(List<String> previous, String last) {
        this.previousAttemptsLogs = previous;
        this.logBuilder = new StringBuilder(last);
    }

    public synchronized TaskStep appendLog(String stepLogMsg) {
        this.logBuilder.append(stepLogMsg);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getCompletionDate() {
        return this.completionDate;
    }

    public DateTime getLastModificationDate() {
        return this.lastModificationDate;
    }

    public int getFailureCount() {
        return this.failureCount.intValue();
    }

    public void registerCurrentThread() {
        this.runningThread = Thread.currentThread();
        logger.debug("Setting the thread {}", (Object)this.runningThread.getId());
    }

    public void interruptRunner() {
        logger.debug("Trying to interrupt task step {}", (Object)this.description);
        if (this.runningThread != null) {
            logger.debug("Interrupting the running thread {}", (Object)this.runningThread.getId());
            this.runningThread.interrupt();
        }
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public boolean getSkippable() {
        return this.skippable;
    }

    public boolean isFailed() {
        return this.getState() == StepExecutionState.FAILED;
    }

    public TaskStep recovered() {
        if (this.state == StepExecutionState.EXECUTING) {
            this.setState(StepExecutionState.FAILED);
        }
        return this;
    }
}

