/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ui;

import java.io.Console;
import java.io.PrintStream;
import liquibase.AbstractExtensibleObject;
import liquibase.Scope;
import liquibase.configuration.ConfigurationProperty;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.Logger;
import liquibase.ui.DefaultInputHandler;
import liquibase.ui.InputHandler;
import liquibase.ui.UIService;
import liquibase.util.StringUtil;

public class ConsoleUIService
extends AbstractExtensibleObject
implements UIService {
    private PrintStream outputStream = System.out;
    private PrintStream errorStream = System.out;
    private boolean outputStackTraces = false;
    private boolean allowPrompt = false;
    private ConsoleWrapper console;

    public ConsoleUIService() {
    }

    protected ConsoleUIService(ConsoleWrapper console) {
        this.console = console;
    }

    @Override
    public int getPriority() {
        return -1;
    }

    @Override
    public void sendMessage(String message) {
        this.getOutputStream().println(message);
    }

    @Override
    public void sendErrorMessage(String message) {
        this.getErrorStream().println(message);
    }

    @Override
    public void sendErrorMessage(String message, Throwable exception) {
        this.sendErrorMessage(message);
        if (this.getOutputStackTraces()) {
            exception.printStackTrace(this.getErrorStream());
        }
    }

    @Override
    public void setAllowPrompt(boolean allowPrompt) throws IllegalArgumentException {
        this.allowPrompt = allowPrompt;
    }

    @Override
    public boolean getAllowPrompt() {
        return this.allowPrompt;
    }

    @Override
    public <T> T prompt(String prompt, T defaultValue, InputHandler<T> inputHandler, Class<T> type) {
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        if (!this.allowPrompt) {
            log.fine("No prompt for input is allowed at this time");
            return defaultValue;
        }
        ConsoleWrapper console = this.getConsole();
        if (!console.supportsInput()) {
            log.fine("No console attached. Skipping interactive prompt: '" + prompt + "'. Using default value '" + defaultValue + "'");
            return defaultValue;
        }
        if (inputHandler == null) {
            inputHandler = new DefaultInputHandler<T>();
        }
        String initialMessage = prompt;
        if (defaultValue != null) {
            initialMessage = initialMessage + " (default \"" + defaultValue + "\")";
        }
        this.sendMessage(initialMessage + ": ");
        while (true) {
            String input = StringUtil.trimToNull(console.readLine());
            try {
                if (input == null) {
                    return defaultValue;
                }
                return inputHandler.parseInput(input, type);
            }
            catch (IllegalArgumentException e2) {
                this.sendMessage("Invalid value: \"" + input + "\"");
                this.sendMessage(prompt + ": ");
                continue;
            }
            break;
        }
    }

    protected ConsoleWrapper getConsole() {
        if (this.console == null) {
            ConfigurationProperty headless = LiquibaseConfiguration.getInstance().getProperty(GlobalConfiguration.class, "headless");
            boolean headlessConfigValue = headless.getValue(Boolean.class);
            boolean wasHeadlessOverridden = headless.getWasOverridden();
            Logger log = Scope.getCurrentScope().getLog(this.getClass());
            if (headlessConfigValue) {
                log.fine("Not prompting for user input because liquibase.headless=true. Set to 'false' in liquibase.properties to change this behavior.");
                this.console = new ConsoleWrapper(null);
            } else {
                Console systemConsole = System.console();
                this.console = new ConsoleWrapper(systemConsole);
                if (systemConsole == null) {
                    log.fine("No system console detected for user input");
                    if (wasHeadlessOverridden) {
                        throw new UnexpectedLiquibaseException("liquibase.headless was set to false, but Liquibase was run in an environment with no system console");
                    }
                } else {
                    log.fine("A system console was detected for user input");
                }
            }
            if (!wasHeadlessOverridden) {
                log.fine("To override or validate the auto-detected environment for user input, set the liquibase.headless property in liquibase.properties file.");
            }
        }
        return this.console;
    }

    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    public PrintStream getErrorStream() {
        return this.errorStream;
    }

    public void setErrorStream(PrintStream errorStream) {
        this.errorStream = errorStream;
    }

    public boolean getOutputStackTraces() {
        return this.outputStackTraces;
    }

    public void setOutputStackTraces(boolean outputStackTraces) {
        this.outputStackTraces = outputStackTraces;
    }

    public static class ConsoleWrapper {
        private final Console console;

        public ConsoleWrapper(Console console) {
            this.console = console;
        }

        public String readLine() {
            if (this.console == null) {
                return "";
            }
            return this.console.readLine();
        }

        public boolean supportsInput() {
            return this.console != null;
        }
    }
}

