/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigClientRetryBootstrapper;
import org.springframework.cloud.config.client.ConfigServerConfigDataResource;
import org.springframework.cloud.config.client.ConfigServerInstanceMonitor;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogMessage;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class ConfigServerConfigDataLocationResolver
implements ConfigDataLocationResolver<ConfigServerConfigDataResource>,
Ordered {
    public static final String PREFIX = "configserver:";
    private final Log log;

    public ConfigServerConfigDataLocationResolver(Log log) {
        this.log = log;
    }

    public int getOrder() {
        return -1;
    }

    protected ConfigClientProperties loadProperties(ConfigDataLocationResolverContext context) {
        Binder binder = context.getBinder();
        BindHandler bindHandler = this.getBindHandler(context);
        ConfigClientProperties configClientProperties = (ConfigClientProperties)binder.bind("spring.cloud.config", Bindable.of(ConfigClientProperties.class), bindHandler).orElseGet(ConfigClientProperties::new);
        if (!StringUtils.hasText((String)configClientProperties.getName())) {
            String applicationName = (String)binder.bind("spring.application.name", Bindable.of(String.class), bindHandler).orElse((Object)"application");
            configClientProperties.setName(applicationName);
        }
        return configClientProperties;
    }

    private BindHandler getBindHandler(ConfigDataLocationResolverContext context) {
        return (BindHandler)context.getBootstrapContext().getOrElse(BindHandler.class, null);
    }

    protected RestTemplate createRestTemplate(ConfigClientProperties properties) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        if (properties.getRequestReadTimeout() < 0) {
            throw new IllegalStateException("Invalid Value for Read Timeout set.");
        }
        if (properties.getRequestConnectTimeout() < 0) {
            throw new IllegalStateException("Invalid Value for Connect Timeout set.");
        }
        requestFactory.setReadTimeout(properties.getRequestReadTimeout());
        requestFactory.setConnectTimeout(properties.getRequestConnectTimeout());
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        HashMap<String, String> headers = new HashMap<String, String>(properties.getHeaders());
        if (headers.containsKey("authorization")) {
            headers.remove("authorization");
        }
        if (!headers.isEmpty()) {
            template.setInterceptors(Collections.singletonList(new ConfigServicePropertySourceLocator.GenericRequestHeaderInterceptor(headers)));
        }
        return template;
    }

    protected Log getLog() {
        return this.log;
    }

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        if (!location.hasPrefix(this.getPrefix())) {
            return false;
        }
        return (Boolean)context.getBinder().bind("spring.cloud.config.enabled", Boolean.class).orElse((Object)true);
    }

    protected String getPrefix() {
        return PREFIX;
    }

    public List<ConfigServerConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        return Collections.emptyList();
    }

    public List<ConfigServerConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        ConfigClientProperties properties = this.loadProperties(resolverContext);
        String uris = location.getNonPrefixedValue(this.getPrefix());
        if (StringUtils.hasText((String)uris)) {
            String[] uri = StringUtils.commaDelimitedListToStringArray((String)uris);
            properties.setUri(uri);
        }
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        bootstrapContext.registerIfAbsent(ConfigClientProperties.class, BootstrapRegistry.InstanceSupplier.of((Object)properties));
        bootstrapContext.addCloseListener(event -> event.getApplicationContext().getBeanFactory().registerSingleton("configDataConfigClientProperties", event.getBootstrapContext().get(ConfigClientProperties.class)));
        bootstrapContext.registerIfAbsent(RestTemplate.class, context -> {
            ConfigClientProperties props = (ConfigClientProperties)context.get(ConfigClientProperties.class);
            return this.createRestTemplate(props);
        });
        boolean discoveryEnabled = (Boolean)resolverContext.getBinder().bind("spring.cloud.config.discovery.enabled", Bindable.of(Boolean.class), this.getBindHandler(resolverContext)).orElse((Object)false);
        boolean retryEnabled = (Boolean)resolverContext.getBinder().bind("spring.cloud.config.fail-fast", Bindable.of(Boolean.class), this.getBindHandler(resolverContext)).orElse((Object)false);
        if (discoveryEnabled) {
            this.log.debug((Object)LogMessage.format((String)"discovery enabled", (Object[])new Object[0]));
            bootstrapContext.registerIfAbsent(ConfigServerInstanceMonitor.class, context -> {
                ConfigServerInstanceProvider instanceProvider;
                ConfigServerInstanceProvider.Function function = (ConfigServerInstanceProvider.Function)context.get(ConfigServerInstanceProvider.Function.class);
                if (ConfigClientRetryBootstrapper.RETRY_IS_PRESENT && retryEnabled) {
                    this.log.debug((Object)LogMessage.format((String)"discovery plus retry enabled", (Object[])new Object[0]));
                    final RetryTemplate retryTemplate = (RetryTemplate)context.get(RetryTemplate.class);
                    instanceProvider = new ConfigServerInstanceProvider(function){

                        @Override
                        public List<ServiceInstance> getConfigServerInstances(String serviceId) {
                            return (List)retryTemplate.execute(retryContext -> super.getConfigServerInstances(serviceId));
                        }
                    };
                } else {
                    instanceProvider = new ConfigServerInstanceProvider(function);
                }
                instanceProvider.setLog(this.log);
                ConfigClientProperties clientProperties = (ConfigClientProperties)context.get(ConfigClientProperties.class);
                ConfigServerInstanceMonitor instanceMonitor = new ConfigServerInstanceMonitor(this.log, clientProperties, instanceProvider);
                instanceMonitor.setRefreshOnStartup(false);
                instanceMonitor.refresh();
                return instanceMonitor;
            });
            bootstrapContext.addCloseListener(event -> {
                ConfigServerInstanceMonitor configServerInstanceMonitor = (ConfigServerInstanceMonitor)event.getBootstrapContext().get(ConfigServerInstanceMonitor.class);
                event.getApplicationContext().getBeanFactory().registerSingleton("configServerInstanceMonitor", (Object)configServerInstanceMonitor);
            });
        }
        ArrayList<ConfigServerConfigDataResource> locations = new ArrayList<ConfigServerConfigDataResource>();
        locations.add(new ConfigServerConfigDataResource(properties, location.isOptional(), profiles));
        return locations;
    }
}

