/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.placeholders;

import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.util.BOM;
import com.xebialabs.deployit.util.DetectBOM$;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xldeploy.packager.MustacheScanningReader;
import com.xebialabs.xldeploy.packager.Mustacher;
import com.xebialabs.xldeploy.packager.Mustacher$;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.StreamEntry;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory;
import com.xebialabs.xldeploy.packager.placeholders.DigestOnly$;
import com.xebialabs.xldeploy.packager.placeholders.PlaceholdersUtil$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessArchive$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessTextFile$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessingType;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner$;
import com.xebialabs.xldeploy.packager.placeholders.StreamFile;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001du!\u0002\u000b\u0016\u0011\u0003\u0001c!\u0002\u0012\u0016\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003\u0002\u0003\u0017\u0002\u0005\u0004%\t!A\u0017\t\rY\n\u0001\u0015!\u0003/\u0011!9\u0014A1A\u0005\u0002\u0005A\u0004BB \u0002A\u0003%\u0011\b\u0003\u0005A\u0003\t\u0007I\u0011A\u0001B\u0011\u0019I\u0015\u0001)A\u0005\u0005\u001a!!%\u0006\u0001K\u0011!Y\u0015B!A!\u0002\u0013a\u0005\"\u0002\u0016\n\t\u0003y\u0005\"\u0002*\n\t\u0003\u0019\u0006\"\u0002>\n\t\u0003Y\b\"CA\u0005\u0013E\u0005I\u0011AA\u0006\u0011!\t\t#\u0003Q\u0005\n\u0005\r\u0002\u0002CA\u001e\u0013\u0001&I!!\u0010\t\u0011\u0005E\u0013\u0002)C\u0005\u0003'B\u0001\"!\u0018\nA\u0013%\u0011q\f\u0005\t\u0003[J\u0001\u0015\"\u0003\u0002p\u0005)2k\\;sG\u0016\f%\u000f^5gC\u000e$8kY1o]\u0016\u0014(B\u0001\f\u0018\u00031\u0001H.Y2fQ>dG-\u001a:t\u0015\tA\u0012$\u0001\u0005qC\u000e\\\u0017mZ3s\u0015\tQ2$\u0001\u0005yY\u0012,\u0007\u000f\\8z\u0015\taR$A\u0005yK\nL\u0017\r\\1cg*\ta$A\u0002d_6\u001c\u0001\u0001\u0005\u0002\"\u00035\tQCA\u000bT_V\u00148-Z!si&4\u0017m\u0019;TG\u0006tg.\u001a:\u0014\u0005\u0005!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002A\u00051An\\4hKJ,\u0012A\f\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nQa\u001d7gi)T\u0011aM\u0001\u0004_J<\u0017BA\u001b1\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013a\u00023fm:+H\u000e\\\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011AhF\u0001\u0003S>L!AP\u001e\u0003\u000f\u0011+gOT;mY\u0006AA-\u001a<Ok2d\u0007%A\u0007eKZtU\u000f\u001c7Xe&$XM]\u000b\u0002\u0005B\u00111iR\u0007\u0002\t*\u0011A(\u0012\u0006\u0002\r\u0006!!.\u0019<b\u0013\tAEI\u0001\nPkR\u0004X\u000f^*ue\u0016\fWn\u0016:ji\u0016\u0014\u0018A\u00043fm:+H\u000e\\,sSR,'\u000fI\n\u0003\u0013\u0011\nqb\u001d;sK\u0006lWM\u001d$bGR|'/\u001f\t\u0003u5K!AT\u001e\u0003\u001fM#(/Z1nKJ4\u0015m\u0019;pef$\"\u0001U)\u0011\u0005\u0005J\u0001\"B&\f\u0001\u0004a\u0015AD3oe&\u001c\u0007.\u0011:uS\u001a\f7\r\u001e\u000b\u0005)^;w\u000e\u0005\u0002&+&\u0011aK\n\u0002\u0005+:LG\u000fC\u0003Y\u0019\u0001\u0007\u0011,\u0001\u0002tCB\u0011!,Z\u0007\u00027*\u0011A,X\u0001\tCJ$\u0018NZ1di*\u0011alX\u0001\u0004k\u0012l'B\u00011b\u0003\r\t\u0007/\u001b\u0006\u0003E\u000e\fa\u0001\u001d7vO&t'B\u00013\u001c\u0003!!W\r\u001d7ps&$\u0018B\u00014\\\u00059\u0019v.\u001e:dK\u0006\u0013H/\u001b4bGRDQ\u0001\u001b\u0007A\u0002%\f!b\u001d;sK\u0006lg)\u001b7f!\r)#\u000e\\\u0005\u0003W\u001a\u0012aa\u00149uS>t\u0007CA\u0011n\u0013\tqWC\u0001\u0006TiJ,\u0017-\u001c$jY\u0016DQ\u0001\u001d\u0007A\u0002E\fQ\"\\3tg\u0006<W\rR5hKN$\bcA\u0013si&\u00111O\n\u0002\n\rVt7\r^5p]B\u0002\"!\u001e=\u000e\u0003YT!a^#\u0002\u0011M,7-\u001e:jifL!!\u001f<\u0003\u001b5+7o]1hK\u0012Kw-Z:u\u0003Y\u00198-\u00198B]\u0012\u001c\u0015\r\\2vY\u0006$X\rR5hKN$H#\u0002+}{z|\b\"\u0002-\u000e\u0001\u0004I\u0006\"\u00025\u000e\u0001\u0004I\u0007\"\u00029\u000e\u0001\u0004\t\b\"CA\u0001\u001bA\u0005\t\u0019AA\u0002\u0003!I7OU3tG\u0006t\u0007cA\u0013\u0002\u0006%\u0019\u0011q\u0001\u0014\u0003\u000f\t{w\u000e\\3b]\u0006\u00013oY1o\u0003:$7)\u00197dk2\fG/\u001a#jO\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\tiA\u000b\u0003\u0002\u0004\u0005=1FAA\t!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005ma%\u0001\u0006b]:|G/\u0019;j_:LA!a\b\u0002\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002=\r\fGnY;mCR,\u0007\u000b\\1dK\"|G\u000eZ3sg\u0006sG\rR5hKN$H#\u0003+\u0002&\u0005\u001d\u0012\u0011FA\u001b\u0011\u0015Av\u00021\u0001Z\u0011\u0015Aw\u00021\u0001j\u0011\u001d\tYc\u0004a\u0001\u0003[\t\u0011\"\\;ti\u0006\u001c\u0007.\u001a:\u0011\t\u0005=\u0012\u0011G\u0007\u0002/%\u0019\u00111G\f\u0003\u00135+8\u000f^1dQ\u0016\u0014\bbBA\u001c\u001f\u0001\u0007\u0011\u0011H\u0001\n_B$H)[4fgR\u00042!\n6u\u0003I\u00198-\u00198G_2$WM]!si&4\u0017m\u0019;\u0015\u0013Q\u000by$!\u0013\u0002L\u0005=\u0003bBA!!\u0001\u0007\u00111I\u0001\u0003M\u0006\u00042AWA#\u0013\r\t9e\u0017\u0002\u000f\r>dG-\u001a:BeRLg-Y2u\u0011\u0015A\u0007\u00031\u0001j\u0011\u001d\ti\u0005\u0005a\u0001\u0003s\ta\u0001Z5hKN$\bbBA\u0016!\u0001\u0007\u0011QF\u0001\u001ag\u000e\fgNR5mK>\u0013\u0018I]2iSZ,\u0017I\u001d;jM\u0006\u001cG\u000fF\u0005U\u0003+\n9&!\u0017\u0002\\!)\u0001,\u0005a\u00013\")\u0001.\u0005a\u0001Y\"9\u0011QJ\tA\u0002\u0005e\u0002bBA\u0016#\u0001\u0007\u0011QF\u0001\u0019kB$\u0017\r^3ES\u001e,7\u000f^,ji\"4\u0015\u000e\\3oC6,G#\u0002+\u0002b\u0005-\u0004bBA2%\u0001\u0007\u0011QM\u0001\u0006K:$(/\u001f\t\u0004u\u0005\u001d\u0014bAA5w\tY1\u000b\u001e:fC6,e\u000e\u001e:z\u0011\u0019\tiE\u0005a\u0001i\u00061Am\\*dC:$\u0012\u0002VA9\u0003g\n)(a\u001e\t\u000ba\u001b\u0002\u0019A-\t\u000f\u0005\r4\u00031\u0001\u0002f!9\u00111F\nA\u0002\u00055\u0002bBA='\u0001\u0007\u00111P\u0001\niJ\fgn\u001d4pe6\u0004r!JA?\u0003\u0003\u000b\t)C\u0002\u0002\u0000\u0019\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007\r\u000b\u0019)C\u0002\u0002\u0006\u0012\u00131\"\u00138qkR\u001cFO]3b[\u0002")
public class SourceArtifactScanner {
    private final StreamerFactory streamerFactory;

    public void enrichArtifact(SourceArtifact sa, Option<StreamFile> streamFile, Function0<MessageDigest> messageDigest) {
        this.scanAndCalculateDigest(sa, streamFile, messageDigest, this.scanAndCalculateDigest$default$4());
    }

    public void scanAndCalculateDigest(SourceArtifact sa, Option<StreamFile> streamFile, Function0<MessageDigest> messageDigest, boolean isRescan) {
        if (!PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).shouldScanPlaceholders() && PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).hasCheckSum()) {
            SourceArtifactScanner$.MODULE$.logger().info(new StringBuilder(75).append("Not enriching ").append(sa).append(" as no placeholders should be scanned and checksum is present").toString());
            return;
        }
        None$ digest = PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).shouldGenerateChecksum(isRescan) ? new Some(messageDigest.apply()) : None$.MODULE$;
        Mustacher mustacher = Mustacher$.MODULE$.apply(PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).mustacheDelimiters());
        this.calculatePlaceholdersAndDigest(sa, streamFile, mustacher, (Option<MessageDigest>)digest);
        sa.setPlaceholders(CollectionConverters$.MODULE$.SetHasAsJava(mustacher.placeholders()).asJava());
        digest.foreach((Function1 & Serializable)d -> {
            sa.setProperty("checksum", (Object)Hex.encodeHexString((byte[])d.digest()));
            return BoxedUnit.UNIT;
        });
    }

    public boolean scanAndCalculateDigest$default$4() {
        return false;
    }

    private void calculatePlaceholdersAndDigest(SourceArtifact sa, Option<StreamFile> streamFile, Mustacher mustacher, Option<MessageDigest> optDigest) {
        SourceArtifact sourceArtifact = sa;
        if (sourceArtifact instanceof FolderArtifact) {
            FolderArtifact folderArtifact = (FolderArtifact)sourceArtifact;
            SourceArtifactScanner$.MODULE$.logger().info(new StringBuilder(44).append("Going to scan artifact ").append(folderArtifact).append(" as a folder artifact").toString());
            this.scanFolderArtifact(folderArtifact, streamFile, optDigest, mustacher);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (streamFile.isEmpty()) {
            SourceArtifactScanner$.MODULE$.logger().info(new StringBuilder(23).append("Going to scan artifact ").append(sa).toString());
            TryWith$.MODULE$.apply((Function0 & Serializable)() -> sa.getFile().getInputStream(), (Function1 & Serializable)fis -> {
                this.scanFileOrArchiveArtifact(sa, new StreamFile(sa.getFile().getName(), fis), (Option<MessageDigest>)optDigest, mustacher);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            SourceArtifactScanner$.MODULE$.logger().info(new StringBuilder(35).append("Going to scan artifact ").append(sa).append(" from stream").toString());
            this.scanFileOrArchiveArtifact(sa, (StreamFile)streamFile.get(), optDigest, mustacher);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void scanFolderArtifact(FolderArtifact fa, Option<StreamFile> streamFile, Option<MessageDigest> digest, Mustacher mustacher) {
        Streamer streamer;
        Option<StreamFile> option = streamFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            StreamFile x = (StreamFile)some.value();
            streamer = this.streamerFactory.streamer(x.inputStream(), x.name(), this.streamerFactory.streamer$default$3());
        } else if (None$.MODULE$.equals(option)) {
            streamer = this.streamerFactory.streamer(PlaceholdersUtil$.MODULE$.SourceArtifactUtil((SourceArtifact)fa).toLocalFile());
        } else {
            throw new MatchError(option);
        }
        Streamer streamer2 = streamer;
        streamer2.stream().foreach((Function1 & Serializable)entry -> {
            SourceArtifactScanner.$anonfun$scanFolderArtifact$1(this, digest, fa, mustacher, entry);
            return BoxedUnit.UNIT;
        });
    }

    private void scanFileOrArchiveArtifact(SourceArtifact sa, StreamFile streamFile, Option<MessageDigest> digest, Mustacher mustacher) {
        InputStream inputStream = (InputStream)digest.map((Function1 & Serializable)x$2 -> new DigestInputStream(streamFile.inputStream(), (MessageDigest)x$2)).getOrElse((Function0 & Serializable)() -> streamFile.inputStream());
        if (!PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).shouldScanPlaceholders()) {
            SourceArtifactScanner$.MODULE$.logger().debug(new StringBuilder(45).append("Artifact [").append(sa).append("] has disabled placeholder scanning").toString());
        } else {
            this.streamerFactory.streamer(inputStream, streamFile.name(), this.streamerFactory.streamer$default$3()).stream().foreach((Function1 & Serializable)entry -> {
                this.doScan(sa, entry, mustacher, (Function1<InputStream, InputStream>)(Function1 & Serializable)x -> (InputStream)Predef$.MODULE$.identity(x));
                return BoxedUnit.UNIT;
            });
        }
        OverthereUtils.write((InputStream)inputStream, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
    }

    private void updateDigestWithFilename(StreamEntry entry, MessageDigest digest) {
        String digestPath = new StringBuilder(0).append(entry.getPath()).append((Object)(entry.isDirectory() ? File.separator : "")).toString();
        digestPath = digestPath.replace("\\", "/");
        SourceArtifactScanner$.MODULE$.logger().trace(new StringBuilder(46).append("scanFolderArtifact: update digest with path [").append(digestPath).append("]").toString());
        digest.update(digestPath.getBytes(StandardCharsets.UTF_8));
    }

    private void doScan(SourceArtifact sa, StreamEntry entry, Mustacher mustacher, Function1<InputStream, InputStream> transform) {
        if (entry.isDirectory()) {
            return;
        }
        TryWith$.MODULE$.apply((Function0 & Serializable)() -> entry.getInputStream(), (Function1 & Serializable)inputStream -> {
            Try try_;
            InputStream is = (InputStream)transform.apply(inputStream);
            StreamerFactory sf = $this.streamerFactory;
            ProcessingType processingType = PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).getScanTypeForEntry(entry, sf);
            if (DigestOnly$.MODULE$.equals(processingType)) {
                SourceArtifactScanner$.MODULE$.logger().debug(new StringBuilder(11).append(sa).append(": Skipping ").append(entry.getName()).toString());
                OverthereUtils.write((InputStream)is, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
                try_ = BoxedUnit.UNIT;
            } else if (ProcessArchive$.MODULE$.equals(processingType)) {
                SourceArtifactScanner$.MODULE$.logger().debug(new StringBuilder(23).append(sa).append(": Detected archive for ").append(entry.getName()).toString());
                $this.streamerFactory.streamer(is, entry.getName(), $this.streamerFactory.streamer$default$3()).stream().foreach((Function1 & Serializable)e2 -> {
                    this.doScan(sa, e2, mustacher, (Function1<InputStream, InputStream>)(Function1 & Serializable)x -> (InputStream)Predef$.MODULE$.identity(x));
                    return BoxedUnit.UNIT;
                });
                OverthereUtils.write((InputStream)is, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
                try_ = BoxedUnit.UNIT;
            } else if (ProcessTextFile$.MODULE$.equals(processingType)) {
                InputStreamReader inputStreamReader;
                SourceArtifactScanner$.MODULE$.logger().debug(new StringBuilder(18).append(sa).append(": ").append(entry.getName()).append(" is a text file.").toString());
                InputStream resettableInputStream = ArtifactIOUtils$.MODULE$.getResettableInputStream(is);
                BOM bOM = DetectBOM$.MODULE$.detect(resettableInputStream);
                if (((Object)((Object)BOM.NONE)).equals((Object)bOM)) {
                    inputStreamReader = new InputStreamReader(resettableInputStream);
                } else if (bOM != null) {
                    BOM bOM2 = bOM;
                    inputStreamReader = new InputStreamReader(resettableInputStream, bOM2.getCharset());
                } else {
                    throw new MatchError((Object)bOM);
                }
                InputStreamReader reader = inputStreamReader;
                try_ = TryWith$.MODULE$.apply((Function0 & Serializable)() -> mustacher.newReader(reader), (Function1 & Serializable)r -> {
                    SourceArtifactScanner.$anonfun$doScan$6(r);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError((Object)processingType);
            }
            return try_;
        });
    }

    public static final /* synthetic */ void $anonfun$scanFolderArtifact$1(SourceArtifactScanner $this, Option digest$1, FolderArtifact fa$1, Mustacher mustacher$2, StreamEntry entry) {
        digest$1.foreach((Function1 & Serializable)d -> {
            $this.updateDigestWithFilename(entry, d);
            return BoxedUnit.UNIT;
        });
        $this.doScan((SourceArtifact)fa$1, entry, mustacher$2, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> (InputStream)digest$1.map((Function1 & Serializable)x$1 -> new DigestInputStream((InputStream)is, (MessageDigest)x$1)).getOrElse((Function0 & Serializable)() -> is));
    }

    public static final /* synthetic */ void $anonfun$doScan$6(MustacheScanningReader r) {
        OverthereUtils.write((Reader)r, (Writer)SourceArtifactScanner$.MODULE$.devNullWriter());
    }

    public SourceArtifactScanner(StreamerFactory streamerFactory) {
        this.streamerFactory = streamerFactory;
    }
}

