/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginVersions {
    public static final String TYPE_SQL = "sql";
    private static final Map<String, PluginVersion> PLUGIN_VERSIONS = new LinkedHashMap<String, PluginVersion>();
    private static final Logger logger = LoggerFactory.getLogger(PluginVersions.class);

    static void init() {
        try {
            Enumeration<URL> resources = ClassLoaderUtils$.MODULE$.classLoader().getResources("plugin-version.properties");
            PluginVersions.forEachRemaining(resources, PluginVersions::readPluginVersion);
        }
        catch (RuntimeIOException | IOException e) {
            logger.error("Couldn't read plugin-version.properties", e);
            throw new IllegalStateException(e);
        }
    }

    public static String getVersionFor(String plugin) {
        PluginVersion pluginVersion = PluginVersions.getPluginVersionFor(plugin);
        if (pluginVersion == null) {
            return null;
        }
        return pluginVersion.version;
    }

    public static boolean hasTypeFor(String plugin, String type) {
        PluginVersion pluginVersion = PluginVersions.getPluginVersionFor(plugin);
        if (pluginVersion == null || pluginVersion.type == null) {
            return TYPE_SQL.equals(type);
        }
        return type.equals(pluginVersion.type);
    }

    public static PluginVersion getPluginVersionFor(String plugin) {
        return PLUGIN_VERSIONS.get(plugin);
    }

    public static Set<String> getRegisteredPlugins() {
        return PLUGIN_VERSIONS.keySet();
    }

    private static void readPluginVersion(URL url) {
        try (InputStream input = url.openStream();){
            Properties properties = new Properties();
            properties.load(input);
            String plugin = properties.getProperty("plugin");
            String type = properties.getProperty("type");
            String version = properties.getProperty("version");
            if (plugin == null) {
                throw new IllegalStateException(String.format("Couldn't read plugin-version.properties: plugin property is missing in '%s'.", url));
            }
            PLUGIN_VERSIONS.put(plugin, new PluginVersion(type, version));
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    private static <T> void forEachRemaining(Enumeration<T> e, Consumer<? super T> c) {
        while (e.hasMoreElements()) {
            c.accept(e.nextElement());
        }
    }

    private static class PluginVersion {
        final String type;
        final String version;

        private PluginVersion(String type, String version) {
            this.type = type;
            this.version = version;
        }
    }
}

