/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.DeadLetterSuppression;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterHeartbeatReceiver$;
import akka.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import akka.cluster.ClusterHeartbeatSenderState;
import akka.cluster.ClusterLogClass$;
import akka.cluster.ClusterLogMarker$;
import akka.cluster.ClusterMessage;
import akka.cluster.HeartbeatNodeRing;
import akka.cluster.Member;
import akka.cluster.UniqueAddress;
import akka.event.ActorWithLogClass;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.remote.FailureDetectorRegistry;
import akka.remote.HeartbeatMessage;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r=xACA\u0004\u0003\u0013A\t!!\u0003\u0002\u0012\u0019Q\u0011QCA\u0005\u0011\u0003\tI!a\u0006\t\u000f\u0005\u0015\u0012\u0001\"\u0001\u0002*\u00191\u00111F\u0001C\u0003[A!\"a\u001b\u0004\u0005+\u0007I\u0011AA7\u0011)\t)h\u0001B\tB\u0003%\u0011q\u000e\u0005\u000b\u0003o\u001a!Q3A\u0005\u0002\u0005e\u0004BCAA\u0007\tE\t\u0015!\u0003\u0002|!Q\u00111Q\u0002\u0003\u0016\u0004%\t!!\u001f\t\u0015\u0005\u00155A!E!\u0002\u0013\tY\bC\u0004\u0002&\r!\t!a\"\t\u0013\u0005M5!!A\u0005\u0002\u0005U\u0005\"CAO\u0007E\u0005I\u0011AAP\u0011%\t)lAI\u0001\n\u0003\t9\fC\u0005\u0002<\u000e\t\n\u0011\"\u0001\u00028\"I\u0011QX\u0002\u0002\u0002\u0013\u0005\u0013q\u0018\u0005\n\u0003#\u001c\u0011\u0011!C\u0001\u0003'D\u0011\"a7\u0004\u0003\u0003%\t!!8\t\u0013\u0005%8!!A\u0005B\u0005-\b\"CA}\u0007\u0005\u0005I\u0011AA~\u0011%\u0011)aAA\u0001\n\u0003\u00129\u0001C\u0005\u0003\f\r\t\t\u0011\"\u0011\u0003\u000e!I!qB\u0002\u0002\u0002\u0013\u0005#\u0011\u0003\u0005\n\u0005'\u0019\u0011\u0011!C!\u0005+9\u0011B!\u0007\u0002\u0003\u0003E\tAa\u0007\u0007\u0013\u0005-\u0012!!A\t\u0002\tu\u0001bBA\u00133\u0011\u0005!Q\u0007\u0005\n\u0005\u001fI\u0012\u0011!C#\u0005#A\u0011Ba\u000e\u001a\u0003\u0003%\tI!\u000f\t\u0013\t\u0005\u0013$!A\u0005\u0002\n\r\u0003\"\u0003B+3\u0005\u0005I\u0011\u0002B,\r\u0019\u0011y&\u0001\"\u0003b!Q\u00111N\u0010\u0003\u0016\u0004%\tAa\u0019\t\u0015\u0005UtD!E!\u0002\u0013\u0011)\u0007\u0003\u0006\u0002x}\u0011)\u001a!C\u0001\u0003sB!\"!! \u0005#\u0005\u000b\u0011BA>\u0011)\t\u0019i\bBK\u0002\u0013\u0005\u0011\u0011\u0010\u0005\u000b\u0003\u000b{\"\u0011#Q\u0001\n\u0005m\u0004bBA\u0013?\u0011\u0005!1\u000e\u0005\n\u0003'{\u0012\u0011!C\u0001\u0005kB\u0011\"!( #\u0003%\tA! \t\u0013\u0005Uv$%A\u0005\u0002\u0005]\u0006\"CA^?E\u0005I\u0011AA\\\u0011%\tilHA\u0001\n\u0003\ny\fC\u0005\u0002R~\t\t\u0011\"\u0001\u0002T\"I\u00111\\\u0010\u0002\u0002\u0013\u0005!\u0011\u0011\u0005\n\u0003S|\u0012\u0011!C!\u0003WD\u0011\"!? \u0003\u0003%\tA!\"\t\u0013\t\u0015q$!A\u0005B\t%\u0005\"\u0003B\u0006?\u0005\u0005I\u0011\tB\u0007\u0011%\u0011yaHA\u0001\n\u0003\u0012\t\u0002C\u0005\u0003\u0014}\t\t\u0011\"\u0011\u0003\u000e\u001eI!\u0011S\u0001\u0002\u0002#\u0005!1\u0013\u0004\n\u0005?\n\u0011\u0011!E\u0001\u0005+Cq!!\n6\t\u0003\u0011I\nC\u0005\u0003\u0010U\n\t\u0011\"\u0012\u0003\u0012!I!qG\u001b\u0002\u0002\u0013\u0005%1\u0014\u0005\n\u0005\u0003*\u0014\u0011!CA\u0005GC\u0011B!\u00166\u0003\u0003%IAa\u0016\b\u000f\t-\u0016\u0001#!\u0003.\u001a9!qV\u0001\t\u0002\nE\u0006bBA\u0013y\u0011\u0005!1\u0017\u0005\n\u0003{c\u0014\u0011!C!\u0003\u007fC\u0011\"!5=\u0003\u0003%\t!a5\t\u0013\u0005mG(!A\u0005\u0002\tU\u0006\"CAuy\u0005\u0005I\u0011IAv\u0011%\tI\u0010PA\u0001\n\u0003\u0011I\fC\u0005\u0003\fq\n\t\u0011\"\u0011\u0003\u000e!I!q\u0002\u001f\u0002\u0002\u0013\u0005#\u0011\u0003\u0005\n\u0005+b\u0014\u0011!C\u0005\u0005/2aA!0\u0002\u0005\n}\u0006BCA6\r\nU\r\u0011\"\u0001\u0003d!Q\u0011Q\u000f$\u0003\u0012\u0003\u0006IA!\u001a\t\u000f\u0005\u0015b\t\"\u0001\u0003B\"I\u00111\u0013$\u0002\u0002\u0013\u0005!q\u0019\u0005\n\u0003;3\u0015\u0013!C\u0001\u0005{B\u0011\"!0G\u0003\u0003%\t%a0\t\u0013\u0005Eg)!A\u0005\u0002\u0005M\u0007\"CAn\r\u0006\u0005I\u0011\u0001Bf\u0011%\tIORA\u0001\n\u0003\nY\u000fC\u0005\u0002z\u001a\u000b\t\u0011\"\u0001\u0003P\"I!Q\u0001$\u0002\u0002\u0013\u0005#1\u001b\u0005\n\u0005\u00171\u0015\u0011!C!\u0005\u001bA\u0011Ba\u0004G\u0003\u0003%\tE!\u0005\t\u0013\tMa)!A\u0005B\t]w!\u0003Bn\u0003\u0005\u0005\t\u0012\u0001Bo\r%\u0011i,AA\u0001\u0012\u0003\u0011y\u000eC\u0004\u0002&Y#\tAa:\t\u0013\t=a+!A\u0005F\tE\u0001\"\u0003B\u001c-\u0006\u0005I\u0011\u0011Bu\u0011%\u0011\tEVA\u0001\n\u0003\u0013i\u000fC\u0005\u0003VY\u000b\t\u0011\"\u0003\u0003X\u0019I\u0011QCA\u0005\u0001\u0005%!1\u001f\u0005\b\u0003KaF\u0011\u0001B~\u0011%\tY\u0001\u0018b\u0001\n\u0003\u0011y\u0010\u0003\u0005\u0004\bq\u0003\u000b\u0011BB\u0001\u0011%\u0019I\u0001\u0018b\u0001\n\u0003\u0019Y\u0001\u0003\u0005\u0004\u000eq\u0003\u000b\u0011BA\u007f\u0011%\u0019y\u0001\u0018b\u0001\n\u0013\u0019\t\u0002\u0003\u0005\u0004\u001eq\u0003\u000b\u0011BB\n\u0011%\u0019y\u0002\u0018b\u0001\n\u0003\u0019\t\u0003\u0003\u0005\u00040q\u0003\u000b\u0011BB\u0012\u0011%\t9\b\u0018a\u0001\n\u0003\t\u0019\u000eC\u0005\u00042q\u0003\r\u0011\"\u0001\u00044!A\u0011\u0011\u0011/!B\u0013\t)\u000eC\u0004\u0004>q#\taa\u0010\t\u0013\r\u0015CL1A\u0005\u0002\r\u001d\u0003\u0002CB(9\u0002\u0006Ia!\u0013\t\u0013\rEC\f1A\u0005\u0002\rM\u0003\"CB.9\u0002\u0007I\u0011AB/\u0011!\u0019\t\u0007\u0018Q!\n\rU\u0003\"CB29\n\u0007I\u0011AB3\u0011!\u0019i\u0007\u0018Q\u0001\n\r\u001d\u0004\"CB89\u0002\u0007I\u0011BA=\u0011%\u0019\t\b\u0018a\u0001\n\u0013\u0019\u0019\b\u0003\u0005\u0004xq\u0003\u000b\u0015BA>\u0011\u001d\u0019I\b\u0018C!\u0007wBqa! ]\t\u0003\u001aY\bC\u0004\u0004\u0000q#\ta!!\t\u000f\r5E\f\"\u0001\u0004\u0010\"91q\u0014/\u0005\u0002\r=\u0005bBBQ9\u0012\u00051q\u0012\u0005\b\u0007GcF\u0011ABS\u0011\u001d\u0019\t\r\u0018C\u0001\u0007\u0007Dqa!3]\t\u0003\u0019Y\rC\u0004\u0004Pr#\ta!5\t\u000f\rUG\f\"\u0001\u0004X\"911\u001c/\u0005\u0002\rm\u0004bBBo9\u0012%11\u0010\u0005\b\u0007?dF\u0011ABq\u0011\u001d\u0019I\u000f\u0018C\u0001\u0007W\fac\u00117vgR,'\u000fS3beR\u0014W-\u0019;TK:$WM\u001d\u0006\u0005\u0003\u0017\ti!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u0005=\u0011\u0001B1lW\u0006\u00042!a\u0005\u0002\u001b\t\tIA\u0001\fDYV\u001cH/\u001a:IK\u0006\u0014HOY3biN+g\u000eZ3s'\r\t\u0011\u0011\u0004\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0011\u0011qD\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003G\tiB\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\u0011\u0011\u0011\u0003\u0002\n\u0011\u0016\f'\u000f\u001e2fCR\u001cRbAA\r\u0003_\t)$!\u0011\u0002N\u0005M\u0003\u0003BA\n\u0003cIA!a\r\u0002\n\tq1\t\\;ti\u0016\u0014X*Z:tC\u001e,\u0007\u0003BA\u001c\u0003{i!!!\u000f\u000b\t\u0005m\u0012QB\u0001\u0007e\u0016lw\u000e^3\n\t\u0005}\u0012\u0011\b\u0002\u0011\u0011\u0016\f'\u000f\u001e2fCRlUm]:bO\u0016\u0004B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\ni!A\u0003bGR|'/\u0003\u0003\u0002L\u0005\u0015#!\u0006#fC\u0012dU\r\u001e;feN+\b\u000f\u001d:fgNLwN\u001c\t\u0005\u00037\ty%\u0003\u0003\u0002R\u0005u!a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003+\n)G\u0004\u0003\u0002X\u0005\u0005d\u0002BA-\u0003?j!!a\u0017\u000b\t\u0005u\u0013qE\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005}\u0011\u0002BA2\u0003;\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002h\u0005%$\u0001D*fe&\fG.\u001b>bE2,'\u0002BA2\u0003;\tAA\u001a:p[V\u0011\u0011q\u000e\t\u0005\u0003\u0007\n\t(\u0003\u0003\u0002t\u0005\u0015#aB!eIJ,7o]\u0001\u0006MJ|W\u000eI\u0001\u000bg\u0016\fX/\u001a8dK:\u0013XCAA>!\u0011\tY\"! \n\t\u0005}\u0014Q\u0004\u0002\u0005\u0019>tw-A\u0006tKF,XM\\2f\u001dJ\u0004\u0013!E2sK\u0006$\u0018n\u001c8US6,g*\u00198pg\u0006\u00112M]3bi&|g\u000eV5nK:\u000bgn\\:!)!\tI)!$\u0002\u0010\u0006E\u0005cAAF\u00075\t\u0011\u0001C\u0004\u0002l)\u0001\r!a\u001c\t\u000f\u0005]$\u00021\u0001\u0002|!9\u00111\u0011\u0006A\u0002\u0005m\u0014\u0001B2paf$\u0002\"!#\u0002\u0018\u0006e\u00151\u0014\u0005\n\u0003WZ\u0001\u0013!a\u0001\u0003_B\u0011\"a\u001e\f!\u0003\u0005\r!a\u001f\t\u0013\u0005\r5\u0002%AA\u0002\u0005m\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003CSC!a\u001c\u0002$.\u0012\u0011Q\u0015\t\u0005\u0003O\u000b\t,\u0004\u0002\u0002**!\u00111VAW\u0003%)hn\u00195fG.,GM\u0003\u0003\u00020\u0006u\u0011AC1o]>$\u0018\r^5p]&!\u00111WAU\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIL\u000b\u0003\u0002|\u0005\r\u0016AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0005\u0007\u0003BAb\u0003\u001bl!!!2\u000b\t\u0005\u001d\u0017\u0011Z\u0001\u0005Y\u0006twM\u0003\u0002\u0002L\u0006!!.\u0019<b\u0013\u0011\ty-!2\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u000e\u0005\u0003\u0002\u001c\u0005]\u0017\u0002BAm\u0003;\u00111!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a8\u0002fB!\u00111DAq\u0013\u0011\t\u0019/!\b\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002hF\t\t\u00111\u0001\u0002V\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!<\u0011\r\u0005=\u0018Q_Ap\u001b\t\t\tP\u0003\u0003\u0002t\u0006u\u0011AC2pY2,7\r^5p]&!\u0011q_Ay\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005u(1\u0001\t\u0005\u00037\ty0\u0003\u0003\u0003\u0002\u0005u!a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003O\u001c\u0012\u0011!a\u0001\u0003?\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011\u0019B\u0005\u0011%\t9\u000fFA\u0001\u0002\u0004\t).\u0001\u0005iCND7i\u001c3f)\t\t).\u0001\u0005u_N#(/\u001b8h)\t\t\t-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003{\u00149\u0002C\u0005\u0002h^\t\t\u00111\u0001\u0002`\u0006I\u0001*Z1si\n,\u0017\r\u001e\t\u0004\u0003\u0017K2#B\r\u0003 \t-\u0002\u0003\u0004B\u0011\u0005O\ty'a\u001f\u0002|\u0005%UB\u0001B\u0012\u0015\u0011\u0011)#!\b\u0002\u000fI,h\u000e^5nK&!!\u0011\u0006B\u0012\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005[\u0011\u0019$\u0004\u0002\u00030)!!\u0011GAe\u0003\tIw.\u0003\u0003\u0002h\t=BC\u0001B\u000e\u0003\u0015\t\u0007\u000f\u001d7z)!\tIIa\u000f\u0003>\t}\u0002bBA69\u0001\u0007\u0011q\u000e\u0005\b\u0003ob\u0002\u0019AA>\u0011\u001d\t\u0019\t\ba\u0001\u0003w\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003F\tE\u0003CBA\u000e\u0005\u000f\u0012Y%\u0003\u0003\u0003J\u0005u!AB(qi&|g\u000e\u0005\u0006\u0002\u001c\t5\u0013qNA>\u0003wJAAa\u0014\u0002\u001e\t1A+\u001e9mKNB\u0011Ba\u0015\u001e\u0003\u0003\u0005\r!!#\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003ZA!\u00111\u0019B.\u0013\u0011\u0011i&!2\u0003\r=\u0013'.Z2u\u00051AU-\u0019:uE\u0016\fGOU:q'5y\u0012\u0011DA\u0018\u0003k\t\t%!\u0014\u0002TU\u0011!Q\r\t\u0005\u0003'\u00119'\u0003\u0003\u0003j\u0005%!!D+oSF,X-\u00113ee\u0016\u001c8\u000f\u0006\u0005\u0003n\t=$\u0011\u000fB:!\r\tYi\b\u0005\b\u0003W2\u0003\u0019\u0001B3\u0011\u001d\t9H\na\u0001\u0003wBq!a!'\u0001\u0004\tY\b\u0006\u0005\u0003n\t]$\u0011\u0010B>\u0011%\tYg\nI\u0001\u0002\u0004\u0011)\u0007C\u0005\u0002x\u001d\u0002\n\u00111\u0001\u0002|!I\u00111Q\u0014\u0011\u0002\u0003\u0007\u00111P\u000b\u0003\u0005\u007fRCA!\u001a\u0002$R!\u0011q\u001cBB\u0011%\t9/LA\u0001\u0002\u0004\t)\u000e\u0006\u0003\u0002~\n\u001d\u0005\"CAt_\u0005\u0005\t\u0019AAp)\u0011\t\tMa#\t\u0013\u0005\u001d\b'!AA\u0002\u0005UG\u0003BA\u007f\u0005\u001fC\u0011\"a:4\u0003\u0003\u0005\r!a8\u0002\u0019!+\u0017M\u001d;cK\u0006$(k\u001d9\u0011\u0007\u0005-UgE\u00036\u0005/\u0013Y\u0003\u0005\u0007\u0003\"\t\u001d\"QMA>\u0003w\u0012i\u0007\u0006\u0002\u0003\u0014RA!Q\u000eBO\u0005?\u0013\t\u000bC\u0004\u0002la\u0002\rA!\u001a\t\u000f\u0005]\u0004\b1\u0001\u0002|!9\u00111\u0011\u001dA\u0002\u0005mD\u0003\u0002BS\u0005S\u0003b!a\u0007\u0003H\t\u001d\u0006CCA\u000e\u0005\u001b\u0012)'a\u001f\u0002|!I!1K\u001d\u0002\u0002\u0003\u0007!QN\u0001\u000e\u0011\u0016\f'\u000f\u001e2fCR$\u0016nY6\u0011\u0007\u0005-EHA\u0007IK\u0006\u0014HOY3biRK7m[\n\by\u0005e\u0011QJA*)\t\u0011i\u000b\u0006\u0003\u0002`\n]\u0006\"CAt\u0001\u0006\u0005\t\u0019AAk)\u0011\tiPa/\t\u0013\u0005\u001d()!AA\u0002\u0005}'AF#ya\u0016\u001cG/\u001a3GSJ\u001cH\u000fS3beR\u0014W-\u0019;\u0014\u000f\u0019\u000bI\"!\u0014\u0002TQ!!1\u0019Bc!\r\tYI\u0012\u0005\b\u0003WJ\u0005\u0019\u0001B3)\u0011\u0011\u0019M!3\t\u0013\u0005-$\n%AA\u0002\t\u0015D\u0003BAp\u0005\u001bD\u0011\"a:O\u0003\u0003\u0005\r!!6\u0015\t\u0005u(\u0011\u001b\u0005\n\u0003O\u0004\u0016\u0011!a\u0001\u0003?$B!!1\u0003V\"I\u0011q])\u0002\u0002\u0003\u0007\u0011Q\u001b\u000b\u0005\u0003{\u0014I\u000eC\u0005\u0002hR\u000b\t\u00111\u0001\u0002`\u00061R\t\u001f9fGR,GMR5sgRDU-\u0019:uE\u0016\fG\u000fE\u0002\u0002\fZ\u001bRA\u0016Bq\u0005W\u0001\u0002B!\t\u0003d\n\u0015$1Y\u0005\u0005\u0005K\u0014\u0019CA\tBEN$(/Y2u\rVt7\r^5p]F\"\"A!8\u0015\t\t\r'1\u001e\u0005\b\u0003WJ\u0006\u0019\u0001B3)\u0011\u0011yO!=\u0011\r\u0005m!q\tB3\u0011%\u0011\u0019FWA\u0001\u0002\u0004\u0011\u0019mE\u0003]\u00033\u0011)\u0010\u0005\u0003\u0002D\t]\u0018\u0002\u0002B}\u0003\u000b\u0012Q!Q2u_J$\"A!@\u0011\u0007\u0005MA,\u0006\u0002\u0004\u0002A!\u00111CB\u0002\u0013\u0011\u0019)!!\u0003\u0003\u000f\rcWo\u001d;fe\u0006A1\r\\;ti\u0016\u0014\b%\u0001\twKJ\u0014wn]3IK\u0006\u0014HOY3biV\u0011\u0011Q`\u0001\u0012m\u0016\u0014(m\\:f\u0011\u0016\f'\u000f\u001e2fCR\u0004\u0013!D2mkN$XM\u001d'pO\u001e,'/\u0006\u0002\u0004\u0014A!1QCB\r\u001d\r\u00199BX\u0007\u00029&!11DB\u0002\u00055\u0019E.^:uKJdunZ4fe\u0006q1\r\\;ti\u0016\u0014Hj\\4hKJ\u0004\u0013\u0001\b4jYR,'/\u00138uKJt\u0017\r\\\"mkN$XM]'f[\n,'o]\u000b\u0003\u0007G\u0001\u0002\"a\u0007\u0004&\r%\u0012Q`\u0005\u0005\u0007O\tiBA\u0005Gk:\u001cG/[8ocA!\u00111CB\u0016\u0013\u0011\u0019i#!\u0003\u0003\r5+WNY3s\u0003u1\u0017\u000e\u001c;fe&sG/\u001a:oC2\u001cE.^:uKJlU-\u001c2feN\u0004\u0013AD:fcV,gnY3Oe~#S-\u001d\u000b\u0005\u0007k\u0019Y\u0004\u0005\u0003\u0002\u001c\r]\u0012\u0002BB\u001d\u0003;\u0011A!\u00168ji\"I\u0011q]4\u0002\u0002\u0003\u0007\u0011Q[\u0001\u000eg\u0016dg\rS3beR\u0014W-\u0019;\u0015\u0005\r\u0005\u0003cAB\"\u00079\u0019\u00111\u0003\u0001\u0002\u001f\u0019\f\u0017\u000e\\;sK\u0012+G/Z2u_J,\"a!\u0013\u0011\r\u0005]21JA8\u0013\u0011\u0019i%!\u000f\u0003/\u0019\u000b\u0017\u000e\\;sK\u0012+G/Z2u_J\u0014VmZ5tiJL\u0018\u0001\u00054bS2,(/\u001a#fi\u0016\u001cGo\u001c:!\u0003\u0015\u0019H/\u0019;f+\t\u0019)\u0006\u0005\u0003\u0002\u0014\r]\u0013\u0002BB-\u0003\u0013\u00111d\u00117vgR,'\u000fS3beR\u0014W-\u0019;TK:$WM]*uCR,\u0017!C:uCR,w\fJ3r)\u0011\u0019)da\u0018\t\u0013\u0005\u001dX.!AA\u0002\rU\u0013AB:uCR,\u0007%A\u0007iK\u0006\u0014HOY3biR\u000b7o[\u000b\u0003\u0007O\u0002B!a\u0011\u0004j%!11NA#\u0005-\u0019\u0015M\\2fY2\f'\r\\3\u0002\u001d!,\u0017M\u001d;cK\u0006$H+Y:lA\u0005iA/[2l)&lWm\u001d;b[B\f\u0011\u0003^5dWRKW.Z:uC6\u0004x\fJ3r)\u0011\u0019)d!\u001e\t\u0013\u0005\u001d(/!AA\u0002\u0005m\u0014A\u0004;jG.$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\taJ,7\u000b^1siR\u00111QG\u0001\ta>\u001cHo\u0015;pa\u0006\t\u0002.Z1si\n,\u0017\r\u001e*fG\u0016Lg/\u001a:\u0015\t\r\r5\u0011\u0012\t\u0005\u0003\u0007\u001a))\u0003\u0003\u0004\b\u0006\u0015#AD!di>\u00148+\u001a7fGRLwN\u001c\u0005\b\u0007\u00173\b\u0019AA8\u0003\u001d\tG\r\u001a:fgN\fqA]3dK&4X-\u0006\u0002\u0004\u0012B!11SBM\u001d\u0011\t\u0019e!&\n\t\r]\u0015QI\u0001\u0006\u0003\u000e$xN]\u0005\u0005\u00077\u001biJA\u0004SK\u000e,\u0017N^3\u000b\t\r]\u0015QI\u0001\rS:LG/[1mSjLgnZ\u0001\u0007C\u000e$\u0018N^3\u0002\t%t\u0017\u000e\u001e\u000b\u0005\u0007k\u00199\u000bC\u0004\u0004*j\u0004\raa+\u0002\u0011Mt\u0017\r]:i_R\u0004Ba!,\u0004<:!1qVB\\\u001d\u0011\u0019\tl!.\u000f\t\u0005e31W\u0005\u0003\u0003\u001fIA!a\u0003\u0002\u000e%!1\u0011XA\u0005\u00031\u0019E.^:uKJ,e/\u001a8u\u0013\u0011\u0019ila0\u0003'\r+(O]3oi\u000ecWo\u001d;feN#\u0018\r^3\u000b\t\re\u0016\u0011B\u0001\nC\u0012$W*Z7cKJ$Ba!\u000e\u0004F\"91qY>A\u0002\r%\u0012!A7\u0002\u0019I,Wn\u001c<f\u001b\u0016l'-\u001a:\u0015\t\rU2Q\u001a\u0005\b\u0007\u000fd\b\u0019AB\u0015\u0003E)hN]3bG\"\f'\r\\3NK6\u0014WM\u001d\u000b\u0005\u0007k\u0019\u0019\u000eC\u0004\u0004Hv\u0004\ra!\u000b\u0002\u001fI,\u0017m\u00195bE2,W*Z7cKJ$Ba!\u000e\u0004Z\"91q\u0019@A\u0002\r%\u0012!\u00035fCJ$(-Z1u\u0003E\u0019\u0007.Z2l)&\u001c7.\u00138uKJ4\u0018\r\\\u0001\rQ\u0016\f'\u000f\u001e2fCR\u00146\u000f\u001d\u000b\u0005\u0007k\u0019\u0019\u000f\u0003\u0005\u0004f\u0006\r\u0001\u0019ABt\u0003!\u0011Xm\u001d9p]N,\u0007cAB\"?\u0005)BO]5hO\u0016\u0014h)\u001b:ti\"+\u0017M\u001d;cK\u0006$H\u0003BB\u001b\u0007[D\u0001\"a\u001b\u0002\u0006\u0001\u0007!Q\r")
public class ClusterHeartbeatSender
implements Actor {
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private final Cluster.ClusterLogger clusterLogger;
    private final Function1<Member, Object> filterInternalClusterMembers;
    private int sequenceNr;
    private final FailureDetectorRegistry<Address> failureDetector;
    private ClusterHeartbeatSenderState state;
    private final Cancellable heartbeatTask;
    private long akka$cluster$ClusterHeartbeatSender$$tickTimestamp;
    private ActorContext context;
    private ActorRef self;

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    private Cluster.ClusterLogger clusterLogger() {
        return this.clusterLogger;
    }

    public Function1<Member, Object> filterInternalClusterMembers() {
        return this.filterInternalClusterMembers;
    }

    public int sequenceNr() {
        return this.sequenceNr;
    }

    public void sequenceNr_$eq(int x$1) {
        this.sequenceNr = x$1;
    }

    public Heartbeat selfHeartbeat() {
        this.sequenceNr_$eq(this.sequenceNr() + 1);
        return new Heartbeat(this.cluster().selfAddress(), this.sequenceNr(), System.nanoTime());
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public ClusterHeartbeatSenderState state() {
        return this.state;
    }

    public void state_$eq(ClusterHeartbeatSenderState x$1) {
        this.state = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    private long akka$cluster$ClusterHeartbeatSender$$tickTimestamp() {
        return this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp;
    }

    public void akka$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(long x$1) {
        this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp = x$1;
    }

    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.ReachabilityEvent.class}));
    }

    public void postStop() {
        this.state().activeReceivers().foreach((Function1 & Serializable)a -> {
            ClusterHeartbeatSender.$anonfun$postStop$1(this, a);
            return BoxedUnit.UNIT;
        });
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.initializing();
    }

    public PartialFunction<Object, BoxedUnit> initializing() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.init(currentClusterState);
                    this.$outer.context().become(this.$outer.active());
                    object = BoxedUnit.UNIT;
                } else if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.akka$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(System.nanoTime());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ClusterEvent.CurrentClusterState ? true : ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.heartbeat();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof HeartbeatRsp) {
                    HeartbeatRsp heartbeatRsp = (HeartbeatRsp)A1;
                    this.$outer.heartbeatRsp(heartbeatRsp);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.UnreachableMember) {
                    ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)A1;
                    Member m = unreachableMember.member();
                    this.$outer.unreachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.ReachableMember) {
                    ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)A1;
                    Member m = reachableMember.member();
                    this.$outer.reachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ExpectedFirstHeartbeat) {
                    ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)A1;
                    UniqueAddress from = expectedFirstHeartbeat.from();
                    this.$outer.triggerFirstHeartbeat(from);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object) ? true : (object instanceof HeartbeatRsp ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : (object instanceof ClusterEvent.UnreachableMember ? true : (object instanceof ClusterEvent.ReachableMember ? true : object instanceof ExpectedFirstHeartbeat)))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet nodes2 = (SortedSet)snapshot.members().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply(A1)) ? A1.uniqueAddress() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Member x1) {
                Member member = x1;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)member));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        Set unreachable = (Set)snapshot.unreachable().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply(A1)) ? A1.uniqueAddress() : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Member x2) {
                Member member = x2;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)member));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.state_$eq(this.state().init((Set<UniqueAddress>)nodes2, (Set<UniqueAddress>)unreachable));
    }

    public void addMember(Member m) {
        block0: {
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) || this.state().contains(m.uniqueAddress()) || !BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m))) break block0;
            this.state_$eq(this.state().addMember(m.uniqueAddress()));
        }
    }

    public void removeMember(Member m) {
        block2: {
            if (!BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m))) break block2;
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
                this.context().stop(this.self());
            } else {
                this.state_$eq(this.state().removeMember(m.uniqueAddress()));
            }
        }
    }

    public void unreachableMember(Member m) {
        this.state_$eq(this.state().unreachableMember(m.uniqueAddress()));
    }

    public void reachableMember(Member m) {
        this.state_$eq(this.state().reachableMember(m.uniqueAddress()));
    }

    public void heartbeat() {
        Heartbeat nextHB = this.selfHeartbeat();
        this.state().activeReceivers().foreach((Function1 & Serializable)to -> {
            ClusterHeartbeatSender.$anonfun$heartbeat$1(this, nextHB, to);
            return BoxedUnit.UNIT;
        });
        this.checkTickInterval();
    }

    private void checkTickInterval() {
        long now = System.nanoTime();
        if (now - this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp() >= this.cluster().settings().HeartbeatInterval().toNanos() * 2L) {
            this.clusterLogger().logWarning(ClusterLogMarker$.MODULE$.heartbeatStarvation(), "Scheduled sending of heartbeat was delayed. Previous heartbeat was sent [{}] ms ago, expected interval is [{}] ms. This may cause failure detection to mark members as unreachable. The reason can be thread starvation, e.g. by running blocking tasks on the default dispatcher, CPU overload, or GC.", (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(now - this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp())), (Object)BoxesRunTime.boxToLong((long)this.cluster().settings().HeartbeatInterval().toMillis()));
        }
        this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(now);
    }

    public void heartbeatRsp(HeartbeatRsp response) {
        if (this.verboseHeartbeat()) {
            this.clusterLogger().logDebug("Heartbeat response from [{}]", response.from().address());
        }
        this.state_$eq(this.state().heartbeatRsp(response.from()));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        block1: {
            if (!this.state().activeReceivers().apply((Object)from) || this.failureDetector().isMonitoring((Object)from.address())) break block1;
            if (this.verboseHeartbeat()) {
                this.clusterLogger().logDebug("Trigger extra expected heartbeat from [{}]", from.address());
            }
            this.failureDetector().heartbeat((Object)from.address());
        }
    }

    public static final /* synthetic */ boolean $anonfun$filterInternalClusterMembers$1(ClusterHeartbeatSender $this, Member x$1) {
        String string = x$1.dataCenter();
        String string2 = $this.cluster().selfDataCenter();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$postStop$1(ClusterHeartbeatSender $this, UniqueAddress a) {
        $this.failureDetector().remove((Object)a.address());
    }

    public static final /* synthetic */ void $anonfun$heartbeat$1(ClusterHeartbeatSender $this, Heartbeat nextHB$1, UniqueAddress to) {
        BoxedUnit boxedUnit;
        if ($this.failureDetector().isMonitoring((Object)to.address())) {
            if ($this.verboseHeartbeat()) {
                $this.clusterLogger().logDebug("Heartbeat to [{}]", to.address());
            }
            boxedUnit = BoxedUnit.UNIT;
        } else {
            if ($this.verboseHeartbeat()) {
                $this.clusterLogger().logDebug("First Heartbeat to [{}]", to.address());
            }
            boxedUnit = $this.cluster().scheduler().scheduleOnce($this.cluster().settings().HeartbeatExpectedResponseAfter(), $this.self(), (Object)new ExpectedFirstHeartbeat(to), (ExecutionContext)$this.context().dispatcher(), $this.self());
        }
        ActorSelection$.MODULE$.toScala($this.heartbeatReceiver(to.address())).$bang((Object)nextHB$1, $this.self());
    }

    public ClusterHeartbeatSender() {
        Actor.$init$((Actor)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.clusterLogger = new Cluster.ClusterLogger(this.cluster(), Logging$.MODULE$.withMarker(this.context().system(), (Object)new ActorWithLogClass((Actor)this, ClusterLogClass$.MODULE$.ClusterHeartbeat()), LogSource$.MODULE$.fromActorWithLoggerClass()));
        this.filterInternalClusterMembers = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterHeartbeatSender.$anonfun$filterInternalClusterMembers$1(this, x$1));
        this.sequenceNr = 0;
        this.failureDetector = this.cluster().failureDetector();
        this.state = new ClusterHeartbeatSenderState(new HeartbeatNodeRing(this.cluster().selfUniqueAddress(), (Set<UniqueAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{this.cluster().selfUniqueAddress()}))), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.cluster().settings().MonitoredByNrOfMembers()), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.failureDetector());
        this.heartbeatTask = this.cluster().scheduler().scheduleWithFixedDelay(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()), this.cluster().settings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp = System.nanoTime() + this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()).toNanos();
        Statics.releaseFence();
    }

    public static final class ExpectedFirstHeartbeat
    implements Product,
    Serializable {
        private final UniqueAddress from;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UniqueAddress from() {
            return this.from;
        }

        public ExpectedFirstHeartbeat copy(UniqueAddress from) {
            return new ExpectedFirstHeartbeat(from);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public String productPrefix() {
            return "ExpectedFirstHeartbeat";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.from();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExpectedFirstHeartbeat;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "from";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExpectedFirstHeartbeat)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)x$1;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = expectedFirstHeartbeat.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public ExpectedFirstHeartbeat(UniqueAddress from) {
            this.from = from;
            Product.$init$((Product)this);
        }
    }

    public static final class Heartbeat
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final Address from;
        private final long sequenceNr;
        private final long creationTimeNanos;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Address from() {
            return this.from;
        }

        public long sequenceNr() {
            return this.sequenceNr;
        }

        public long creationTimeNanos() {
            return this.creationTimeNanos;
        }

        public Heartbeat copy(Address from, long sequenceNr, long creationTimeNanos) {
            return new Heartbeat(from, sequenceNr, creationTimeNanos);
        }

        public Address copy$default$1() {
            return this.from();
        }

        public long copy$default$2() {
            return this.sequenceNr();
        }

        public long copy$default$3() {
            return this.creationTimeNanos();
        }

        public String productPrefix() {
            return "Heartbeat";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.from();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.sequenceNr());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.creationTimeNanos());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Heartbeat;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "from";
                    break;
                }
                case 1: {
                    string = "sequenceNr";
                    break;
                }
                case 2: {
                    string = "creationTimeNanos";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sequenceNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.creationTimeNanos()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Heartbeat)) return false;
            boolean bl = true;
            if (!bl) return false;
            Heartbeat heartbeat = (Heartbeat)x$1;
            if (this.sequenceNr() != heartbeat.sequenceNr()) return false;
            if (this.creationTimeNanos() != heartbeat.creationTimeNanos()) return false;
            Address address = this.from();
            Address address2 = heartbeat.from();
            if (address != null) {
                if (!address.equals(address2)) return false;
                return true;
            }
            if (address2 == null) return true;
            return false;
        }

        public Heartbeat(Address from, long sequenceNr, long creationTimeNanos) {
            this.from = from;
            this.sequenceNr = sequenceNr;
            this.creationTimeNanos = creationTimeNanos;
            Product.$init$((Product)this);
        }
    }

    public static final class HeartbeatRsp
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final UniqueAddress from;
        private final long sequenceNr;
        private final long creationTimeNanos;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UniqueAddress from() {
            return this.from;
        }

        public long sequenceNr() {
            return this.sequenceNr;
        }

        public long creationTimeNanos() {
            return this.creationTimeNanos;
        }

        public HeartbeatRsp copy(UniqueAddress from, long sequenceNr, long creationTimeNanos) {
            return new HeartbeatRsp(from, sequenceNr, creationTimeNanos);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public long copy$default$2() {
            return this.sequenceNr();
        }

        public long copy$default$3() {
            return this.creationTimeNanos();
        }

        public String productPrefix() {
            return "HeartbeatRsp";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.from();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.sequenceNr());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.creationTimeNanos());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof HeartbeatRsp;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "from";
                    break;
                }
                case 1: {
                    string = "sequenceNr";
                    break;
                }
                case 2: {
                    string = "creationTimeNanos";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sequenceNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.creationTimeNanos()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof HeartbeatRsp)) return false;
            boolean bl = true;
            if (!bl) return false;
            HeartbeatRsp heartbeatRsp = (HeartbeatRsp)x$1;
            if (this.sequenceNr() != heartbeatRsp.sequenceNr()) return false;
            if (this.creationTimeNanos() != heartbeatRsp.creationTimeNanos()) return false;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = heartbeatRsp.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public HeartbeatRsp(UniqueAddress from, long sequenceNr, long creationTimeNanos) {
            this.from = from;
            this.sequenceNr = sequenceNr;
            this.creationTimeNanos = creationTimeNanos;
            Product.$init$((Product)this);
        }
    }
}

