/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.crypto;

import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.converter.RsaKeyConverters;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RsaKeyConversionServicePostProcessor
implements BeanFactoryPostProcessor {
    private static final String CONVERSION_SERVICE_BEAN_NAME = "conversionService";
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"resourceLoader cannot be null");
        this.resourceLoader = resourceLoader;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.hasUserDefinedConversionService(beanFactory)) {
            return;
        }
        Converter<String, RSAPrivateKey> pkcs8 = this.pkcs8();
        Converter<String, RSAPublicKey> x509 = this.x509();
        ConversionService service = beanFactory.getConversionService();
        if (service instanceof ConverterRegistry) {
            ConverterRegistry registry2 = (ConverterRegistry)service;
            registry2.addConverter(String.class, RSAPrivateKey.class, pkcs8);
            registry2.addConverter(String.class, RSAPublicKey.class, x509);
        } else {
            beanFactory.addPropertyEditorRegistrar(registry -> {
                registry.registerCustomEditor(RSAPublicKey.class, new ConverterPropertyEditorAdapter(x509));
                registry.registerCustomEditor(RSAPrivateKey.class, new ConverterPropertyEditorAdapter(pkcs8));
            });
        }
    }

    private boolean hasUserDefinedConversionService(ConfigurableListableBeanFactory beanFactory) {
        return beanFactory.containsBean(CONVERSION_SERVICE_BEAN_NAME) && beanFactory.isTypeMatch(CONVERSION_SERVICE_BEAN_NAME, ConversionService.class);
    }

    private Converter<String, RSAPrivateKey> pkcs8() {
        Converter<String, InputStream> pemInputStreamConverter = this.pemInputStreamConverter();
        Converter pkcs8KeyConverter = this.autoclose(RsaKeyConverters.pkcs8());
        return this.pair(pemInputStreamConverter, pkcs8KeyConverter);
    }

    private Converter<String, RSAPublicKey> x509() {
        Converter<String, InputStream> pemInputStreamConverter = this.pemInputStreamConverter();
        Converter x509KeyConverter = this.autoclose(RsaKeyConverters.x509());
        return this.pair(pemInputStreamConverter, x509KeyConverter);
    }

    private Converter<String, InputStream> pemInputStreamConverter() {
        return source -> source.startsWith("-----") ? this.toInputStream((String)source) : this.toInputStream(this.resourceLoader.getResource(source));
    }

    private InputStream toInputStream(String raw) {
        return new ByteArrayInputStream(raw.getBytes(StandardCharsets.UTF_8));
    }

    private InputStream toInputStream(Resource resource) {
        try {
            return resource.getInputStream();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private <T> Converter<InputStream, T> autoclose(Converter<InputStream, T> inputStreamKeyConverter) {
        return inputStream -> {
            try (InputStream is = inputStream;){
                Object object = inputStreamKeyConverter.convert((Object)is);
                return object;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        };
    }

    private <S, T, I> Converter<S, T> pair(Converter<S, I> one, Converter<I, T> two) {
        return source -> {
            Object intermediary = one.convert(source);
            return two.convert(intermediary);
        };
    }

    private static class ConverterPropertyEditorAdapter<T>
    extends PropertyEditorSupport {
        private final Converter<String, T> converter;

        ConverterPropertyEditorAdapter(Converter<String, T> converter) {
            this.converter = converter;
        }

        @Override
        public String getAsText() {
            return null;
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (StringUtils.hasText((String)text)) {
                this.setValue(this.converter.convert((Object)text));
            } else {
                this.setValue(null);
            }
        }
    }
}

