/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import org.dbunit.dataset.Column;
import org.dbunit.dataset.ColumnFilterTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.filter.IColumnFilter;
import org.dbunit.dataset.filter.PatternMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultColumnFilter
implements IColumnFilter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultColumnFilter.class);
    private final PatternMatcher _includeMatcher = new PatternMatcher();
    private final PatternMatcher _excludeMatcher = new PatternMatcher();

    public void includeColumn(String columnPattern) {
        logger.debug("includeColumn(columnPattern={}) - start", (Object)columnPattern);
        this._includeMatcher.addPattern(columnPattern);
    }

    public void includeColumns(Column[] columns) {
        logger.debug("includeColumns(columns={}) - start", (Object[])columns);
        int i = 0;
        while (i < columns.length) {
            this._includeMatcher.addPattern(columns[i].getColumnName());
            ++i;
        }
    }

    public void excludeColumn(String columnPattern) {
        logger.debug("excludeColumn(columnPattern={}) - start", (Object)columnPattern);
        this._excludeMatcher.addPattern(columnPattern);
    }

    public void excludeColumns(Column[] columns) {
        logger.debug("excludeColumns(columns={} - start", (Object[])columns);
        int i = 0;
        while (i < columns.length) {
            this._excludeMatcher.addPattern(columns[i].getColumnName());
            ++i;
        }
    }

    public static ITable includedColumnsTable(ITable table, String[] columnNames) throws DataSetException {
        logger.debug("includedColumnsTable(table={}, columnNames={}) - start", (Object)table, (Object)columnNames);
        DefaultColumnFilter columnFilter = new DefaultColumnFilter();
        int i = 0;
        while (i < columnNames.length) {
            String columnName = columnNames[i];
            columnFilter.includeColumn(columnName);
            ++i;
        }
        return new ColumnFilterTable(table, columnFilter);
    }

    public static ITable includedColumnsTable(ITable table, Column[] columns) throws DataSetException {
        logger.debug("includedColumnsTable(table={}, columns={}) - start", (Object)table, (Object)columns);
        DefaultColumnFilter columnFilter = new DefaultColumnFilter();
        columnFilter.includeColumns(columns);
        return new ColumnFilterTable(table, columnFilter);
    }

    public static ITable excludedColumnsTable(ITable table, String[] columnNames) throws DataSetException {
        logger.debug("excludedColumnsTable(table={}, columnNames={}) - start", (Object)table, (Object)columnNames);
        DefaultColumnFilter columnFilter = new DefaultColumnFilter();
        int i = 0;
        while (i < columnNames.length) {
            String columnName = columnNames[i];
            columnFilter.excludeColumn(columnName);
            ++i;
        }
        return new ColumnFilterTable(table, columnFilter);
    }

    public static ITable excludedColumnsTable(ITable table, Column[] columns) throws DataSetException {
        logger.debug("excludedColumnsTable(table={}, columns={}) - start", (Object)table, (Object)columns);
        DefaultColumnFilter columnFilter = new DefaultColumnFilter();
        columnFilter.excludeColumns(columns);
        return new ColumnFilterTable(table, columnFilter);
    }

    @Override
    public boolean accept(String tableName, Column column) {
        logger.debug("accept(tableName={}, column={}) - start", (Object)tableName, (Object)column);
        if (this._includeMatcher.isEmpty() || this._includeMatcher.accept(column.getColumnName())) {
            return !this._excludeMatcher.accept(column.getColumnName());
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("_includeMatcher=").append(this._includeMatcher);
        sb.append(", _excludeMatcher=").append(this._excludeMatcher);
        sb.append("]");
        return sb.toString();
    }
}

