/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessage;

public class SubscribeClusterTopologyUpdatesMessageV2
extends SubscribeClusterTopologyUpdatesMessage {
    private int clientVersion;

    public SubscribeClusterTopologyUpdatesMessageV2(boolean clusterConnection, int clientVersion) {
        super((byte)113, clusterConnection);
        this.clientVersion = clientVersion;
    }

    public SubscribeClusterTopologyUpdatesMessageV2() {
        super((byte)113);
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeInt(this.clientVersion);
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.clientVersion = buffer.readInt();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.clientVersion;
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", clientVersion=" + this.clientVersion);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SubscribeClusterTopologyUpdatesMessageV2)) {
            return false;
        }
        SubscribeClusterTopologyUpdatesMessageV2 other = (SubscribeClusterTopologyUpdatesMessageV2)obj;
        return this.clientVersion == other.clientVersion;
    }
}

