/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import akka.remote.artery.FlightRecorder$;
import akka.remote.artery.FlightRecorderReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.SetOps;
import scala.collection.SortedSet;
import scala.collection.SortedSet$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FlightRecorderReader$ {
    public static final FlightRecorderReader$ MODULE$ = new FlightRecorderReader$();
    private static final FlightRecorderReader.SectionParameters AlertSectionParameters = new FlightRecorderReader.SectionParameters(FlightRecorder$.MODULE$.AlertSectionOffset(), FlightRecorder$.MODULE$.AlertSectionSize(), FlightRecorder$.MODULE$.AlertLogSize(), FlightRecorder$.MODULE$.AlertWindow(), FlightRecorder$.MODULE$.AlertRecordSize(), 1L);
    private static final FlightRecorderReader.SectionParameters LoFreqSectionParameters = new FlightRecorderReader.SectionParameters(FlightRecorder$.MODULE$.LoFreqSectionOffset(), FlightRecorder$.MODULE$.LoFreqSectionSize(), FlightRecorder$.MODULE$.LoFreqLogSize(), FlightRecorder$.MODULE$.LoFreqWindow(), FlightRecorder$.MODULE$.LoFreqRecordSize(), 1L);
    private static final FlightRecorderReader.SectionParameters HiFreqSectionParameters = new FlightRecorderReader.SectionParameters(FlightRecorder$.MODULE$.HiFreqSectionOffset(), FlightRecorder$.MODULE$.HiFreqSectionSize(), FlightRecorder$.MODULE$.HiFreqLogSize(), FlightRecorder$.MODULE$.HiFreqWindow(), FlightRecorder$.MODULE$.HiFreqRecordSize(), FlightRecorder$.MODULE$.HiFreqBatchSize());

    public FlightRecorderReader.SectionParameters AlertSectionParameters() {
        return AlertSectionParameters;
    }

    public FlightRecorderReader.SectionParameters LoFreqSectionParameters() {
        return LoFreqSectionParameters;
    }

    public FlightRecorderReader.SectionParameters HiFreqSectionParameters() {
        return HiFreqSectionParameters;
    }

    public void dumpToStdout(Path flightRecorderFile) {
        RandomAccessFile raFile = null;
        AbstractInterruptibleChannel channel = null;
        FlightRecorderReader reader = null;
        try {
            raFile = new RandomAccessFile(flightRecorderFile.toFile(), "rw");
            channel = raFile.getChannel();
            reader = new FlightRecorderReader((FileChannel)channel);
            Seq alerts = (Seq)reader.structure().alertLog().logs().flatMap((Function1 & Serializable)x$1 -> x$1.richEntries());
            Seq hiFreq = (Seq)reader.structure().hiFreqLog().logs().flatMap((Function1 & Serializable)x$2 -> x$2.compactEntries());
            Seq loFreq = (Seq)reader.structure().loFreqLog().logs().flatMap((Function1 & Serializable)x$3 -> x$3.richEntries());
            Ordering ordering = package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)FlightRecorderReader$.$anonfun$dumpToStdout$4(a, b)));
            SortedSet sorted = (SortedSet)((SetOps)SortedSet$.MODULE$.apply(alerts, (Object)ordering)).$plus$plus((IterableOnce)hiFreq).$plus$plus((IterableOnce)loFreq);
            Predef$.MODULE$.println((Object)"--- FLIGHT RECORDER LOG");
            sorted.foreach((Function1 & Serializable)x -> {
                Predef$.MODULE$.println(x);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (channel != null) {
                channel.close();
            }
            if (raFile != null) {
                raFile.close();
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$dumpToStdout$4(FlightRecorderReader.Entry a, FlightRecorderReader.Entry b) {
        return a.timeStamp().isBefore(b.timeStamp());
    }

    private FlightRecorderReader$() {
    }
}

