/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.DeadLetterSuppression;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterHeartbeatReceiver$;
import akka.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import akka.cluster.ClusterHeartbeatSenderState;
import akka.cluster.ClusterMessage;
import akka.cluster.HeartbeatNodeRing;
import akka.cluster.Member;
import akka.cluster.UniqueAddress;
import akka.event.LoggingAdapter;
import akka.remote.FailureDetectorRegistry;
import akka.remote.HeartbeatMessage;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u0005xACA\u0002\u0003\u000bA\t!!\u0002\u0002\u000e\u0019Q\u0011\u0011CA\u0003\u0011\u0003\t)!a\u0005\t\u000f\u0005\u0005\u0012\u0001\"\u0001\u0002&\u00191\u0011qE\u0001C\u0003SA!\"a\u001a\u0004\u0005+\u0007I\u0011AA5\u0011)\t\th\u0001B\tB\u0003%\u00111\u000e\u0005\u000b\u0003g\u001a!Q3A\u0005\u0002\u0005U\u0004BCA?\u0007\tE\t\u0015!\u0003\u0002x!Q\u0011qP\u0002\u0003\u0016\u0004%\t!!\u001e\t\u0015\u0005\u00055A!E!\u0002\u0013\t9\bC\u0004\u0002\"\r!\t!a!\t\u0013\u0005=5!!A\u0005\u0002\u0005E\u0005\"CAM\u0007E\u0005I\u0011AAN\u0011%\t\tlAI\u0001\n\u0003\t\u0019\fC\u0005\u00028\u000e\t\n\u0011\"\u0001\u00024\"I\u0011\u0011X\u0002\u0002\u0002\u0013\u0005\u00131\u0018\u0005\n\u0003\u001b\u001c\u0011\u0011!C\u0001\u0003\u001fD\u0011\"a6\u0004\u0003\u0003%\t!!7\t\u0013\u0005\u00158!!A\u0005B\u0005\u001d\b\"CA{\u0007\u0005\u0005I\u0011AA|\u0011%\u0011\taAA\u0001\n\u0003\u0012\u0019\u0001C\u0005\u0003\b\r\t\t\u0011\"\u0011\u0003\n!I!1B\u0002\u0002\u0002\u0013\u0005#Q\u0002\u0005\n\u0005\u001f\u0019\u0011\u0011!C!\u0005#9\u0011B!\u0006\u0002\u0003\u0003E\tAa\u0006\u0007\u0013\u0005\u001d\u0012!!A\t\u0002\te\u0001bBA\u00113\u0011\u0005!\u0011\u0007\u0005\n\u0005\u0017I\u0012\u0011!C#\u0005\u001bA\u0011Ba\r\u001a\u0003\u0003%\tI!\u000e\t\u0013\tu\u0012$!A\u0005\u0002\n}\u0002\"\u0003B)3\u0005\u0005I\u0011\u0002B*\r\u0019\u0011Y&\u0001\"\u0003^!Q\u0011qM\u0010\u0003\u0016\u0004%\tAa\u0018\t\u0015\u0005EtD!E!\u0002\u0013\u0011\t\u0007\u0003\u0006\u0002t}\u0011)\u001a!C\u0001\u0003kB!\"!  \u0005#\u0005\u000b\u0011BA<\u0011)\tyh\bBK\u0002\u0013\u0005\u0011Q\u000f\u0005\u000b\u0003\u0003{\"\u0011#Q\u0001\n\u0005]\u0004bBA\u0011?\u0011\u0005!q\r\u0005\n\u0003\u001f{\u0012\u0011!C\u0001\u0005cB\u0011\"!' #\u0003%\tA!\u001f\t\u0013\u0005Ev$%A\u0005\u0002\u0005M\u0006\"CA\\?E\u0005I\u0011AAZ\u0011%\tIlHA\u0001\n\u0003\nY\fC\u0005\u0002N~\t\t\u0011\"\u0001\u0002P\"I\u0011q[\u0010\u0002\u0002\u0013\u0005!Q\u0010\u0005\n\u0003K|\u0012\u0011!C!\u0003OD\u0011\"!> \u0003\u0003%\tA!!\t\u0013\t\u0005q$!A\u0005B\t\u0015\u0005\"\u0003B\u0004?\u0005\u0005I\u0011\tB\u0005\u0011%\u0011YaHA\u0001\n\u0003\u0012i\u0001C\u0005\u0003\u0010}\t\t\u0011\"\u0011\u0003\n\u001eI!QR\u0001\u0002\u0002#\u0005!q\u0012\u0004\n\u00057\n\u0011\u0011!E\u0001\u0005#Cq!!\t6\t\u0003\u0011)\nC\u0005\u0003\fU\n\t\u0011\"\u0012\u0003\u000e!I!1G\u001b\u0002\u0002\u0013\u0005%q\u0013\u0005\n\u0005{)\u0014\u0011!CA\u0005?C\u0011B!\u00156\u0003\u0003%IAa\u0015\b\u000f\t\u001d\u0016\u0001#!\u0003*\u001a9!1V\u0001\t\u0002\n5\u0006bBA\u0011y\u0011\u0005!q\u0016\u0005\n\u0003sc\u0014\u0011!C!\u0003wC\u0011\"!4=\u0003\u0003%\t!a4\t\u0013\u0005]G(!A\u0005\u0002\tE\u0006\"CAsy\u0005\u0005I\u0011IAt\u0011%\t)\u0010PA\u0001\n\u0003\u0011)\fC\u0005\u0003\bq\n\t\u0011\"\u0011\u0003\n!I!1\u0002\u001f\u0002\u0002\u0013\u0005#Q\u0002\u0005\n\u0005#b\u0014\u0011!C\u0005\u0005'2aA!/\u0002\u0005\nm\u0006BCA4\r\nU\r\u0011\"\u0001\u0003`!Q\u0011\u0011\u000f$\u0003\u0012\u0003\u0006IA!\u0019\t\u000f\u0005\u0005b\t\"\u0001\u0003>\"I\u0011q\u0012$\u0002\u0002\u0013\u0005!1\u0019\u0005\n\u000333\u0015\u0013!C\u0001\u0005sB\u0011\"!/G\u0003\u0003%\t%a/\t\u0013\u00055g)!A\u0005\u0002\u0005=\u0007\"CAl\r\u0006\u0005I\u0011\u0001Bd\u0011%\t)ORA\u0001\n\u0003\n9\u000fC\u0005\u0002v\u001a\u000b\t\u0011\"\u0001\u0003L\"I!\u0011\u0001$\u0002\u0002\u0013\u0005#q\u001a\u0005\n\u0005\u000f1\u0015\u0011!C!\u0005\u0013A\u0011Ba\u0003G\u0003\u0003%\tE!\u0004\t\u0013\t=a)!A\u0005B\tMw!\u0003Bl\u0003\u0005\u0005\t\u0012\u0001Bm\r%\u0011I,AA\u0001\u0012\u0003\u0011Y\u000eC\u0004\u0002\"Y#\tAa9\t\u0013\t-a+!A\u0005F\t5\u0001\"\u0003B\u001a-\u0006\u0005I\u0011\u0011Bs\u0011%\u0011iDVA\u0001\n\u0003\u0013I\u000fC\u0005\u0003RY\u000b\t\u0011\"\u0003\u0003T\u0019I\u0011\u0011CA\u0003\u0001\u0005\u0015!q\u001e\u0005\b\u0003CaF\u0011\u0001B\u007f\u0011%\t9\u0001\u0018b\u0001\n\u0003\u0019\t\u0001\u0003\u0005\u0004\nq\u0003\u000b\u0011BB\u0002\u0011%\u0019Y\u0001\u0018b\u0001\n\u0003\u0019i\u0001\u0003\u0005\u0004\u0010q\u0003\u000b\u0011BA}\u0011%\u0019\t\u0002\u0018b\u0001\n\u0003\u0019\u0019\u0002\u0003\u0005\u0004\"q\u0003\u000b\u0011BB\u000b\u0011%\t\u0019\b\u0018a\u0001\n\u0003\ty\rC\u0005\u0004$q\u0003\r\u0011\"\u0001\u0004&!A\u0011Q\u0010/!B\u0013\t\t\u000eC\u0004\u00040q#\ta!\r\t\u0013\r]BL1A\u0005\u0002\re\u0002\u0002CB!9\u0002\u0006Iaa\u000f\t\u0013\r\rC\f1A\u0005\u0002\r\u0015\u0003\"CB'9\u0002\u0007I\u0011AB(\u0011!\u0019\u0019\u0006\u0018Q!\n\r\u001d\u0003\"CB+9\n\u0007I\u0011AB,\u0011!\u0019y\u0006\u0018Q\u0001\n\re\u0003\"CB19\u0002\u0007I\u0011BA;\u0011%\u0019\u0019\u0007\u0018a\u0001\n\u0013\u0019)\u0007\u0003\u0005\u0004jq\u0003\u000b\u0015BA<\u0011\u001d\u0019Y\u0007\u0018C!\u0007[Bqaa\u001c]\t\u0003\u001ai\u0007C\u0004\u0004rq#\taa\u001d\t\u000f\r}D\f\"\u0001\u0004\u0002\"91\u0011\u0013/\u0005\u0002\r\u0005\u0005bBBJ9\u0012\u00051\u0011\u0011\u0005\b\u0007+cF\u0011ABL\u0011\u001d\u0019\u0019\f\u0018C\u0001\u0007kCqaa/]\t\u0003\u0019i\fC\u0004\u0004Br#\taa1\t\u000f\r\u001dG\f\"\u0001\u0004J\"91Q\u001a/\u0005\u0002\r5\u0004bBBh9\u0012%1Q\u000e\u0005\b\u0007#dF\u0011ABj\u0011\u001d\u0019Y\u000e\u0018C\u0001\u0007;\fac\u00117vgR,'\u000fS3beR\u0014W-\u0019;TK:$WM\u001d\u0006\u0005\u0003\u000f\tI!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u0005-\u0011\u0001B1lW\u0006\u00042!a\u0004\u0002\u001b\t\t)A\u0001\fDYV\u001cH/\u001a:IK\u0006\u0014HOY3biN+g\u000eZ3s'\r\t\u0011Q\u0003\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0011\u00111D\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003?\tIB\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\u0011\u0011Q\u0002\u0002\n\u0011\u0016\f'\u000f\u001e2fCR\u001cRbAA\u000b\u0003W\t\t$!\u0010\u0002J\u0005=\u0003\u0003BA\b\u0003[IA!a\f\u0002\u0006\tq1\t\\;ti\u0016\u0014X*Z:tC\u001e,\u0007\u0003BA\u001a\u0003si!!!\u000e\u000b\t\u0005]\u0012\u0011B\u0001\u0007e\u0016lw\u000e^3\n\t\u0005m\u0012Q\u0007\u0002\u0011\u0011\u0016\f'\u000f\u001e2fCRlUm]:bO\u0016\u0004B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\nI!A\u0003bGR|'/\u0003\u0003\u0002H\u0005\u0005#!\u0006#fC\u0012dU\r\u001e;feN+\b\u000f\u001d:fgNLwN\u001c\t\u0005\u0003/\tY%\u0003\u0003\u0002N\u0005e!a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003#\n\tG\u0004\u0003\u0002T\u0005uc\u0002BA+\u00037j!!a\u0016\u000b\t\u0005e\u00131E\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005m\u0011\u0002BA0\u00033\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002d\u0005\u0015$\u0001D*fe&\fG.\u001b>bE2,'\u0002BA0\u00033\tAA\u001a:p[V\u0011\u00111\u000e\t\u0005\u0003\u007f\ti'\u0003\u0003\u0002p\u0005\u0005#aB!eIJ,7o]\u0001\u0006MJ|W\u000eI\u0001\u000bg\u0016\fX/\u001a8dK:\u0013XCAA<!\u0011\t9\"!\u001f\n\t\u0005m\u0014\u0011\u0004\u0002\u0005\u0019>tw-A\u0006tKF,XM\\2f\u001dJ\u0004\u0013!E2sK\u0006$\u0018n\u001c8US6,g*\u00198pg\u0006\u00112M]3bi&|g\u000eV5nK:\u000bgn\\:!)!\t))!#\u0002\f\u00065\u0005cAAD\u00075\t\u0011\u0001C\u0004\u0002h)\u0001\r!a\u001b\t\u000f\u0005M$\u00021\u0001\u0002x!9\u0011q\u0010\u0006A\u0002\u0005]\u0014\u0001B2paf$\u0002\"!\"\u0002\u0014\u0006U\u0015q\u0013\u0005\n\u0003OZ\u0001\u0013!a\u0001\u0003WB\u0011\"a\u001d\f!\u0003\u0005\r!a\u001e\t\u0013\u0005}4\u0002%AA\u0002\u0005]\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003;SC!a\u001b\u0002 .\u0012\u0011\u0011\u0015\t\u0005\u0003G\u000bi+\u0004\u0002\u0002&*!\u0011qUAU\u0003%)hn\u00195fG.,GM\u0003\u0003\u0002,\u0006e\u0011AC1o]>$\u0018\r^5p]&!\u0011qVAS\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)L\u000b\u0003\u0002x\u0005}\u0015AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\u0006\u0003BA`\u0003\u0013l!!!1\u000b\t\u0005\r\u0017QY\u0001\u0005Y\u0006twM\u0003\u0002\u0002H\u0006!!.\u0019<b\u0013\u0011\tY-!1\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u000e\u0005\u0003\u0002\u0018\u0005M\u0017\u0002BAk\u00033\u00111!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a7\u0002bB!\u0011qCAo\u0013\u0011\ty.!\u0007\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002dF\t\t\u00111\u0001\u0002R\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!;\u0011\r\u0005-\u0018\u0011_An\u001b\t\tiO\u0003\u0003\u0002p\u0006e\u0011AC2pY2,7\r^5p]&!\u00111_Aw\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e\u0018q \t\u0005\u0003/\tY0\u0003\u0003\u0002~\u0006e!a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003G\u001c\u0012\u0011!a\u0001\u00037\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011Q\u0018B\u0003\u0011%\t\u0019\u000fFA\u0001\u0002\u0004\t\t.\u0001\u0005iCND7i\u001c3f)\t\t\t.\u0001\u0005u_N#(/\u001b8h)\t\ti,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003s\u0014\u0019\u0002C\u0005\u0002d^\t\t\u00111\u0001\u0002\\\u0006I\u0001*Z1si\n,\u0017\r\u001e\t\u0004\u0003\u000fK2#B\r\u0003\u001c\t\u001d\u0002\u0003\u0004B\u000f\u0005G\tY'a\u001e\u0002x\u0005\u0015UB\u0001B\u0010\u0015\u0011\u0011\t#!\u0007\u0002\u000fI,h\u000e^5nK&!!Q\u0005B\u0010\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005S\u0011y#\u0004\u0002\u0003,)!!QFAc\u0003\tIw.\u0003\u0003\u0002d\t-BC\u0001B\f\u0003\u0015\t\u0007\u000f\u001d7z)!\t)Ia\u000e\u0003:\tm\u0002bBA49\u0001\u0007\u00111\u000e\u0005\b\u0003gb\u0002\u0019AA<\u0011\u001d\ty\b\ba\u0001\u0003o\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003B\t5\u0003CBA\f\u0005\u0007\u00129%\u0003\u0003\u0003F\u0005e!AB(qi&|g\u000e\u0005\u0006\u0002\u0018\t%\u00131NA<\u0003oJAAa\u0013\u0002\u001a\t1A+\u001e9mKNB\u0011Ba\u0014\u001e\u0003\u0003\u0005\r!!\"\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003VA!\u0011q\u0018B,\u0013\u0011\u0011I&!1\u0003\r=\u0013'.Z2u\u00051AU-\u0019:uE\u0016\fGOU:q'5y\u0012QCA\u0016\u0003c\ti$!\u0013\u0002PU\u0011!\u0011\r\t\u0005\u0003\u001f\u0011\u0019'\u0003\u0003\u0003f\u0005\u0015!!D+oSF,X-\u00113ee\u0016\u001c8\u000f\u0006\u0005\u0003j\t-$Q\u000eB8!\r\t9i\b\u0005\b\u0003O2\u0003\u0019\u0001B1\u0011\u001d\t\u0019H\na\u0001\u0003oBq!a '\u0001\u0004\t9\b\u0006\u0005\u0003j\tM$Q\u000fB<\u0011%\t9g\nI\u0001\u0002\u0004\u0011\t\u0007C\u0005\u0002t\u001d\u0002\n\u00111\u0001\u0002x!I\u0011qP\u0014\u0011\u0002\u0003\u0007\u0011qO\u000b\u0003\u0005wRCA!\u0019\u0002 R!\u00111\u001cB@\u0011%\t\u0019/LA\u0001\u0002\u0004\t\t\u000e\u0006\u0003\u0002z\n\r\u0005\"CAr_\u0005\u0005\t\u0019AAn)\u0011\tiLa\"\t\u0013\u0005\r\b'!AA\u0002\u0005EG\u0003BA}\u0005\u0017C\u0011\"a94\u0003\u0003\u0005\r!a7\u0002\u0019!+\u0017M\u001d;cK\u0006$(k\u001d9\u0011\u0007\u0005\u001dUgE\u00036\u0005'\u00139\u0003\u0005\u0007\u0003\u001e\t\r\"\u0011MA<\u0003o\u0012I\u0007\u0006\u0002\u0003\u0010RA!\u0011\u000eBM\u00057\u0013i\nC\u0004\u0002ha\u0002\rA!\u0019\t\u000f\u0005M\u0004\b1\u0001\u0002x!9\u0011q\u0010\u001dA\u0002\u0005]D\u0003\u0002BQ\u0005K\u0003b!a\u0006\u0003D\t\r\u0006CCA\f\u0005\u0013\u0012\t'a\u001e\u0002x!I!qJ\u001d\u0002\u0002\u0003\u0007!\u0011N\u0001\u000e\u0011\u0016\f'\u000f\u001e2fCR$\u0016nY6\u0011\u0007\u0005\u001dEHA\u0007IK\u0006\u0014HOY3biRK7m[\n\by\u0005U\u0011\u0011JA()\t\u0011I\u000b\u0006\u0003\u0002\\\nM\u0006\"CAr\u0001\u0006\u0005\t\u0019AAi)\u0011\tIPa.\t\u0013\u0005\r()!AA\u0002\u0005m'AF#ya\u0016\u001cG/\u001a3GSJ\u001cH\u000fS3beR\u0014W-\u0019;\u0014\u000f\u0019\u000b)\"!\u0013\u0002PQ!!q\u0018Ba!\r\t9I\u0012\u0005\b\u0003OJ\u0005\u0019\u0001B1)\u0011\u0011yL!2\t\u0013\u0005\u001d$\n%AA\u0002\t\u0005D\u0003BAn\u0005\u0013D\u0011\"a9O\u0003\u0003\u0005\r!!5\u0015\t\u0005e(Q\u001a\u0005\n\u0003G\u0004\u0016\u0011!a\u0001\u00037$B!!0\u0003R\"I\u00111])\u0002\u0002\u0003\u0007\u0011\u0011\u001b\u000b\u0005\u0003s\u0014)\u000eC\u0005\u0002dR\u000b\t\u00111\u0001\u0002\\\u00061R\t\u001f9fGR,GMR5sgRDU-\u0019:uE\u0016\fG\u000fE\u0002\u0002\bZ\u001bRA\u0016Bo\u0005O\u0001\u0002B!\b\u0003`\n\u0005$qX\u0005\u0005\u0005C\u0014yBA\tBEN$(/Y2u\rVt7\r^5p]F\"\"A!7\u0015\t\t}&q\u001d\u0005\b\u0003OJ\u0006\u0019\u0001B1)\u0011\u0011YO!<\u0011\r\u0005]!1\tB1\u0011%\u0011yEWA\u0001\u0002\u0004\u0011ylE\u0004]\u0003+\u0011\tPa>\u0011\t\u0005}\"1_\u0005\u0005\u0005k\f\tEA\u0003BGR|'\u000f\u0005\u0003\u0002@\te\u0018\u0002\u0002B~\u0003\u0003\u0012A\"Q2u_JdunZ4j]\u001e$\"Aa@\u0011\u0007\u0005=A,\u0006\u0002\u0004\u0004A!\u0011qBB\u0003\u0013\u0011\u00199!!\u0002\u0003\u000f\rcWo\u001d;fe\u0006A1\r\\;ti\u0016\u0014\b%\u0001\twKJ\u0014wn]3IK\u0006\u0014HOY3biV\u0011\u0011\u0011`\u0001\u0012m\u0016\u0014(m\\:f\u0011\u0016\f'\u000f\u001e2fCR\u0004\u0013\u0001\b4jYR,'/\u00138uKJt\u0017\r\\\"mkN$XM]'f[\n,'o]\u000b\u0003\u0007+\u0001\u0002\"a\u0006\u0004\u0018\rm\u0011\u0011`\u0005\u0005\u00073\tIBA\u0005Gk:\u001cG/[8ocA!\u0011qBB\u000f\u0013\u0011\u0019y\"!\u0002\u0003\r5+WNY3s\u0003u1\u0017\u000e\u001c;fe&sG/\u001a:oC2\u001cE.^:uKJlU-\u001c2feN\u0004\u0013AD:fcV,gnY3Oe~#S-\u001d\u000b\u0005\u0007O\u0019i\u0003\u0005\u0003\u0002\u0018\r%\u0012\u0002BB\u0016\u00033\u0011A!\u00168ji\"I\u00111]3\u0002\u0002\u0003\u0007\u0011\u0011[\u0001\u000eg\u0016dg\rS3beR\u0014W-\u0019;\u0015\u0005\rM\u0002cAB\u001b\u00079\u0019\u0011q\u0002\u0001\u0002\u001f\u0019\f\u0017\u000e\\;sK\u0012+G/Z2u_J,\"aa\u000f\u0011\r\u0005M2QHA6\u0013\u0011\u0019y$!\u000e\u0003/\u0019\u000b\u0017\u000e\\;sK\u0012+G/Z2u_J\u0014VmZ5tiJL\u0018\u0001\u00054bS2,(/\u001a#fi\u0016\u001cGo\u001c:!\u0003\u0015\u0019H/\u0019;f+\t\u00199\u0005\u0005\u0003\u0002\u0010\r%\u0013\u0002BB&\u0003\u000b\u00111d\u00117vgR,'\u000fS3beR\u0014W-\u0019;TK:$WM]*uCR,\u0017!C:uCR,w\fJ3r)\u0011\u00199c!\u0015\t\u0013\u0005\r8.!AA\u0002\r\u001d\u0013AB:uCR,\u0007%A\u0007iK\u0006\u0014HOY3biR\u000b7o[\u000b\u0003\u00073\u0002B!a\u0010\u0004\\%!1QLA!\u0005-\u0019\u0015M\\2fY2\f'\r\\3\u0002\u001d!,\u0017M\u001d;cK\u0006$H+Y:lA\u0005iA/[2l)&lWm\u001d;b[B\f\u0011\u0003^5dWRKW.Z:uC6\u0004x\fJ3r)\u0011\u00199ca\u001a\t\u0013\u0005\r\b/!AA\u0002\u0005]\u0014A\u0004;jG.$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\taJ,7\u000b^1siR\u00111qE\u0001\ta>\u001cHo\u0015;pa\u0006\t\u0002.Z1si\n,\u0017\r\u001e*fG\u0016Lg/\u001a:\u0015\t\rU41\u0010\t\u0005\u0003\u007f\u00199(\u0003\u0003\u0004z\u0005\u0005#AD!di>\u00148+\u001a7fGRLwN\u001c\u0005\b\u0007{\"\b\u0019AA6\u0003\u001d\tG\r\u001a:fgN\fqA]3dK&4X-\u0006\u0002\u0004\u0004B!1QQBF\u001d\u0011\tyda\"\n\t\r%\u0015\u0011I\u0001\u0006\u0003\u000e$xN]\u0005\u0005\u0007\u001b\u001byIA\u0004SK\u000e,\u0017N^3\u000b\t\r%\u0015\u0011I\u0001\rS:LG/[1mSjLgnZ\u0001\u0007C\u000e$\u0018N^3\u0002\t%t\u0017\u000e\u001e\u000b\u0005\u0007O\u0019I\nC\u0004\u0004\u001cb\u0004\ra!(\u0002\u0011Mt\u0017\r]:i_R\u0004Baa(\u0004.:!1\u0011UBU\u001d\u0011\u0019\u0019ka*\u000f\t\u0005U3QU\u0005\u0003\u0003\u0017IA!a\u0002\u0002\n%!11VA\u0003\u00031\u0019E.^:uKJ,e/\u001a8u\u0013\u0011\u0019yk!-\u0003'\r+(O]3oi\u000ecWo\u001d;feN#\u0018\r^3\u000b\t\r-\u0016QA\u0001\nC\u0012$W*Z7cKJ$Baa\n\u00048\"91\u0011X=A\u0002\rm\u0011!A7\u0002\u0019I,Wn\u001c<f\u001b\u0016l'-\u001a:\u0015\t\r\u001d2q\u0018\u0005\b\u0007sS\b\u0019AB\u000e\u0003E)hN]3bG\"\f'\r\\3NK6\u0014WM\u001d\u000b\u0005\u0007O\u0019)\rC\u0004\u0004:n\u0004\raa\u0007\u0002\u001fI,\u0017m\u00195bE2,W*Z7cKJ$Baa\n\u0004L\"91\u0011\u0018?A\u0002\rm\u0011!\u00035fCJ$(-Z1u\u0003E\u0019\u0007.Z2l)&\u001c7.\u00138uKJ4\u0018\r\\\u0001\rQ\u0016\f'\u000f\u001e2fCR\u00146\u000f\u001d\u000b\u0005\u0007O\u0019)\u000eC\u0004\u0004X~\u0004\ra!7\u0002\u0011I,7\u000f]8og\u0016\u00042a!\u000e \u0003U!(/[4hKJ4\u0015N]:u\u0011\u0016\f'\u000f\u001e2fCR$Baa\n\u0004`\"A\u0011qMA\u0001\u0001\u0004\u0011\t\u0007")
public class ClusterHeartbeatSender
implements Actor,
ActorLogging {
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private final Function1<Member, Object> filterInternalClusterMembers;
    private int sequenceNr;
    private final FailureDetectorRegistry<Address> failureDetector;
    private ClusterHeartbeatSenderState state;
    private final Cancellable heartbeatTask;
    private long akka$cluster$ClusterHeartbeatSender$$tickTimestamp;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    public Function1<Member, Object> filterInternalClusterMembers() {
        return this.filterInternalClusterMembers;
    }

    public int sequenceNr() {
        return this.sequenceNr;
    }

    public void sequenceNr_$eq(int x$1) {
        this.sequenceNr = x$1;
    }

    public Heartbeat selfHeartbeat() {
        this.sequenceNr_$eq(this.sequenceNr() + 1);
        return new Heartbeat(this.cluster().selfAddress(), this.sequenceNr(), System.nanoTime());
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public ClusterHeartbeatSenderState state() {
        return this.state;
    }

    public void state_$eq(ClusterHeartbeatSenderState x$1) {
        this.state = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    private long akka$cluster$ClusterHeartbeatSender$$tickTimestamp() {
        return this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp;
    }

    public void akka$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(long x$1) {
        this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp = x$1;
    }

    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.ReachabilityEvent.class}));
    }

    public void postStop() {
        this.state().activeReceivers().foreach((Function1 & Serializable)a -> {
            ClusterHeartbeatSender.$anonfun$postStop$1(this, a);
            return BoxedUnit.UNIT;
        });
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.initializing();
    }

    public PartialFunction<Object, BoxedUnit> initializing() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.init(currentClusterState);
                    this.$outer.context().become(this.$outer.active());
                    object = BoxedUnit.UNIT;
                } else if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.akka$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(System.nanoTime());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ClusterEvent.CurrentClusterState ? true : ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.heartbeat();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof HeartbeatRsp) {
                    HeartbeatRsp heartbeatRsp = (HeartbeatRsp)A1;
                    this.$outer.heartbeatRsp(heartbeatRsp);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.UnreachableMember) {
                    ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)A1;
                    Member m = unreachableMember.member();
                    this.$outer.unreachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.ReachableMember) {
                    ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)A1;
                    Member m = reachableMember.member();
                    this.$outer.reachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ExpectedFirstHeartbeat) {
                    ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)A1;
                    UniqueAddress from = expectedFirstHeartbeat.from();
                    this.$outer.triggerFirstHeartbeat(from);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object) ? true : (object instanceof HeartbeatRsp ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : (object instanceof ClusterEvent.UnreachableMember ? true : (object instanceof ClusterEvent.ReachableMember ? true : object instanceof ExpectedFirstHeartbeat)))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet nodes2 = (SortedSet)snapshot.members().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply(A1)) ? A1.uniqueAddress() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Member x1) {
                Member member = x1;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)member));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        Set unreachable = (Set)snapshot.unreachable().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply(A1)) ? A1.uniqueAddress() : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Member x2) {
                Member member = x2;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)member));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.state_$eq(this.state().init((Set<UniqueAddress>)nodes2, (Set<UniqueAddress>)unreachable));
    }

    public void addMember(Member m) {
        block0: {
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) || this.state().contains(m.uniqueAddress()) || !BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m))) break block0;
            this.state_$eq(this.state().addMember(m.uniqueAddress()));
        }
    }

    public void removeMember(Member m) {
        block2: {
            if (!BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m))) break block2;
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
                this.context().stop(this.self());
            } else {
                this.state_$eq(this.state().removeMember(m.uniqueAddress()));
            }
        }
    }

    public void unreachableMember(Member m) {
        this.state_$eq(this.state().unreachableMember(m.uniqueAddress()));
    }

    public void reachableMember(Member m) {
        this.state_$eq(this.state().reachableMember(m.uniqueAddress()));
    }

    public void heartbeat() {
        Heartbeat nextHB = this.selfHeartbeat();
        this.state().activeReceivers().foreach((Function1 & Serializable)to -> {
            ClusterHeartbeatSender.$anonfun$heartbeat$1(this, nextHB, to);
            return BoxedUnit.UNIT;
        });
        this.checkTickInterval();
    }

    private void checkTickInterval() {
        long now = System.nanoTime();
        if (now - this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp() >= this.cluster().settings().HeartbeatInterval().toNanos() * 2L) {
            this.cluster().ClusterLogger().logWarning("Scheduled sending of heartbeat was delayed. Previous heartbeat was sent [{}] ms ago, expected interval is [{}] ms. This may cause failure detection to mark members as unreachable. The reason can be thread starvation, e.g. by running blocking tasks on the default dispatcher, CPU overload, or GC.", BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(now - this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp())), BoxesRunTime.boxToLong((long)this.cluster().settings().HeartbeatInterval().toMillis()));
        }
        this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(now);
    }

    public void heartbeatRsp(HeartbeatRsp response) {
        if (this.verboseHeartbeat()) {
            this.cluster().ClusterLogger().logDebug("Heartbeat response from [{}]", response.from().address());
        }
        this.state_$eq(this.state().heartbeatRsp(response.from()));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        block1: {
            if (!this.state().activeReceivers().apply((Object)from) || this.failureDetector().isMonitoring((Object)from.address())) break block1;
            if (this.verboseHeartbeat()) {
                this.cluster().ClusterLogger().logDebug("Trigger extra expected heartbeat from [{}]", from.address());
            }
            this.failureDetector().heartbeat((Object)from.address());
        }
    }

    public static final /* synthetic */ boolean $anonfun$filterInternalClusterMembers$1(ClusterHeartbeatSender $this, Member x$1) {
        String string = x$1.dataCenter();
        String string2 = $this.cluster().selfDataCenter();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$postStop$1(ClusterHeartbeatSender $this, UniqueAddress a) {
        $this.failureDetector().remove((Object)a.address());
    }

    public static final /* synthetic */ void $anonfun$heartbeat$1(ClusterHeartbeatSender $this, Heartbeat nextHB$1, UniqueAddress to) {
        BoxedUnit boxedUnit;
        if ($this.failureDetector().isMonitoring((Object)to.address())) {
            if ($this.verboseHeartbeat()) {
                $this.cluster().ClusterLogger().logDebug("Heartbeat to [{}]", to.address());
            }
            boxedUnit = BoxedUnit.UNIT;
        } else {
            if ($this.verboseHeartbeat()) {
                $this.cluster().ClusterLogger().logDebug("First Heartbeat to [{}]", to.address());
            }
            boxedUnit = $this.cluster().scheduler().scheduleOnce($this.cluster().settings().HeartbeatExpectedResponseAfter(), $this.self(), (Object)new ExpectedFirstHeartbeat(to), (ExecutionContext)$this.context().dispatcher(), $this.self());
        }
        ActorSelection$.MODULE$.toScala($this.heartbeatReceiver(to.address())).$bang((Object)nextHB$1, $this.self());
    }

    public ClusterHeartbeatSender() {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.filterInternalClusterMembers = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterHeartbeatSender.$anonfun$filterInternalClusterMembers$1(this, x$1));
        this.sequenceNr = 0;
        this.failureDetector = this.cluster().failureDetector();
        this.state = new ClusterHeartbeatSenderState(new HeartbeatNodeRing(this.cluster().selfUniqueAddress(), (Set<UniqueAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{this.cluster().selfUniqueAddress()}))), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.cluster().settings().MonitoredByNrOfMembers()), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.failureDetector());
        this.heartbeatTask = this.cluster().scheduler().schedule(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()), this.cluster().settings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.akka$cluster$ClusterHeartbeatSender$$tickTimestamp = System.nanoTime() + this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()).toNanos();
        Statics.releaseFence();
    }

    public static final class ExpectedFirstHeartbeat
    implements Product,
    Serializable {
        private final UniqueAddress from;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UniqueAddress from() {
            return this.from;
        }

        public ExpectedFirstHeartbeat copy(UniqueAddress from) {
            return new ExpectedFirstHeartbeat(from);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public String productPrefix() {
            return "ExpectedFirstHeartbeat";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.from();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExpectedFirstHeartbeat;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "from";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExpectedFirstHeartbeat)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)x$1;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = expectedFirstHeartbeat.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public ExpectedFirstHeartbeat(UniqueAddress from) {
            this.from = from;
            Product.$init$((Product)this);
        }
    }

    public static final class Heartbeat
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final Address from;
        private final long sequenceNr;
        private final long creationTimeNanos;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Address from() {
            return this.from;
        }

        public long sequenceNr() {
            return this.sequenceNr;
        }

        public long creationTimeNanos() {
            return this.creationTimeNanos;
        }

        public Heartbeat copy(Address from, long sequenceNr, long creationTimeNanos) {
            return new Heartbeat(from, sequenceNr, creationTimeNanos);
        }

        public Address copy$default$1() {
            return this.from();
        }

        public long copy$default$2() {
            return this.sequenceNr();
        }

        public long copy$default$3() {
            return this.creationTimeNanos();
        }

        public String productPrefix() {
            return "Heartbeat";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.from();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.sequenceNr());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.creationTimeNanos());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Heartbeat;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "from";
                    break;
                }
                case 1: {
                    string = "sequenceNr";
                    break;
                }
                case 2: {
                    string = "creationTimeNanos";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sequenceNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.creationTimeNanos()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Heartbeat)) return false;
            boolean bl = true;
            if (!bl) return false;
            Heartbeat heartbeat = (Heartbeat)x$1;
            if (this.sequenceNr() != heartbeat.sequenceNr()) return false;
            if (this.creationTimeNanos() != heartbeat.creationTimeNanos()) return false;
            Address address = this.from();
            Address address2 = heartbeat.from();
            if (address != null) {
                if (!address.equals(address2)) return false;
                return true;
            }
            if (address2 == null) return true;
            return false;
        }

        public Heartbeat(Address from, long sequenceNr, long creationTimeNanos) {
            this.from = from;
            this.sequenceNr = sequenceNr;
            this.creationTimeNanos = creationTimeNanos;
            Product.$init$((Product)this);
        }
    }

    public static final class HeartbeatRsp
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final UniqueAddress from;
        private final long sequenceNr;
        private final long creationTimeNanos;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UniqueAddress from() {
            return this.from;
        }

        public long sequenceNr() {
            return this.sequenceNr;
        }

        public long creationTimeNanos() {
            return this.creationTimeNanos;
        }

        public HeartbeatRsp copy(UniqueAddress from, long sequenceNr, long creationTimeNanos) {
            return new HeartbeatRsp(from, sequenceNr, creationTimeNanos);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public long copy$default$2() {
            return this.sequenceNr();
        }

        public long copy$default$3() {
            return this.creationTimeNanos();
        }

        public String productPrefix() {
            return "HeartbeatRsp";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.from();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.sequenceNr());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.creationTimeNanos());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof HeartbeatRsp;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "from";
                    break;
                }
                case 1: {
                    string = "sequenceNr";
                    break;
                }
                case 2: {
                    string = "creationTimeNanos";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sequenceNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.creationTimeNanos()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof HeartbeatRsp)) return false;
            boolean bl = true;
            if (!bl) return false;
            HeartbeatRsp heartbeatRsp = (HeartbeatRsp)x$1;
            if (this.sequenceNr() != heartbeatRsp.sequenceNr()) return false;
            if (this.creationTimeNanos() != heartbeatRsp.creationTimeNanos()) return false;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = heartbeatRsp.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public HeartbeatRsp(UniqueAddress from, long sequenceNr, long creationTimeNanos) {
            this.from = from;
            this.sequenceNr = sequenceNr;
            this.creationTimeNanos = creationTimeNanos;
            Product.$init$((Product)this);
        }
    }
}

