/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.t2bus;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.Set;
import nl.javadude.t2bus.AllowConcurrentEvents;
import nl.javadude.t2bus.EventHandler;
import nl.javadude.t2bus.HandlerFindingStrategy;
import nl.javadude.t2bus.Subscribe;
import nl.javadude.t2bus.SynchronizedEventHandler;

class AnnotatedHandlerFinder
implements HandlerFindingStrategy {
    AnnotatedHandlerFinder() {
    }

    @Override
    public Multimap<Class<?>, EventHandler> findAllHandlers(Object listener) {
        HashMultimap methodsInListener = HashMultimap.create();
        Class<?> clazz = listener.getClass();
        Set supers = TypeToken.of(clazz).getTypes().rawTypes();
        block2: for (Method method : clazz.getMethods()) {
            for (Class c : supers) {
                try {
                    Method m = c.getMethod(method.getName(), method.getParameterTypes());
                    if (!m.isAnnotationPresent(Subscribe.class)) continue;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    Preconditions.checkArgument((parameterTypes.length == 1 ? 1 : 0) != 0, (Object)("Method " + method + " has @Subscribe annotation, but requires " + parameterTypes.length + " arguments.  Event handler methods must require a single argument."));
                    Class<?> eventType = parameterTypes[0];
                    EventHandler handler = AnnotatedHandlerFinder.makeHandler(listener, method, m.getAnnotation(Subscribe.class).canVeto());
                    methodsInListener.put(eventType, (Object)handler);
                    continue block2;
                }
                catch (NoSuchMethodException ignored) {
                }
            }
        }
        return methodsInListener;
    }

    private static EventHandler makeHandler(Object listener, Method method, boolean canVeto) {
        EventHandler wrapper = AnnotatedHandlerFinder.methodIsDeclaredThreadSafe(method) ? new EventHandler(listener, method, canVeto) : new SynchronizedEventHandler(listener, method, canVeto);
        return wrapper;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }
}

