/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.ringbuffer;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.ringbuffer.RecordDescriptor;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;

public final class ManyToOneRingBuffer
implements RingBuffer {
    private final int capacity;
    private final int maxMsgLength;
    private final int tailPositionIndex;
    private final int headCachePositionIndex;
    private final int headPositionIndex;
    private final int correlationIdCounterIndex;
    private final int consumerHeartbeatIndex;
    private final AtomicBuffer buffer;

    public ManyToOneRingBuffer(AtomicBuffer buffer) {
        this.buffer = buffer;
        RingBufferDescriptor.checkCapacity(buffer.capacity());
        this.capacity = buffer.capacity() - RingBufferDescriptor.TRAILER_LENGTH;
        buffer.verifyAlignment();
        this.maxMsgLength = this.capacity >> 3;
        this.tailPositionIndex = this.capacity + RingBufferDescriptor.TAIL_POSITION_OFFSET;
        this.headCachePositionIndex = this.capacity + RingBufferDescriptor.HEAD_CACHE_POSITION_OFFSET;
        this.headPositionIndex = this.capacity + RingBufferDescriptor.HEAD_POSITION_OFFSET;
        this.correlationIdCounterIndex = this.capacity + RingBufferDescriptor.CORRELATION_COUNTER_OFFSET;
        this.consumerHeartbeatIndex = this.capacity + RingBufferDescriptor.CONSUMER_HEARTBEAT_OFFSET;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean write(int msgTypeId, DirectBuffer srcBuffer, int offset, int length) {
        RecordDescriptor.checkTypeId(msgTypeId);
        this.checkMsgLength(length);
        AtomicBuffer buffer = this.buffer;
        int recordLength = length + 8;
        int recordIndex = this.claimCapacity(buffer, recordLength);
        if (-2 == recordIndex) {
            return false;
        }
        buffer.putIntOrdered(RecordDescriptor.lengthOffset(recordIndex), -recordLength);
        UnsafeAccess.UNSAFE.storeFence();
        buffer.putInt(RecordDescriptor.typeOffset(recordIndex), msgTypeId);
        buffer.putBytes(RecordDescriptor.encodedMsgOffset(recordIndex), srcBuffer, offset, length);
        buffer.putIntOrdered(RecordDescriptor.lengthOffset(recordIndex), recordLength);
        return true;
    }

    @Override
    public int read(MessageHandler handler) {
        return this.read(handler, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(MessageHandler handler, int messageCountLimit) {
        int bytesRead;
        int messagesRead = 0;
        AtomicBuffer buffer = this.buffer;
        int headPositionIndex = this.headPositionIndex;
        long head = buffer.getLong(headPositionIndex);
        int capacity = this.capacity;
        int headIndex = (int)head & capacity - 1;
        int maxBlockLength = capacity - headIndex;
        try {
            int recordLength;
            for (bytesRead = 0; bytesRead < maxBlockLength && messagesRead < messageCountLimit; bytesRead += BitUtil.align(recordLength, 8)) {
                int recordIndex = headIndex + bytesRead;
                recordLength = buffer.getIntVolatile(RecordDescriptor.lengthOffset(recordIndex));
                if (recordLength > 0) continue;
                break;
            }
        }
        finally {
            if (bytesRead != 0) {
                buffer.setMemory(headIndex, bytesRead, (byte)0);
                buffer.putLongOrdered(headPositionIndex, head + (long)bytesRead);
            }
        }
        return messagesRead;
    }

    @Override
    public int maxMsgLength() {
        return this.maxMsgLength;
    }

    @Override
    public long nextCorrelationId() {
        return this.buffer.getAndAddLong(this.correlationIdCounterIndex, 1L);
    }

    @Override
    public AtomicBuffer buffer() {
        return this.buffer;
    }

    @Override
    public void consumerHeartbeatTime(long time) {
        this.buffer.putLongOrdered(this.consumerHeartbeatIndex, time);
    }

    @Override
    public long consumerHeartbeatTime() {
        return this.buffer.getLongVolatile(this.consumerHeartbeatIndex);
    }

    @Override
    public long producerPosition() {
        return this.buffer.getLongVolatile(this.tailPositionIndex);
    }

    @Override
    public long consumerPosition() {
        return this.buffer.getLongVolatile(this.headPositionIndex);
    }

    @Override
    public int size() {
        long tail;
        long headBefore;
        AtomicBuffer buffer = this.buffer;
        int headPositionIndex = this.headPositionIndex;
        int tailPositionIndex = this.tailPositionIndex;
        long headAfter = buffer.getLongVolatile(headPositionIndex);
        do {
            headBefore = headAfter;
            tail = buffer.getLongVolatile(tailPositionIndex);
        } while ((headAfter = buffer.getLongVolatile(headPositionIndex)) != headBefore);
        return (int)(tail - headAfter);
    }

    @Override
    public boolean unblock() {
        long tailPosition;
        AtomicBuffer buffer = this.buffer;
        long headPosition = buffer.getLongVolatile(this.headPositionIndex);
        if (headPosition == (tailPosition = buffer.getLongVolatile(this.tailPositionIndex))) {
            return false;
        }
        int mask = this.capacity - 1;
        int consumerIndex = (int)(headPosition & (long)mask);
        int producerIndex = (int)(tailPosition & (long)mask);
        boolean unblocked = false;
        int length = buffer.getIntVolatile(consumerIndex);
        if (length < 0) {
            buffer.putInt(RecordDescriptor.typeOffset(consumerIndex), -1);
            buffer.putIntOrdered(RecordDescriptor.lengthOffset(consumerIndex), -length);
            unblocked = true;
        } else if (0 == length) {
            int limit = producerIndex > consumerIndex ? producerIndex : this.capacity;
            int i = consumerIndex + 8;
            do {
                if (0 == (length = buffer.getIntVolatile(i))) continue;
                if (!ManyToOneRingBuffer.scanBackToConfirmStillZeroed(buffer, i, consumerIndex)) break;
                buffer.putInt(RecordDescriptor.typeOffset(consumerIndex), -1);
                buffer.putIntOrdered(RecordDescriptor.lengthOffset(consumerIndex), i - consumerIndex);
                unblocked = true;
                break;
            } while ((i += 8) < limit);
        }
        return unblocked;
    }

    @Override
    public int tryClaim(int msgTypeId, int length) {
        RecordDescriptor.checkTypeId(msgTypeId);
        this.checkMsgLength(length);
        AtomicBuffer buffer = this.buffer;
        int recordLength = length + 8;
        int recordIndex = this.claimCapacity(buffer, recordLength);
        if (-2 == recordIndex) {
            return recordIndex;
        }
        buffer.putIntOrdered(RecordDescriptor.lengthOffset(recordIndex), -recordLength);
        UnsafeAccess.UNSAFE.storeFence();
        buffer.putInt(RecordDescriptor.typeOffset(recordIndex), msgTypeId);
        return RecordDescriptor.encodedMsgOffset(recordIndex);
    }

    @Override
    public void commit(int index) {
        int recordIndex = this.computeRecordIndex(index);
        AtomicBuffer buffer = this.buffer;
        int recordLength = this.verifyClaimedSpaceNotReleased(buffer, recordIndex);
        buffer.putIntOrdered(RecordDescriptor.lengthOffset(recordIndex), -recordLength);
    }

    @Override
    public void abort(int index) {
        int recordIndex = this.computeRecordIndex(index);
        AtomicBuffer buffer = this.buffer;
        int recordLength = this.verifyClaimedSpaceNotReleased(buffer, recordIndex);
        buffer.putInt(RecordDescriptor.typeOffset(recordIndex), -1);
        buffer.putIntOrdered(RecordDescriptor.lengthOffset(recordIndex), -recordLength);
    }

    private static boolean scanBackToConfirmStillZeroed(AtomicBuffer buffer, int from, int limit) {
        boolean allZeros = true;
        for (int i = from - 8; i >= limit; i -= 8) {
            if (0 == buffer.getIntVolatile(i)) continue;
            allZeros = false;
            break;
        }
        return allZeros;
    }

    private void checkMsgLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("invalid message length=" + length);
        }
        if (length > this.maxMsgLength) {
            throw new IllegalArgumentException("encoded message exceeds maxMsgLength of " + this.maxMsgLength + ", length=" + length);
        }
    }

    private int claimCapacity(AtomicBuffer buffer, int recordLength) {
        int tailIndex;
        int padding;
        long tail;
        int requiredCapacity = BitUtil.align(recordLength, 8);
        int capacity = this.capacity;
        int tailPositionIndex = this.tailPositionIndex;
        int headCachePositionIndex = this.headCachePositionIndex;
        int mask = capacity - 1;
        long head = buffer.getLongVolatile(headCachePositionIndex);
        do {
            int availableCapacity;
            if (requiredCapacity > (availableCapacity = capacity - (int)((tail = buffer.getLongVolatile(tailPositionIndex)) - head))) {
                head = buffer.getLongVolatile(this.headPositionIndex);
                if (requiredCapacity > capacity - (int)(tail - head)) {
                    return -2;
                }
                buffer.putLongOrdered(headCachePositionIndex, head);
            }
            padding = 0;
            tailIndex = (int)tail & mask;
            int toBufferEndLength = capacity - tailIndex;
            if (requiredCapacity <= toBufferEndLength) continue;
            int headIndex = (int)head & mask;
            if (requiredCapacity > headIndex) {
                head = buffer.getLongVolatile(this.headPositionIndex);
                headIndex = (int)head & mask;
                if (requiredCapacity > headIndex) {
                    return -2;
                }
                buffer.putLongOrdered(headCachePositionIndex, head);
            }
            padding = toBufferEndLength;
        } while (!buffer.compareAndSetLong(tailPositionIndex, tail, tail + (long)requiredCapacity + (long)padding));
        if (0 != padding) {
            buffer.putIntOrdered(RecordDescriptor.lengthOffset(tailIndex), -padding);
            UnsafeAccess.UNSAFE.storeFence();
            buffer.putInt(RecordDescriptor.typeOffset(tailIndex), -1);
            buffer.putIntOrdered(RecordDescriptor.lengthOffset(tailIndex), padding);
            tailIndex = 0;
        }
        return tailIndex;
    }

    private int computeRecordIndex(int index) {
        int recordIndex = index - 8;
        if (recordIndex < 0 || recordIndex > this.capacity - 8) {
            throw new IllegalArgumentException("invalid message index " + index);
        }
        return recordIndex;
    }

    private int verifyClaimedSpaceNotReleased(AtomicBuffer buffer, int recordIndex) {
        int recordLength = buffer.getInt(RecordDescriptor.lengthOffset(recordIndex));
        if (recordLength < 0) {
            return recordLength;
        }
        throw new IllegalStateException("claimed space previously " + (-1 == buffer.getInt(RecordDescriptor.typeOffset(recordIndex)) ? "aborted" : "committed"));
    }
}

