/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.license.Clock;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseEditionException;
import com.xebialabs.license.LicenseParseException;
import com.xebialabs.license.LicensePeriodExpiredException;
import com.xebialabs.license.LicenseProductException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseType;
import com.xebialabs.license.LicenseVersion3;
import com.xebialabs.license.LicenseVersionException;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.RealClock;
import com.xebialabs.license.UnregisteredLicenseExpiredException;
import com.xebialabs.license.service.BaseLicenseService;
import com.xebialabs.license.service.LicenseCiCounterFactory;
import com.xebialabs.license.service.LicenseService;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLicenseService
extends BaseLicenseService
implements LicenseService {
    protected static final Logger log = LoggerFactory.getLogger(AbstractLicenseService.class);
    protected final Collection<LicenseType> allowedLicenseTypes = EnumSet.of(LicenseType.MARKETPLACE, LicenseType.VERSION_3);
    protected final Clock clock;
    protected final File licenseFile;
    protected final String product;
    protected final Set<String> allowedEditions = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(LicenseVersion3.Edition.Trial.name(), LicenseVersion3.Edition.Enterprise.name(), LicenseVersion3.Edition.Unregistered.name())));
    protected License license;
    protected RepositoryMetadataService repositoryMetadataService;

    public AbstractLicenseService(String licensePath, String product, RepositoryMetadataService repositoryMetadataService) {
        this(licensePath, product, repositoryMetadataService, new RealClock());
    }

    public AbstractLicenseService(String licensePath, String product, RepositoryMetadataService repositoryMetadataService, Clock clock) {
        this.product = product;
        this.licenseFile = new File(licensePath);
        this.repositoryMetadataService = (RepositoryMetadataService)Checks.checkNotNull((Object)repositoryMetadataService, (String)"repositoryMetadataService");
        this.clock = clock;
    }

    public void initialize(LicenseCiCounterFactory ciCounterFactory) {
        super.initialize(ciCounterFactory, this.license);
    }

    protected void logLicenseError(File licenseFile) {
        log.warn("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
        log.warn("*** Place a valid license in {} to continue using the product.", (Object)licenseFile.getAbsolutePath());
    }

    protected void logLicenseVersionError(License license) {
        log.error("*** Your license is type {}, but one of {} is required", (Object)license.getLicenseVersion(), this.allowedLicenseTypes);
        log.error("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
    }

    protected void logLicenseEditionError(License license) {
        log.error("*** Your license has edition {}, but only {} is allowed", (Object)license.getStringValue(LicenseProperty.EDITION), this.allowedEditions);
        log.error("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
    }

    public String getProduct() {
        return this.product;
    }

    public boolean isLicenseExpired() {
        return this.license.isDateExpired(new LocalDate(this.clock.millis()));
    }

    public Period getValidPeriod() {
        LocalDate localDateValue = this.license.getLocalDateValue(LicenseProperty.EXPIRES_AFTER);
        LocalDate now = new LocalDate(this.clock.millis());
        if (localDateValue == null) {
            return Period.years((int)1000);
        }
        if (now.isAfter((ReadablePartial)localDateValue)) {
            return Period.ZERO;
        }
        return new Period((ReadablePartial)now, (ReadablePartial)localDateValue, PeriodType.days());
    }

    @Override
    public void validate() throws LicenseViolationException {
        this.validateLicenseProperties(this.license);
        super.validate();
    }

    @Override
    public void validate(License license) throws LicenseViolationException {
        this.validateLicenseProperties(license);
        super.validate(license);
    }

    public void reload() throws LicenseViolationException, LicenseParseException {
        this.license = this.readLicense(this.licenseFile);
        this.reLoadCiCounter(this.license);
        this.validate();
    }

    public License getLicense() {
        return this.license;
    }

    protected void validateLicenseProperties(License license) throws LicenseViolationException {
        if (license.isDummyLicense()) {
            return;
        }
        String licenseProduct = license.getStringValue(LicenseProperty.PRODUCT);
        if (!this.product.equals(licenseProduct)) {
            throw new LicenseProductException(String.format("license is issued for %s, but used in %s", licenseProduct, this.product));
        }
        if (license.isDateExpired(new LocalDate(this.clock.millis()))) {
            if (LicenseType.VERSION_3 == LicenseType.fromType((String)license.getStringValue(LicenseProperty.LICENSE_VERSION)) && license.getStringValue(LicenseProperty.EDITION).equals(LicenseVersion3.Edition.Unregistered.name())) {
                throw new UnregisteredLicenseExpiredException("the unregistered version of the license has expired");
            }
            throw new LicensePeriodExpiredException("the license has expired");
        }
        if (!this.isAllowedLicenseType(license)) {
            throw new LicenseVersionException(String.format("for this version of %s, only license types {} are allowed", license.getStringValue(LicenseProperty.PRODUCT), this.allowedLicenseTypes));
        }
        if (!this.isValidEdition(license)) {
            throw new LicenseEditionException(String.format("for this version of %s, the license must be one of %s", license.getStringValue(LicenseProperty.PRODUCT), this.allowedEditions));
        }
        String stringValue = license.getStringValue(LicenseProperty.REPOSITORY_ID);
        if (Strings.isNotEmpty((String)stringValue)) {
            this.repositoryMetadataService.validateAndStoreRepositoryId(stringValue);
        }
    }

    protected boolean isValidEdition(License license) {
        return this.allowedEditions.contains(license.getStringValue(LicenseProperty.EDITION));
    }

    protected boolean isAllowedLicenseType(License license) {
        return this.allowedLicenseTypes.contains(LicenseType.fromType((String)license.getStringValue(LicenseProperty.LICENSE_VERSION)));
    }

    protected abstract License readLicense(File var1) throws LicenseParseException, LicenseViolationException;
}

