/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.ConfigurationException;
import akka.dispatch.ThreadPoolConfig$;
import akka.remote.transport.netty.NettyTransportSettings$Tcp$;
import akka.remote.transport.netty.NettyTransportSettings$Udp$;
import akka.remote.transport.netty.SSLSettings;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0005s!B%K\u0011\u0003\u0019f!B+K\u0011\u00031\u0006\"B/\u0002\t\u0003qfaB0\u0002!\u0003\r\n\u0003Y\u0004\u0007\u00033\n\u0001\u0012\u0011<\u0007\u000b\t\f\u0001\u0012Q2\t\u000bu+A\u0011A;\t\u000b],A\u0011\t=\t\u0013\u0005\rQ!!A\u0005B\u0005\u0015\u0001\"CA\u0004\u000b\u0005\u0005I\u0011AA\u0005\u0011%\t\t\"BA\u0001\n\u0003\t\u0019\u0002C\u0005\u0002 \u0015\t\t\u0011\"\u0011\u0002\"!I\u0011qF\u0003\u0002\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003w)\u0011\u0011!C!\u0003{A\u0011\"a\u0010\u0006\u0003\u0003%I!!\u0011\b\u000f\u0005m\u0013\u0001#!\u0002P\u00199\u0011\u0011J\u0001\t\u0002\u0006-\u0003BB/\u0011\t\u0003\ti\u0005C\u0003x!\u0011\u0005\u0003\u0010C\u0005\u0002\u0004A\t\t\u0011\"\u0011\u0002\u0006!I\u0011q\u0001\t\u0002\u0002\u0013\u0005\u0011\u0011\u0002\u0005\n\u0003#\u0001\u0012\u0011!C\u0001\u0003#B\u0011\"a\b\u0011\u0003\u0003%\t%!\t\t\u0013\u0005=\u0002#!A\u0005\u0002\u0005U\u0003\"CA\u001e!\u0005\u0005I\u0011IA\u001f\u0011%\ty\u0004EA\u0001\n\u0013\t\tEB\u0003V\u0015\u0002\ti\u0006\u0003\u0006\u0002`i\u0011\t\u0011)A\u0005\u0003CBa!\u0018\u000e\u0005\u0002\u0005M\u0004\"CA=5\t\u0007I\u0011AA>\u0011!\t\tJ\u0007Q\u0001\n\u0005u\u0004\"CAJ5\t\u0007I\u0011AAK\u0011!\t9J\u0007Q\u0001\n\u0005M\u0002\"CAM5\t\u0007I\u0011AAN\u0011!\tYK\u0007Q\u0001\n\u0005u\u0005\"CAW5\t\u0007I\u0011AAX\u0011!\t9L\u0007Q\u0001\n\u0005E\u0006\u0002CA]5\u0001&I!a/\t\u0013\u0005\r'D1A\u0005\u0002\u0005\u0015\u0007\u0002CAl5\u0001\u0006I!a2\t\u0013\u0005e'D1A\u0005\u0002\u0005m\u0007\u0002CAo5\u0001\u0006I!!0\t\u0013\u0005}'D1A\u0005\u0002\u0005m\u0007\u0002CAq5\u0001\u0006I!!0\t\u0013\u0005\r(D1A\u0005\u0002\u0005m\u0007\u0002CAs5\u0001\u0006I!!0\t\u0013\u0005\u001d(D1A\u0005\u0002\u0005m\u0007\u0002CAu5\u0001\u0006I!!0\t\u0013\u0005-(D1A\u0005\u0002\u0005%\u0001\u0002CAw5\u0001\u0006I!a\u0003\t\u0013\u0005=(D1A\u0005\u0002\u0005%\u0001\u0002CAy5\u0001\u0006I!a\u0003\t\u0013\u0005M(D1A\u0005\u0002\u0005U\u0005\u0002CA{5\u0001\u0006I!a\r\t\u0013\u0005](D1A\u0005\u0002\u0005U\u0005\u0002CA}5\u0001\u0006I!a\r\t\u0013\u0005m(D1A\u0005\u0002\u0005U\u0005\u0002CA\u007f5\u0001\u0006I!a\r\t\u0013\u0005}(D1A\u0005\u0002\u0005m\u0005\u0002\u0003B\u00015\u0001\u0006I!!(\t\u0013\t\r!D1A\u0005\u0002\u0005m\u0005\u0002\u0003B\u00035\u0001\u0006I!!(\t\u0013\t\u001d!D1A\u0005\u0002\u0005%\u0001\u0002\u0003B\r5\u0001\u0006I!a\u0003\t\u0013\tm!D1A\u0005\u0002\u0005%\u0001\u0002\u0003B\u00125\u0001\u0006I!a\u0003\t\u0013\t\u0015\"D1A\u0005\u0002\t\u001d\u0002\u0002\u0003B\u00195\u0001\u0006IA!\u000b\t\u0013\tM\"D1A\u0005\u0002\u0005%\u0001\u0002\u0003B\u001b5\u0001\u0006I!a\u0003\t\u0013\t]\"D1A\u0005\u0002\u0005%\u0001\u0002\u0003B\u001d5\u0001\u0006I!a\u0003\t\u000f\tm\"\u0004\"\u0003\u0003>\u00051b*\u001a;usR\u0013\u0018M\\:q_J$8+\u001a;uS:<7O\u0003\u0002L\u0019\u0006)a.\u001a;us*\u0011QJT\u0001\niJ\fgn\u001d9peRT!a\u0014)\u0002\rI,Wn\u001c;f\u0015\u0005\t\u0016\u0001B1lW\u0006\u001c\u0001\u0001\u0005\u0002U\u00035\t!J\u0001\fOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;TKR$\u0018N\\4t'\t\tq\u000b\u0005\u0002Y76\t\u0011LC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016L\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0013A!T8eKN\u00111aV\u0015\u0004\u0007\u0015\u0001\"a\u0001+daN)Qa\u00163gSB\u0011QmA\u0007\u0002\u0003A\u0011\u0001lZ\u0005\u0003Qf\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002ke:\u00111\u000e\u001d\b\u0003Y>l\u0011!\u001c\u0006\u0003]J\u000ba\u0001\u0010:p_Rt\u0014\"\u0001.\n\u0005EL\u0016a\u00029bG.\fw-Z\u0005\u0003gR\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!!]-\u0015\u0003Y\u0004\"!Z\u0003\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\fA\u0001\\1oO*\ta0\u0001\u0003kCZ\f\u0017bAA\u0001w\n11\u000b\u001e:j]\u001e\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0001c\u0001-\u0002\u000e%\u0019\u0011qB-\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u00111\u0004\t\u00041\u0006]\u0011bAA\r3\n\u0019\u0011I\\=\t\u0013\u0005u!\"!AA\u0002\u0005-\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002$A1\u0011QEA\u0016\u0003+i!!a\n\u000b\u0007\u0005%\u0012,\u0001\u0006d_2dWm\u0019;j_:LA!!\f\u0002(\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019$!\u000f\u0011\u0007a\u000b)$C\u0002\u00028e\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\u001e1\t\t\u00111\u0001\u0002\u0016\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\f\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111\t\t\u0004u\u0006\u0015\u0013bAA$w\n1qJ\u00196fGR\u00141!\u00163q'\u0015\u0001r\u000b\u001a4j)\t\ty\u0005\u0005\u0002f!Q!\u0011QCA*\u0011%\ti\"FA\u0001\u0002\u0004\tY\u0001\u0006\u0003\u00024\u0005]\u0003\"CA\u000f/\u0005\u0005\t\u0019AA\u000b\u0003\r!6\r]\u0001\u0004+\u0012\u00048C\u0001\u000eX\u0003\u0019\u0019wN\u001c4jOB!\u00111MA8\u001b\t\t)G\u0003\u0003\u0002`\u0005\u001d$\u0002BA5\u0003W\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003[\n1aY8n\u0013\u0011\t\t(!\u001a\u0003\r\r{gNZ5h)\u0011\t)(a\u001e\u0011\u0005QS\u0002bBA09\u0001\u0007\u0011\u0011M\u0001\u000e)J\fgn\u001d9peRlu\u000eZ3\u0016\u0005\u0005u\u0004cAA@\u00079\u0019\u0011\u0011\u0011\u0001\u000f\t\u0005\r\u0015q\u0012\b\u0005\u0003\u000b\u000biI\u0004\u0003\u0002\b\u0006-eb\u00017\u0002\n&\t\u0011+\u0003\u0002P!&\u0011QJT\u0005\u0003\u00172\u000ba\u0002\u0016:b]N\u0004xN\u001d;N_\u0012,\u0007%A\u0005F]\u0006\u0014G.Z*tYV\u0011\u00111G\u0001\u000b\u000b:\f'\r\\3Tg2\u0004\u0013AG*T\u0019\u0016sw-\u001b8f!J|g/\u001b3fe\u000ec\u0017m]:OC6,WCAAO!\u0011\ty*a*\u000f\t\u0005\u0005\u00161\u0015\t\u0003YfK1!!*Z\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011AAU\u0015\r\t)+W\u0001\u001c'NcUI\\4j]\u0016\u0004&o\u001c<jI\u0016\u00148\t\\1tg:\u000bW.\u001a\u0011\u0002%U\u001bX\rR5ta\u0006$8\r[3s\r>\u0014\u0018j\\\u000b\u0003\u0003c\u0003R\u0001WAZ\u0003;K1!!.Z\u0005\u0019y\u0005\u000f^5p]\u0006\u0019Rk]3ESN\u0004\u0018\r^2iKJ4uN]%pA\u0005Qq\u000e\u001d;j_:\u001c\u0016N_3\u0015\t\u0005u\u0016q\u0018\t\u00061\u0006M\u00161\u0002\u0005\b\u0003\u0003,\u0003\u0019AAO\u0003\u0005\u0019\u0018!E\"p]:,7\r^5p]RKW.Z8viV\u0011\u0011q\u0019\t\u0005\u0003\u0013\f\u0019.\u0004\u0002\u0002L*!\u0011QZAh\u0003!!WO]1uS>t'bAAi3\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005U\u00171\u001a\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003I\u0019uN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u00021]\u0013\u0018\u000e^3Ck\u001a4WM\u001d%jO\"<\u0016\r^3s\u001b\u0006\u00148.\u0006\u0002\u0002>\u0006IrK]5uK\n+hMZ3s\u0011&<\u0007nV1uKJl\u0015M]6!\u0003]9&/\u001b;f\u0005V4g-\u001a:M_^<\u0016\r^3s\u001b\u0006\u00148.\u0001\rXe&$XMQ;gM\u0016\u0014Hj\\<XCR,'/T1sW\u0002\nabU3oI\n+hMZ3s'&TX-A\bTK:$')\u001e4gKJ\u001c\u0016N_3!\u0003E\u0011VmY3jm\u0016\u0014UO\u001a4feNK'0Z\u0001\u0013%\u0016\u001cW-\u001b<f\u0005V4g-\u001a:TSj,\u0007%\u0001\u0007NCb4%/Y7f'&TX-A\u0007NCb4%/Y7f'&TX\rI\u0001\b\u0005\u0006\u001c7\u000e\\8h\u0003!\u0011\u0015mY6m_\u001e\u0004\u0013A\u0003+da:{G-\u001a7bs\u0006YAk\u00199O_\u0012,G.Y=!\u00031!6\r]&fKB\fG.\u001b<f\u00035!6\r]&fKB\fG.\u001b<fA\u0005aAk\u00199SKV\u001cX-\u00113ee\u0006iAk\u00199SKV\u001cX-\u00113ee\u0002\n\u0001\u0002S8ti:\fW.Z\u0001\n\u0011>\u001cHO\\1nK\u0002\nABQ5oI\"{7\u000f\u001e8b[\u0016\fQBQ5oI\"{7\u000f\u001e8b[\u0016\u0004\u0013\u0001\u0004)peR\u001cV\r\\3di>\u0014\bf\u0002 \u0003\f\tE!Q\u0003\t\u00041\n5\u0011b\u0001B\b3\nQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\tM\u0011aM,B%:Kej\u0012\u001e!)\"L7\u000fI:i_VdG\rI8oYf\u0004#-\u001a\u0011vg\u0016$\u0007EY=!aJ|g-Z:tS>t\u0017\r\\:/C\t\u00119\"A\u00023]A\nQ\u0002U8siN+G.Z2u_J\u0004\u0013\u0001\u0005\"j]\u0012\u0004vN\u001d;TK2,7\r^8sQ\u001d\u0001%1\u0002B\t\u0005?\t#A!\t\u0002\u0007IrC'A\tCS:$\u0007k\u001c:u'\u0016dWm\u0019;pe\u0002\n1bU:m'\u0016$H/\u001b8hgV\u0011!\u0011\u0006\t\u00061\u0006M&1\u0006\t\u0004)\n5\u0012b\u0001B\u0018\u0015\nY1k\u0015'TKR$\u0018N\\4t\u00031\u00196\u000f\\*fiRLgnZ:!\u0003i\u0019VM\u001d<feN{7m[3u/>\u00148.\u001a:Q_>d7+\u001b>f\u0003m\u0019VM\u001d<feN{7m[3u/>\u00148.\u001a:Q_>d7+\u001b>fA\u0005Q2\t\\5f]R\u001cvnY6fi^{'o[3s!>|GnU5{K\u0006Y2\t\\5f]R\u001cvnY6fi^{'o[3s!>|GnU5{K\u0002\n!bY8naV$Xm\u0016)T)\u0011\tYAa\u0010\t\u000f\u0005}\u0003\n1\u0001\u0002b\u0001")
public class NettyTransportSettings {
    private final Config config;
    private final Mode TransportMode;
    private final boolean EnableSsl;
    private final String SSLEngineProviderClassName;
    private final Option<String> UseDispatcherForIo;
    private final FiniteDuration ConnectionTimeout;
    private final Option<Object> WriteBufferHighWaterMark;
    private final Option<Object> WriteBufferLowWaterMark;
    private final Option<Object> SendBufferSize;
    private final Option<Object> ReceiveBufferSize;
    private final int MaxFrameSize;
    private final int Backlog;
    private final boolean TcpNodelay;
    private final boolean TcpKeepalive;
    private final boolean TcpReuseAddr;
    private final String Hostname;
    private final String BindHostname;
    private final int PortSelector;
    private final int BindPortSelector;
    private final Option<SSLSettings> SslSettings;
    private final int ServerSocketWorkerPoolSize;
    private final int ClientSocketWorkerPoolSize;

    public Mode TransportMode() {
        return this.TransportMode;
    }

    public boolean EnableSsl() {
        return this.EnableSsl;
    }

    public String SSLEngineProviderClassName() {
        return this.SSLEngineProviderClassName;
    }

    public Option<String> UseDispatcherForIo() {
        return this.UseDispatcherForIo;
    }

    private Option<Object> optionSize(String s) {
        None$ none$;
        int n = (int)Predef$.MODULE$.Long2long(this.config.getBytes(s));
        switch (n) {
            case 0: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                if (n < 0) {
                    throw new ConfigurationException(new StringBuilder(52).append("Setting '").append(s).append("' must be 0 or positive (and fit in an Int)").toString());
                }
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)n));
                break;
            }
        }
        return none$;
    }

    public FiniteDuration ConnectionTimeout() {
        return this.ConnectionTimeout;
    }

    public Option<Object> WriteBufferHighWaterMark() {
        return this.WriteBufferHighWaterMark;
    }

    public Option<Object> WriteBufferLowWaterMark() {
        return this.WriteBufferLowWaterMark;
    }

    public Option<Object> SendBufferSize() {
        return this.SendBufferSize;
    }

    public Option<Object> ReceiveBufferSize() {
        return this.ReceiveBufferSize;
    }

    public int MaxFrameSize() {
        return this.MaxFrameSize;
    }

    public int Backlog() {
        return this.Backlog;
    }

    public boolean TcpNodelay() {
        return this.TcpNodelay;
    }

    public boolean TcpKeepalive() {
        return this.TcpKeepalive;
    }

    public boolean TcpReuseAddr() {
        return this.TcpReuseAddr;
    }

    public String Hostname() {
        return this.Hostname;
    }

    public String BindHostname() {
        return this.BindHostname;
    }

    public int PortSelector() {
        return this.PortSelector;
    }

    public int BindPortSelector() {
        return this.BindPortSelector;
    }

    public Option<SSLSettings> SslSettings() {
        return this.SslSettings;
    }

    public int ServerSocketWorkerPoolSize() {
        return this.ServerSocketWorkerPoolSize;
    }

    public int ClientSocketWorkerPoolSize() {
        return this.ClientSocketWorkerPoolSize;
    }

    private int computeWPS(Config config) {
        return ThreadPoolConfig$.MODULE$.scaledPoolSize(config.getInt("pool-size-min"), config.getDouble("pool-size-factor"), config.getInt("pool-size-max"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$EnableSsl$1(NettyTransportSettings $this, boolean x$1) {
        if (!x$1) return true;
        Mode mode = $this.TransportMode();
        NettyTransportSettings$Tcp$ nettyTransportSettings$Tcp$ = NettyTransportSettings$Tcp$.MODULE$;
        if (mode != null) {
            if (!mode.equals(nettyTransportSettings$Tcp$)) return false;
            return true;
        }
        if (nettyTransportSettings$Tcp$ == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$ReceiveBufferSize$1(NettyTransportSettings $this, Option s) {
        if (s.isDefined()) return true;
        Mode mode = $this.TransportMode();
        NettyTransportSettings$Udp$ nettyTransportSettings$Udp$ = NettyTransportSettings$Udp$.MODULE$;
        if (mode == null) {
            if (nettyTransportSettings$Udp$ == null) return false;
            return true;
        } else if (mode.equals(nettyTransportSettings$Udp$)) return false;
        return true;
    }

    private static final Nothing$ throwInvalidNettyVersion$1(String nettyVersion$1) {
        throw new IllegalArgumentException(new StringBuilder(109).append("akka-remote with the Netty transport requires Netty version 3.10.6 or ").append(new StringBuilder(87).append("later. Version [").append(nettyVersion$1).append("] is on the class path. Issue https://github.com/netty/netty/pull/4739 ").toString()).append("may cause messages to not be delivered.").toString());
    }

    public NettyTransportSettings(Config config) {
        Product product;
        this.config = config;
        String string = config.getString("transport-protocol");
        if ("tcp".equals(string)) {
            product = NettyTransportSettings$Tcp$.MODULE$;
        } else if ("udp".equals(string)) {
            product = NettyTransportSettings$Udp$.MODULE$;
        } else {
            throw new ConfigurationException(new StringBuilder(21).append("Unknown transport: [").append(string).append("]").toString());
        }
        this.TransportMode = product;
        this.EnableSsl = BoxesRunTime.unboxToBoolean((Object)Helpers.Requiring$.MODULE$.requiring$extension(Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToBoolean((boolean)config.getBoolean("enable-ssl"))), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NettyTransportSettings.$anonfun$EnableSsl$1(this, BoxesRunTime.unboxToBoolean((Object)x$1))), (Function0 & Serializable)() -> new StringBuilder(21).append(this.TransportMode()).append(" does not support SSL").toString()));
        this.SSLEngineProviderClassName = this.EnableSsl() ? config.getString("ssl-engine-provider") : "";
        String string2 = config.getString("use-dispatcher-for-io");
        boolean bl = "".equals(string2) ? true : string2 == null;
        Object object = bl ? None$.MODULE$ : new Some((Object)string2);
        this.UseDispatcherForIo = object;
        this.ConnectionTimeout = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "connection-timeout");
        this.WriteBufferHighWaterMark = this.optionSize("write-buffer-high-water-mark");
        this.WriteBufferLowWaterMark = this.optionSize("write-buffer-low-water-mark");
        this.SendBufferSize = this.optionSize("send-buffer-size");
        this.ReceiveBufferSize = (Option)Helpers.Requiring$.MODULE$.requiring$extension(Helpers$.MODULE$.Requiring(this.optionSize("receive-buffer-size")), (Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)NettyTransportSettings.$anonfun$ReceiveBufferSize$1(this, s)), (Function0 & Serializable)() -> "receive-buffer-size must be specified for UDP");
        this.MaxFrameSize = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension(Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)((int)Predef$.MODULE$.Long2long(config.getBytes("maximum-frame-size"))))), (Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 >= 32000, (Function0 & Serializable)() -> "Setting 'maximum-frame-size' must be at least 32000 bytes"));
        this.Backlog = config.getInt("backlog");
        this.TcpNodelay = config.getBoolean("tcp-nodelay");
        this.TcpKeepalive = config.getBoolean("tcp-keepalive");
        String string3 = config.getString("tcp-reuse-addr");
        boolean bl2 = "off-for-windows".equals(string3) ? !Helpers$.MODULE$.isWindows() : config.getBoolean("tcp-reuse-addr");
        this.TcpReuseAddr = bl2;
        String string4 = config.getString("hostname");
        String string5 = "".equals(string4) ? InetAddress.getLocalHost().getHostAddress() : string4;
        this.Hostname = string5;
        String string6 = config.getString("bind-hostname");
        String string7 = "".equals(string6) ? this.Hostname() : string6;
        this.BindHostname = string7;
        this.PortSelector = config.getInt("port");
        String string8 = config.getString("bind-port");
        int n = "".equals(string8) ? this.PortSelector() : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string8));
        this.BindPortSelector = n;
        this.SslSettings = this.EnableSsl() ? new Some((Object)new SSLSettings(config.getConfig("security"))) : None$.MODULE$;
        this.ServerSocketWorkerPoolSize = this.computeWPS(config.getConfig("server-socket-worker-pool"));
        this.ClientSocketWorkerPoolSize = this.computeWPS(config.getConfig("client-socket-worker-pool"));
        String nettyVersion = "3.10.6.Final-5f56a03";
        try {
            String[] segments = nettyVersion.split("[.-]");
            if (segments.length < 3 || StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segments[0])) != 3 || StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segments[1])) != 10 || StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segments[2])) < 6) {
                throw NettyTransportSettings.throwInvalidNettyVersion$1(nettyVersion);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw NettyTransportSettings.throwInvalidNettyVersion$1(nettyVersion);
        }
    }

    public static interface Mode {
    }
}

