/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.ssh.SshScpFile;
import com.xebialabs.overthere.util.OverthereUtils;

class SshScpConnection
extends SshConnection {
    protected String deleteDirectoryCommand;
    protected String deleteFileCommand;
    protected String deleteRecursivelyCommand;
    protected String getFileInfoCommand;
    protected String listFilesCommand;
    protected String mkdirCommand;
    protected String mkdirsCommand;
    protected String renameToCommand;
    protected String setExecutableCommand;
    protected String setNotExecutableCommand;

    public SshScpConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper);
        OverthereUtils.checkArgument(this.os != OperatingSystemFamily.WINDOWS, "Cannot create a %s connection to a host that is running Windows", this.protocolAndConnectionType);
        OverthereUtils.checkArgument(this.os != OperatingSystemFamily.ZOS, "Cannot create a %s connection to a host that is running z/OS", this.protocolAndConnectionType);
        this.deleteDirectoryCommand = options.get("deleteDirectoryCommand", "rmdir {0}");
        this.deleteFileCommand = options.get("deleteFileCommand", "rm -f {0}");
        this.deleteRecursivelyCommand = options.get("deleteRecursivelyCommand", "rm -rf {0}");
        this.getFileInfoCommand = options.get("getFileInfoCommand", "ls -ld {0}");
        this.listFilesCommand = options.get("listFilesCommand", "ls -a1 {0}");
        this.mkdirCommand = options.get("mkdirCommand", "mkdir {0}");
        this.mkdirsCommand = options.get("mkdirsCommand", "mkdir -p {0}");
        this.renameToCommand = options.get("renameToCommand", "mv {0} {1}");
        this.setExecutableCommand = options.get("setExecutableCommand", "chmod a+x {0}");
        this.setNotExecutableCommand = options.get("setNotExecutableCommand", "chmod a-x {0}");
    }

    @Override
    public OverthereFile getFile(String hostPath) throws RuntimeIOException {
        return new SshScpFile(this, hostPath);
    }
}

