/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.gcp;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.gcp.GcpKeyManager;
import com.xebialabs.overthere.gcp.GcpKeyManagerFactory;
import com.xebialabs.overthere.gcp.GcpSshKey;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.Protocol;
import com.xebialabs.overthere.ssh.GcpSshConnectionConfigurer;
import com.xebialabs.overthere.ssh.SshConnectionBuilder;
import net.schmizz.sshj.userauth.UserAuthException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Protocol(name="gcp_ssh")
public class GcpSshConnectionBuilder
extends SshConnectionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(GcpSshConnectionBuilder.class);
    public static final String GCP_SSH_PROTOCOL = "gcp_ssh";
    public static final String GCP_KEY_MANAGEMENT_TYPE = "gcpKeyManagementType";
    public static final String GCP_CREDENTIALS_TYPE = "gcpCredentialsType";
    public static final String CREDENTIALS_FILE = "credentialsFile";
    public static final String CREDENTIALS_JSON = "credentialsJson";
    public static final String PROJECT_ID = "projectId";
    public static final String ZONE_NAME = "zoneName";
    public static final String INSTANCE_ID = "instanceId";
    public static final String APPLICATION_NAME = "applicationName";
    public static final String CLIENT_ID = "clientId";
    public static final String CLIENT_EMAIL = "clientEmail";
    public static final String PRIVATE_KEY_PKCS8 = "privateKeyPkcs8";
    public static final String PRIVATE_KEY_ID = "privateKeyId";
    public static final String SCOPES = "scopes";
    public static final String TOKEN_SERVER_URI = "tokenServerUri";
    public static final String SERVICE_ACCOUNT_USER = "serviceAccountUser";
    public static final String KEY_SIZE = "keySize";
    public static final String KEY_EXPIRY_TIME_MILLIS = "keyExpiryTimeMillis";
    public static final String RETRY_COUNT = "retryCount";
    public static final String RETRY_PERIOD_MILLIS = "retryPeriodMillis";
    private final long keyExpiryTimeMillis;
    private final int keySize;
    private final int retryCount;
    private final int retryPeriodMillis;
    private GcpKeyManager gcpKeyManager;

    public GcpSshConnectionBuilder(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, GcpSshConnectionBuilder.additionalConnectionOptions(options), mapper);
        this.gcpKeyManager = GcpKeyManagerFactory.create(options);
        this.keyExpiryTimeMillis = options.getInteger(KEY_EXPIRY_TIME_MILLIS, 300000);
        this.keySize = options.getInteger(KEY_SIZE, 1024);
        this.retryCount = options.getInteger(RETRY_COUNT, 10);
        this.retryPeriodMillis = options.getInteger(RETRY_PERIOD_MILLIS, 1000);
    }

    @Override
    public OverthereConnection connect() {
        GcpSshKey gcpSshKey = this.gcpKeyManager.refreshKey(this.keyExpiryTimeMillis, this.keySize);
        this.connection = new GcpSshConnectionConfigurer(this.connection).configureSshConnection(gcpSshKey.getPrivateKey(), gcpSshKey.getUsername());
        int currentRetryCount = 1;
        while (currentRetryCount < this.retryCount) {
            try {
                return this.tryToConnect();
            }
            catch (RuntimeIOException e) {
                if (e.getCause() != null && e.getCause() instanceof UserAuthException) {
                    try {
                        Thread.sleep(this.retryPeriodMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        throw e;
                    }
                    logger.debug("Connection retry #{} for username {}", (Object)(++currentRetryCount), (Object)gcpSshKey.getUsername());
                    continue;
                }
                throw e;
            }
        }
        return this.tryToConnect();
    }

    void setGcpKeyManager(GcpKeyManager gcpKeyManager) {
        this.gcpKeyManager = gcpKeyManager;
    }

    public long getKeyExpiryTimeMillis() {
        return this.keyExpiryTimeMillis;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getRetryPeriodMillis() {
        return this.retryPeriodMillis;
    }

    protected OverthereConnection tryToConnect() {
        return super.connect();
    }

    private static ConnectionOptions additionalConnectionOptions(ConnectionOptions options) {
        if (!options.containsKey("username")) {
            options.set("username", "username");
        }
        return options;
    }
}

