/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterHeartbeatReceiver$;
import akka.cluster.ClusterHeartbeatSender;
import akka.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import akka.cluster.ClusterSettings;
import akka.cluster.CrossDcHeartbeatingState;
import akka.cluster.CrossDcHeartbeatingState$;
import akka.cluster.Member;
import akka.cluster.Member$;
import akka.cluster.UniqueAddress;
import akka.event.LoggingAdapter;
import akka.remote.FailureDetectorRegistry;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u001de!B5k\u0001)t\u0007B\u0002@\u0001\t\u0003\t\t\u0001\u0003\u0005l\u0001\t\u0007I\u0011AA\u0004\u0011!\ty\u0001\u0001Q\u0001\n\u0005%\u0001\"CA\t\u0001\t\u0007I\u0011AA\n\u0011!\tY\u0002\u0001Q\u0001\n\u0005U\u0001\"CA\u000f\u0001\u0001\u0007I\u0011AA\n\u0011%\ty\u0002\u0001a\u0001\n\u0003\t\t\u0003\u0003\u0005\u0002.\u0001\u0001\u000b\u0015BA\u000b\u0011%\ty\u0003\u0001b\u0001\n\u0003\t\t\u0004\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u001a\u0011%\t\t\u0005\u0001b\u0001\n\u0003\t\u0019\u0005\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA#\u0011%\tY\u0006\u0001b\u0001\n\u0003\ti\u0006\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA0\u0011%\t\u0019\b\u0001a\u0001\n\u0003\t)\bC\u0005\u0002~\u0001\u0001\r\u0011\"\u0001\u0002\u0000!A\u00111\u0011\u0001!B\u0013\t9\bC\u0004\u0002\u0006\u0002!\t!a\"\t\u0013\u0005]\u0005\u00011A\u0005\u0002\u0005e\u0005\"CAQ\u0001\u0001\u0007I\u0011AAR\u0011!\t9\u000b\u0001Q!\n\u0005m\u0005\"CAU\u0001\t\u0007I\u0011AAV\u0011!\t\u0019\f\u0001Q\u0001\n\u00055\u0006bBA[\u0001\u0011\u0005\u0013q\u0017\u0005\b\u0003s\u0003A\u0011IA\\\u0011\u001d\tY\f\u0001C\u0001\u0003{Cq!!3\u0001\t\u0003\tY\rC\u0004\u0002\\\u0002!\t!a3\t\u000f\u0005u\u0007\u0001\"\u0001\u0002L\"9\u0011q\u001c\u0001\u0005\u0002\u0005-\u0007bBAq\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011\u001d\u0011i\u0001\u0001C\u0001\u0005\u001fAqAa\u0005\u0001\t\u0003\t9\fC\u0004\u0003\u0016\u0001!\tAa\u0006\t\u000f\t\r\u0002\u0001\"\u0001\u0003&!9!\u0011\u0006\u0001\u0005\n\t-\u0002b\u0002B\u0017\u0001\u0011%\u0011qW\u0004\t\u0005{Q\u0007\u0012\u00017\u0003@\u00199\u0011N\u001bE\u0001Y\n\u0005\u0003B\u0002@)\t\u0003\u0011\u0019EB\u0005\u0003F!\u0002\n1%\t\u0003H\u00191!q\n\u0015C\u0005#BaA`\u0016\u0005\u0002\t-\u0004\"\u0003B9W\u0005\u0005I\u0011\u0001B6\u0011%\u0011\u0019hKA\u0001\n\u0003\u0012)\bC\u0005\u0003\b.\n\t\u0011\"\u0001\u0003\n\"I!\u0011S\u0016\u0002\u0002\u0013\u0005!1\u0013\u0005\n\u0005;[\u0013\u0011!C!\u0005?C\u0011B!,,\u0003\u0003%\tAa,\t\u0013\tM6&!A\u0005B\tU\u0006\"\u0003B]W\u0005\u0005I\u0011\tB^\u0011%\u0011ilKA\u0001\n\u0003\u0012y\fC\u0005\u0003B.\n\t\u0011\"\u0011\u0003D\u001eI!q\u0019\u0015\u0002\u0002#\u0005!\u0011\u001a\u0004\n\u0005\u001fB\u0013\u0011!E\u0001\u0005\u0017DaA \u001d\u0005\u0002\t\r\b\"\u0003B_q\u0005\u0005IQ\tB`\u0011%\u0011)\u000fOA\u0001\n\u0003\u0013Y\u0007C\u0005\u0003hb\n\t\u0011\"!\u0003j\"I!q\u001e\u001d\u0002\u0002\u0013%!\u0011\u001f\u0004\n\u0005sD\u0003\u0013aI\u0011\u0005w4\u0011Ba@)!\u0003\r\nc!\u0001\u0007\r\r\u001d\u0001FQB\u0005\u0011)\u0019i\u0001\u0011BK\u0002\u0013\u0005\u0011\u0011\u0014\u0005\u000b\u0007\u001f\u0001%\u0011#Q\u0001\n\u0005m\u0005B\u0002@A\t\u0003\u0019\t\u0002C\u0005\u0003r\u0001\u000b\t\u0011\"\u0001\u0004\u0018!I11\u0004!\u0012\u0002\u0013\u00051Q\u0004\u0005\n\u0005g\u0002\u0015\u0011!C!\u0005kB\u0011Ba\"A\u0003\u0003%\tA!#\t\u0013\tE\u0005)!A\u0005\u0002\rE\u0002\"\u0003BO\u0001\u0006\u0005I\u0011\tBP\u0011%\u0011i\u000bQA\u0001\n\u0003\u0019)\u0004C\u0005\u00034\u0002\u000b\t\u0011\"\u0011\u0004:!I!\u0011\u0018!\u0002\u0002\u0013\u0005#1\u0018\u0005\n\u0005{\u0003\u0015\u0011!C!\u0005\u007fC\u0011B!1A\u0003\u0003%\te!\u0010\b\u0013\re\u0003&!A\t\u0002\rmc!CB\u0004Q\u0005\u0005\t\u0012AB/\u0011\u0019q\b\u000b\"\u0001\u0004f!I!Q\u0018)\u0002\u0002\u0013\u0015#q\u0018\u0005\n\u0005K\u0004\u0016\u0011!CA\u0007OB\u0011Ba:Q\u0003\u0003%\tia\u001b\t\u0013\t=\b+!A\u0005\n\tEhABB!Q\t\u001b\u0019\u0005\u0003\u0004\u007f-\u0012\u00051Q\t\u0005\n\u0005c2\u0016\u0011!C\u0001\u0007\u000bB\u0011Ba\u001dW\u0003\u0003%\tE!\u001e\t\u0013\t\u001de+!A\u0005\u0002\t%\u0005\"\u0003BI-\u0006\u0005I\u0011AB%\u0011%\u0011iJVA\u0001\n\u0003\u0012y\nC\u0005\u0003.Z\u000b\t\u0011\"\u0001\u0004N!I!1\u0017,\u0002\u0002\u0013\u00053\u0011\u000b\u0005\n\u0005s3\u0016\u0011!C!\u0005wC\u0011B!0W\u0003\u0003%\tEa0\t\u0013\t\u0005g+!A\u0005B\rUs!CB;Q\u0005\u0005\t\u0012AB<\r%\u0019\t\u0005KA\u0001\u0012\u0003\u0019I\b\u0003\u0004\u007fG\u0012\u00051Q\u0010\u0005\n\u0005{\u001b\u0017\u0011!C#\u0005\u007fC\u0011B!:d\u0003\u0003%\ti!\u0012\t\u0013\t\u001d8-!A\u0005\u0002\u000e}\u0004\"\u0003BxG\u0006\u0005I\u0011\u0002By\u0005Y\u0019%o\\:t\t\u000eDU-\u0019:uE\u0016\fGoU3oI\u0016\u0014(BA6m\u0003\u001d\u0019G.^:uKJT\u0011!\\\u0001\u0005C.\\\u0017m\u0005\u0003\u0001_V\\\bC\u00019t\u001b\u0005\t(\"\u0001:\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\f(AB!osJ+g\r\u0005\u0002ws6\tqO\u0003\u0002yY\u0006)\u0011m\u0019;pe&\u0011!p\u001e\u0002\u0006\u0003\u000e$xN\u001d\t\u0003mrL!!`<\u0003\u0019\u0005\u001bGo\u001c:M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\"!a\u0001\u0011\u0007\u0005\u0015\u0001!D\u0001k+\t\tI\u0001\u0005\u0003\u0002\u0006\u0005-\u0011bAA\u0007U\n91\t\\;ti\u0016\u0014\u0018\u0001C2mkN$XM\u001d\u0011\u0002!Y,'OY8tK\"+\u0017M\u001d;cK\u0006$XCAA\u000b!\r\u0001\u0018qC\u0005\u0004\u00033\t(a\u0002\"p_2,\u0017M\\\u0001\u0012m\u0016\u0014(m\\:f\u0011\u0016\f'\u000f\u001e2fCR\u0004\u0013AE1di&4X\r\\=N_:LGo\u001c:j]\u001e\fa#Y2uSZ,G._'p]&$xN]5oO~#S-\u001d\u000b\u0005\u0003G\tI\u0003E\u0002q\u0003KI1!a\nr\u0005\u0011)f.\u001b;\t\u0013\u0005-r!!AA\u0002\u0005U\u0011a\u0001=%c\u0005\u0019\u0012m\u0019;jm\u0016d\u00170T8oSR|'/\u001b8hA\u00059\u0012n]#yi\u0016\u0014h.\u00197DYV\u001cH/\u001a:NK6\u0014WM]\u000b\u0003\u0003g\u0001r\u0001]A\u001b\u0003s\t)\"C\u0002\u00028E\u0014\u0011BR;oGRLwN\\\u0019\u0011\t\u0005\u0015\u00111H\u0005\u0004\u0003{Q'AB'f[\n,'/\u0001\rjg\u0016CH/\u001a:oC2\u001cE.^:uKJlU-\u001c2fe\u0002\nqb\u0019:pgN$5mU3ui&twm]\u000b\u0003\u0003\u000b\u0002B!a\u0012\u0002R9!\u0011\u0011JA'\u001d\r\tYEA\u0007\u0002\u0001%!\u0011qJA\u0006\u0003!\u0019X\r\u001e;j]\u001e\u001c\u0018\u0002BA*\u0003+\u0012ad\u0011:pgN$5MR1jYV\u0014X\rR3uK\u000e$xN]*fiRLgnZ:\n\u0007\u0005]#NA\bDYV\u001cH/\u001a:TKR$\u0018N\\4t\u0003A\u0019'o\\:t\t\u000e\u001cV\r\u001e;j]\u001e\u001c\b%\u0001\fde>\u001c8\u000fR2GC&dWO]3EKR,7\r^8s+\t\ty\u0006\u0005\u0004\u0002b\u0005\u001d\u00141N\u0007\u0003\u0003GR1!!\u001am\u0003\u0019\u0011X-\\8uK&!\u0011\u0011NA2\u0005]1\u0015-\u001b7ve\u0016$U\r^3di>\u0014(+Z4jgR\u0014\u0018\u0010E\u0002w\u0003[J1!a\u001cx\u0005\u001d\tE\r\u001a:fgN\fqc\u0019:pgN$5MR1jYV\u0014X\rR3uK\u000e$xN\u001d\u0011\u0002\u0015M,\u0017/^3oG\u0016t%/\u0006\u0002\u0002xA\u0019\u0001/!\u001f\n\u0007\u0005m\u0014O\u0001\u0003M_:<\u0017AD:fcV,gnY3Oe~#S-\u001d\u000b\u0005\u0003G\t\t\tC\u0005\u0002,A\t\t\u00111\u0001\u0002x\u0005Y1/Z9vK:\u001cWM\u0014:!\u00035qW\r\u001f;IK\u0006\u0014HOQ3biR\u0011\u0011\u0011\u0012\t\u0005\u0003\u0017\u000b\tJ\u0004\u0003\u0002\u0006\u00055\u0015bAAHU\u000612\t\\;ti\u0016\u0014\b*Z1si\n,\u0017\r^*f]\u0012,'/\u0003\u0003\u0002\u0014\u0006U%!\u0003%fCJ$(-Z1u\u0015\r\tyI[\u0001\u0011I\u0006$\u0018mQ3oi\u0016\u00148o\u0015;bi\u0016,\"!a'\u0011\t\u0005\u0015\u0011QT\u0005\u0004\u0003?S'\u0001G\"s_N\u001cHi\u0019%fCJ$(-Z1uS:<7\u000b^1uK\u0006!B-\u0019;b\u0007\u0016tG/\u001a:t'R\fG/Z0%KF$B!a\t\u0002&\"I\u00111\u0006\u000b\u0002\u0002\u0003\u0007\u00111T\u0001\u0012I\u0006$\u0018mQ3oi\u0016\u00148o\u0015;bi\u0016\u0004\u0013!\u00045fCJ$(-Z1u)\u0006\u001c8.\u0006\u0002\u0002.B\u0019a/a,\n\u0007\u0005EvOA\u0006DC:\u001cW\r\u001c7bE2,\u0017A\u00045fCJ$(-Z1u)\u0006\u001c8\u000eI\u0001\taJ,7\u000b^1siR\u0011\u00111E\u0001\ta>\u001cHo\u0015;pa\u0006\t\u0002.Z1si\n,\u0017\r\u001e*fG\u0016Lg/\u001a:\u0015\t\u0005}\u0016Q\u0019\t\u0004m\u0006\u0005\u0017bAAbo\nq\u0011i\u0019;peN+G.Z2uS>t\u0007bBAd5\u0001\u0007\u00111N\u0001\bC\u0012$'/Z:t\u0003\u001d\u0011XmY3jm\u0016,\"!!4\u0011\t\u0005=\u0017Q\u001b\b\u0004m\u0006E\u0017bAAjo\u0006)\u0011i\u0019;pe&!\u0011q[Am\u0005\u001d\u0011VmY3jm\u0016T1!a5x\u0003\u001d!wN]7b]R\fa!Y2uSZ,\u0017!D5oiJ|7\u000f]3di&tw-\u0001\u0003j]&$H\u0003BA\u0012\u0003KDq!a: \u0001\u0004\tI/\u0001\u0005t]\u0006\u00048\u000f[8u!\u0011\tY/a@\u000f\t\u00055\u00181 \b\u0005\u0003_\fIP\u0004\u0003\u0002r\u0006]XBAAz\u0015\r\t)p`\u0001\u0007yI|w\u000e\u001e \n\u00035L!a\u001b7\n\u0007\u0005u(.\u0001\u0007DYV\u001cH/\u001a:Fm\u0016tG/\u0003\u0003\u0003\u0002\t\r!aE\"veJ,g\u000e^\"mkN$XM]*uCR,'bAA\u007fU\u0006I\u0011\r\u001a3NK6\u0014WM\u001d\u000b\u0005\u0003G\u0011I\u0001C\u0004\u0003\f\u0001\u0002\r!!\u000f\u0002\u00035\fAB]3n_Z,W*Z7cKJ$B!a\t\u0003\u0012!9!1B\u0011A\u0002\u0005e\u0012!\u00035fCJ$(-Z1u\u00031AW-\u0019:uE\u0016\fGOU:q)\u0011\t\u0019C!\u0007\t\u000f\tm1\u00051\u0001\u0003\u001e\u0005!aM]8n!\u0011\t)Aa\b\n\u0007\t\u0005\"NA\u0007V]&\fX/Z!eIJ,7o]\u0001\u0016iJLwmZ3s\r&\u00148\u000f\u001e%fCJ$(-Z1u)\u0011\t\u0019Ca\n\t\u000f\tmA\u00051\u0001\u0003\u001e\u0005!3/\u001a7g\u0013N\u0014Vm\u001d9p]NL'\r\\3G_J\u001c%o\\:t\t\u000eDU-\u0019:uE\u0016\fG\u000f\u0006\u0002\u0002\u0016\u0005)#-Z2p[\u0016\f5\r^5wK&3'+Z:q_:\u001c\u0018N\u00197f\r>\u0014\b*Z1si\n,\u0017\r\u001e\u0015\u0004\u0001\tE\u0002\u0003\u0002B\u001a\u0005si!A!\u000e\u000b\u0007\t]B.\u0001\u0006b]:|G/\u0019;j_:LAAa\u000f\u00036\tY\u0011J\u001c;fe:\fG.\u00119j\u0003Y\u0019%o\\:t\t\u000eDU-\u0019:uE\u0016\fGoU3oI\u0016\u0014\bcAA\u0003QM\u0011\u0001f\u001c\u000b\u0003\u0005\u007f\u0011\u0011#\u00138ta\u0016\u001cG/[8o\u0007>lW.\u00198e'\u0011QsN!\u0013\u0011\u0007Y\u0014Y%C\u0002\u0003N]\u0014\u0011ET8TKJL\u0017\r\\5{CRLwN\u001c,fe&4\u0017nY1uS>tg*Z3eK\u0012\u0014ABU3q_J$8\u000b^1ukN\u001cbaK8\u0003T\te\u0003c\u00019\u0003V%\u0019!qK9\u0003\u000fA\u0013x\u000eZ;diB!!1\fB3\u001d\u0011\u0011iF!\u0019\u000f\t\u0005E(qL\u0005\u0002e&\u0019!1M9\u0002\u000fA\f7m[1hK&!!q\rB5\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\u0011\u0019'\u001d\u000b\u0003\u0005[\u00022Aa\u001c,\u001b\u0005A\u0013\u0001B2paf\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B<!\u0011\u0011IHa!\u000e\u0005\tm$\u0002\u0002B?\u0005\u007f\nA\u0001\\1oO*\u0011!\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0006\nm$AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003\fB\u0019\u0001O!$\n\u0007\t=\u0015OA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\u0016\nm\u0005c\u00019\u0003\u0018&\u0019!\u0011T9\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002,A\n\t\u00111\u0001\u0003\f\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\"B1!1\u0015BU\u0005+k!A!*\u000b\u0007\t\u001d\u0016/\u0001\u0006d_2dWm\u0019;j_:LAAa+\u0003&\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)B!-\t\u0013\u0005-\"'!AA\u0002\tU\u0015A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BAa\u001e\u00038\"I\u00111F\u001a\u0002\u0002\u0003\u0007!1R\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!1R\u0001\ti>\u001cFO]5oOR\u0011!qO\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U!Q\u0019\u0005\n\u0003W1\u0014\u0011!a\u0001\u0005+\u000bABU3q_J$8\u000b^1ukN\u00042Aa\u001c9'\u0015A$Q\u001aBm!\u0019\u0011yM!6\u0003n5\u0011!\u0011\u001b\u0006\u0004\u0005'\f\u0018a\u0002:v]RLW.Z\u0005\u0005\u0005/\u0014\tNA\tBEN$(/Y2u\rVt7\r^5p]B\u0002BAa7\u0003b6\u0011!Q\u001c\u0006\u0005\u0005?\u0014y(\u0001\u0002j_&!!q\rBo)\t\u0011I-A\u0003baBd\u00170A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005U!1\u001e\u0005\n\u0005[d\u0014\u0011!a\u0001\u0005[\n1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\u0019\u0010\u0005\u0003\u0003z\tU\u0018\u0002\u0002B|\u0005w\u0012aa\u00142kK\u000e$(\u0001D*uCR,8OU3q_J$8\u0003\u0002 p\u0005\u0013J#AP \u0003+5{g.\u001b;pe&twm\u0015;bi\u0016\u0014V\r]8siN!qh\\B\u0002!\r\u0011yGP\u0015\u0004\u007f\u00013&\u0001E'p]&$xN]5oO\u0006\u001bG/\u001b<f'!\u0001una\u0003\u0003T\te\u0003c\u0001B8\u007f\u0005)1\u000f^1uK\u000611\u000f^1uK\u0002\"Baa\u0005\u0004\u0016A\u0019!q\u000e!\t\u000f\r51\t1\u0001\u0002\u001cR!11CB\r\u0011%\u0019i\u0001\u0012I\u0001\u0002\u0004\tY*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\r}!\u0006BAN\u0007CY#aa\t\u0011\t\r\u00152QF\u0007\u0003\u0007OQAa!\u000b\u0004,\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005o\t\u0018\u0002BB\u0018\u0007O\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)\u0011\u0011)ja\r\t\u0013\u0005-\u0002*!AA\u0002\t-E\u0003BA\u000b\u0007oA\u0011\"a\u000bK\u0003\u0003\u0005\rA!&\u0015\t\t]41\b\u0005\n\u0003WY\u0015\u0011!a\u0001\u0005\u0017#B!!\u0006\u0004@!I\u00111\u0006(\u0002\u0002\u0003\u0007!Q\u0013\u0002\u0012\u001b>t\u0017\u000e^8sS:<Gi\u001c:nC:$8\u0003\u0003,p\u0007\u0017\u0011\u0019F!\u0017\u0015\u0005\r\u001d\u0003c\u0001B8-R!!QSB&\u0011%\tYcWA\u0001\u0002\u0004\u0011Y\t\u0006\u0003\u0002\u0016\r=\u0003\"CA\u0016;\u0006\u0005\t\u0019\u0001BK)\u0011\u00119ha\u0015\t\u0013\u0005-b,!AA\u0002\t-E\u0003BA\u000b\u0007/B\u0011\"a\u000bb\u0003\u0003\u0005\rA!&\u0002!5{g.\u001b;pe&tw-Q2uSZ,\u0007c\u0001B8!N)\u0001ka\u0018\u0003ZBA!qZB1\u00037\u001b\u0019\"\u0003\u0003\u0004d\tE'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u001111\f\u000b\u0005\u0007'\u0019I\u0007C\u0004\u0004\u000eM\u0003\r!a'\u0015\t\r541\u000f\t\u0006a\u000e=\u00141T\u0005\u0004\u0007c\n(AB(qi&|g\u000eC\u0005\u0003nR\u000b\t\u00111\u0001\u0004\u0014\u0005\tRj\u001c8ji>\u0014\u0018N\\4E_Jl\u0017M\u001c;\u0011\u0007\t=4mE\u0003d\u0007w\u0012I\u000e\u0005\u0004\u0003P\nU7q\t\u000b\u0003\u0007o\"B!!\u0006\u0004\u0002\"I!Q^4\u0002\u0002\u0003\u00071q\t\u0015\u0004Q\tE\u0002fA\u0014\u00032\u0001")
@InternalApi
public class CrossDcHeartbeatSender
implements Actor,
ActorLogging {
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private boolean activelyMonitoring;
    private final Function1<Member, Object> isExternalClusterMember;
    private final ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings;
    private final FailureDetectorRegistry<Address> crossDcFailureDetector;
    private long sequenceNr;
    private CrossDcHeartbeatingState dataCentersState;
    private final Cancellable heartbeatTask;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    public boolean activelyMonitoring() {
        return this.activelyMonitoring;
    }

    public void activelyMonitoring_$eq(boolean x$1) {
        this.activelyMonitoring = x$1;
    }

    public Function1<Member, Object> isExternalClusterMember() {
        return this.isExternalClusterMember;
    }

    public ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings() {
        return this.crossDcSettings;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    public long sequenceNr() {
        return this.sequenceNr;
    }

    public void sequenceNr_$eq(long x$1) {
        this.sequenceNr = x$1;
    }

    public ClusterHeartbeatSender.Heartbeat nextHeartBeat() {
        this.sequenceNr_$eq(this.sequenceNr() + 1L);
        return new ClusterHeartbeatSender.Heartbeat(this.cluster().selfAddress(), this.sequenceNr(), System.nanoTime());
    }

    public CrossDcHeartbeatingState dataCentersState() {
        return this.dataCentersState;
    }

    public void dataCentersState_$eq(CrossDcHeartbeatingState x$1) {
        this.dataCentersState = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    public void preStart() {
        block0: {
            this.cluster().subscribe(this.self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class}));
            if (!this.verboseHeartbeat()) break block0;
            this.log().debug("Initialized cross-dc heartbeat sender as DORMANT in DC: [{}]", (Object)this.cluster().selfDataCenter());
        }
    }

    public void postStop() {
        this.dataCentersState().activeReceivers().foreach((Function1 & Serializable)a -> {
            CrossDcHeartbeatSender.$anonfun$postStop$1(this, a);
            return BoxedUnit.UNIT;
        });
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.dormant().orElse(this.introspecting());
    }

    public PartialFunction<Object, BoxedUnit> dormant() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.init(currentClusterState);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    object = BoxedUnit.UNIT;
                } else {
                    object = ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1) ? BoxedUnit.UNIT : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ClusterEvent.CurrentClusterState ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.heartbeat();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterHeartbeatSender.HeartbeatRsp) {
                    ClusterHeartbeatSender.HeartbeatRsp heartbeatRsp = (ClusterHeartbeatSender.HeartbeatRsp)A1;
                    UniqueAddress from = heartbeatRsp.from();
                    this.$outer.heartbeatRsp(from);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat) {
                    ClusterHeartbeatSender.ExpectedFirstHeartbeat expectedFirstHeartbeat = (ClusterHeartbeatSender.ExpectedFirstHeartbeat)A1;
                    UniqueAddress from = expectedFirstHeartbeat.from();
                    this.$outer.triggerFirstHeartbeat(from);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object) ? true : (object instanceof ClusterHeartbeatSender.HeartbeatRsp ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : object instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> introspecting() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ReportStatus) {
                    package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)(this.$outer.activelyMonitoring() ? new MonitoringActive(this.$outer.dataCentersState()) : new MonitoringDormant()), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ReportStatus;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet<Member> nodes2 = snapshot.members();
        int nrOfMonitoredNodes = this.crossDcSettings().NrOfMonitoringActors();
        this.dataCentersState_$eq(CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), nrOfMonitoredNodes, nodes2));
        this.becomeActiveIfResponsibleForHeartbeat();
    }

    public void addMember(Member m) {
        block2: {
            if (!CrossDcHeartbeatingState$.MODULE$.atLeastInUpState(m)) break block2;
            this.dataCentersState_$eq(this.dataCentersState().addMember(m));
            if (this.verboseHeartbeat()) {
                String string = m.dataCenter();
                String string2 = this.cluster().selfDataCenter();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.log().debug("Register member {} for cross DC heartbeat (will only heartbeat if oldest)", (Object)m);
                }
            }
            this.becomeActiveIfResponsibleForHeartbeat();
        }
    }

    public void removeMember(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
        if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
            this.context().stop(this.self());
        } else {
            this.dataCentersState_$eq(this.dataCentersState().removeMember(m));
            this.becomeActiveIfResponsibleForHeartbeat();
        }
    }

    public void heartbeat() {
        ClusterHeartbeatSender.Heartbeat nextHB = this.nextHeartBeat();
        this.dataCentersState().activeReceivers().foreach((Function1 & Serializable)to -> {
            CrossDcHeartbeatSender.$anonfun$heartbeat$1(this, nextHB, to);
            return BoxedUnit.UNIT;
        });
    }

    public void heartbeatRsp(UniqueAddress from) {
        if (this.verboseHeartbeat()) {
            this.cluster().ClusterLogger().logDebug("(Cross) Heartbeat response from [{}]", from.address());
        }
        this.dataCentersState_$eq(this.dataCentersState().heartbeatRsp(from));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        block1: {
            if (!this.dataCentersState().activeReceivers().contains((Object)from) || this.crossDcFailureDetector().isMonitoring((Object)from.address())) break block1;
            if (this.verboseHeartbeat()) {
                this.cluster().ClusterLogger().logDebug("Trigger extra expected (cross) heartbeat from [{}]", from.address());
            }
            this.crossDcFailureDetector().heartbeat((Object)from.address());
        }
    }

    private boolean selfIsResponsibleForCrossDcHeartbeat() {
        int activeDcs = this.dataCentersState().dataCenters().size();
        return activeDcs > 1 ? this.dataCentersState().shouldActivelyMonitorNodes(this.cluster().selfDataCenter(), this.cluster().selfUniqueAddress()) : false;
    }

    private void becomeActiveIfResponsibleForHeartbeat() {
        block1: {
            block0: {
                if (this.activelyMonitoring() || !this.selfIsResponsibleForCrossDcHeartbeat()) break block0;
                this.log().info("Cross DC heartbeat becoming ACTIVE on this node (for DC: {}), monitoring other DCs oldest nodes", (Object)this.cluster().selfDataCenter());
                this.activelyMonitoring_$eq(true);
                this.context().become(this.active().orElse(this.introspecting()));
                break block1;
            }
            if (this.activelyMonitoring() || !this.verboseHeartbeat()) break block1;
            this.log().info("Remaining DORMANT; others in {} handle heartbeating other DCs", (Object)this.cluster().selfDataCenter());
        }
    }

    public static final /* synthetic */ boolean $anonfun$isExternalClusterMember$1(CrossDcHeartbeatSender $this, Member member) {
        String string = member.dataCenter();
        String string2 = $this.cluster().selfDataCenter();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$postStop$1(CrossDcHeartbeatSender $this, UniqueAddress a) {
        $this.crossDcFailureDetector().remove((Object)a.address());
    }

    public static final /* synthetic */ void $anonfun$heartbeat$1(CrossDcHeartbeatSender $this, ClusterHeartbeatSender.Heartbeat nextHB$1, UniqueAddress to) {
        BoxedUnit boxedUnit;
        if ($this.crossDcFailureDetector().isMonitoring((Object)to.address())) {
            if ($this.verboseHeartbeat()) {
                $this.cluster().ClusterLogger().logDebug("(Cross) Heartbeat to [{}]", to.address());
            }
            boxedUnit = BoxedUnit.UNIT;
        } else {
            if ($this.verboseHeartbeat()) {
                $this.cluster().ClusterLogger().logDebug("First (Cross) Heartbeat to [{}]", to.address());
            }
            boxedUnit = $this.cluster().scheduler().scheduleOnce($this.cluster().settings().HeartbeatExpectedResponseAfter(), $this.self(), (Object)new ClusterHeartbeatSender.ExpectedFirstHeartbeat(to), (ExecutionContext)$this.context().dispatcher(), $this.self());
        }
        ActorSelection$.MODULE$.toScala($this.heartbeatReceiver(to.address())).$bang((Object)nextHB$1, $this.self());
    }

    public CrossDcHeartbeatSender() {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.activelyMonitoring = false;
        this.isExternalClusterMember = (Function1 & Serializable)member -> BoxesRunTime.boxToBoolean((boolean)CrossDcHeartbeatSender.$anonfun$isExternalClusterMember$1(this, member));
        this.crossDcSettings = this.cluster().settings().MultiDataCenter().CrossDcFailureDetectorSettings();
        this.crossDcFailureDetector = this.cluster().crossDcFailureDetector();
        this.sequenceNr = 0L;
        this.dataCentersState = CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), this.crossDcSettings().NrOfMonitoringActors(), (SortedSet<Member>)((SortedSet)SortedSet$.MODULE$.empty(Member$.MODULE$.ordering())));
        this.heartbeatTask = this.cluster().scheduler().schedule(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()), this.cluster().settings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        Statics.releaseFence();
    }

    public static interface InspectionCommand
    extends NoSerializationVerificationNeeded {
    }

    public static final class MonitoringActive
    implements MonitoringStateReport,
    Product,
    Serializable {
        private final CrossDcHeartbeatingState state;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public CrossDcHeartbeatingState state() {
            return this.state;
        }

        public MonitoringActive copy(CrossDcHeartbeatingState state) {
            return new MonitoringActive(state);
        }

        public CrossDcHeartbeatingState copy$default$1() {
            return this.state();
        }

        public String productPrefix() {
            return "MonitoringActive";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.state();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MonitoringActive;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "state";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MonitoringActive)) return false;
            boolean bl = true;
            if (!bl) return false;
            MonitoringActive monitoringActive = (MonitoringActive)x$1;
            CrossDcHeartbeatingState crossDcHeartbeatingState = this.state();
            CrossDcHeartbeatingState crossDcHeartbeatingState2 = monitoringActive.state();
            if (crossDcHeartbeatingState != null) {
                if (!((Object)crossDcHeartbeatingState).equals(crossDcHeartbeatingState2)) return false;
                return true;
            }
            if (crossDcHeartbeatingState2 == null) return true;
            return false;
        }

        public MonitoringActive(CrossDcHeartbeatingState state) {
            this.state = state;
            Product.$init$((Product)this);
        }
    }

    public static final class MonitoringDormant
    implements MonitoringStateReport,
    Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MonitoringDormant copy() {
            return new MonitoringDormant();
        }

        public String productPrefix() {
            return "MonitoringDormant";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            Object object = Statics.ioobe((int)x$1);
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MonitoringDormant;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            String string = (String)Statics.ioobe((int)x$1);
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof MonitoringDormant;
            return bl;
        }

        public MonitoringDormant() {
            Product.$init$((Product)this);
        }
    }

    public static interface MonitoringStateReport
    extends StatusReport {
    }

    public static final class ReportStatus
    implements Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ReportStatus copy() {
            return new ReportStatus();
        }

        public String productPrefix() {
            return "ReportStatus";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            Object object = Statics.ioobe((int)x$1);
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReportStatus;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            String string = (String)Statics.ioobe((int)x$1);
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof ReportStatus;
            return bl;
        }

        public ReportStatus() {
            Product.$init$((Product)this);
        }
    }

    public static interface StatusReport
    extends NoSerializationVerificationNeeded {
    }
}

