/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer;

import com.xebialabs.database.anonymizer.AnonymizerBanner;
import com.xebialabs.database.anonymizer.AnonymizerOptions;
import com.xebialabs.database.anonymizer.Export;
import com.xebialabs.database.anonymizer.Import;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@ComponentScan(basePackages={"com.xebialabs.database.anonymizer"})
@Configuration
public class AnonymizerBootstrapper
implements CommandLineRunner {
    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{AnonymizerBootstrapper.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        app.setBanner((Banner)new AnonymizerBanner());
        app.run(args);
    }

    public void run(String ... args) {
        try {
            AnonymizerOptions options = AnonymizerOptions.parse(args);
            if (options.isDbImport()) {
                Import.start(options);
            } else {
                Export.start(options.isReportingDb());
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

