/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResourceContentServlet
extends DefaultServlet {
    private static final String FALLBACK_SYSTEM_PROPERTY_NAME = "com.xebialabs.deployit.jetty.ClassPathResourceContentServlet.fallbackDirectory";
    private final String packageName;
    private final boolean fallbackToDevelopmentResources;
    private final String fallbackDirectory;
    private static final Logger logger = LoggerFactory.getLogger(ClassPathResourceContentServlet.class);

    public ClassPathResourceContentServlet(String packageName) {
        Checks.checkNotNull((Object)packageName, (String)"packageName");
        this.packageName = packageName.replace('.', '/');
        this.fallbackDirectory = System.getProperty(FALLBACK_SYSTEM_PROPERTY_NAME);
        this.fallbackToDevelopmentResources = Strings.isNotEmpty((String)this.fallbackDirectory);
        if (logger.isDebugEnabled()) {
            logger.debug("Using {} as the document root on the classpath (fallbackToDevelopmentResources={}).", (Object)this.packageName, (Object)this.fallbackToDevelopmentResources);
        }
    }

    public Resource getResource(String pathInContext) {
        pathInContext = pathInContext.replace("-@project.version@", "");
        String resourcePath = this.packageName + pathInContext;
        if (logger.isDebugEnabled()) {
            logger.debug("Requested resource {} to load", (Object)resourcePath);
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
        try {
            Object r = null;
            if (url != null) {
                r = Objects.equals(url.getProtocol(), "xlp") ? new XlpUrlResource(url) : Resource.newResource((URL)url);
            } else if (this.fallbackToDevelopmentResources) {
                String fallbackUrl = "file:" + this.fallbackDirectory + pathInContext;
                logger.info("Cannot find {} in classpath, falling back to URL {}", (Object)resourcePath, (Object)fallbackUrl);
                r = Resource.newResource((String)fallbackUrl);
            }
            if (r == null || !r.exists()) {
                if (resourcePath.endsWith(".gz")) {
                    logger.debug("Cannot find {} in classpath", (Object)resourcePath);
                } else {
                    logger.error("Cannot find {} in classpath", (Object)resourcePath);
                }
            }
            return r;
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    private static class XlpUrlResource
    extends URLResource {
        public XlpUrlResource(URL url) throws IOException {
            super(url, url.openConnection());
        }

        public File getFile() throws IOException {
            return null;
        }
    }
}

