/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.HttpClientHolder;
import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitCommunicator {
    private HttpClientHolder httpClientHolder;
    private BooterConfig config;
    private static final Logger logger = LoggerFactory.getLogger(DeployitCommunicator.class);

    public DeployitCommunicator(BooterConfig config) {
        this.config = config;
        this.httpClientHolder = new HttpClientHolder(config);
    }

    public void shutdown() {
        logger.info("Shutting down {}", (Object)this.config);
        this.httpClientHolder.shutdown();
        RemoteBooter.remove(this.config);
        DescriptorRegistry.remove((DescriptorRegistryId)this.config);
    }

    public Proxies proxies() {
        return this.httpClientHolder.getProxies();
    }

    public Type getType(String typeName) {
        return DescriptorRegistry.getDescriptorRegistry((DescriptorRegistryId)this.config).lookupType(typeName);
    }

    public HttpClientHolder getHttpClientHolder() {
        return this.httpClientHolder;
    }

    public String getUsername() {
        return this.httpClientHolder.getUserName();
    }

    public HttpResponse execute(HttpUriRequest httpPost) throws ClientProtocolException, IOException {
        return this.httpClientHolder.execute(httpPost);
    }

    public Proxies getProxies() {
        return this.httpClientHolder.getProxies();
    }

    public BooterConfig getConfig() {
        return this.config;
    }

    public HttpClient httpClient() {
        return this.httpClientHolder.getHttpClient();
    }
}

