/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.verification;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.verification.OpenSSHKnownHosts;

public class ConsoleKnownHostsVerifier
extends OpenSSHKnownHosts {
    private static final String YES = "yes";
    private static final String NO = "no";
    private final Console console;

    public ConsoleKnownHostsVerifier(File khFile, Console console) throws IOException {
        super(khFile);
        this.console = console;
    }

    @Override
    protected boolean hostKeyUnverifiableAction(String hostname, PublicKey key) {
        KeyType type = KeyType.fromKey(key);
        this.console.printf("The authenticity of host '%s' can't be established.\n%s key fingerprint is %s.\n", new Object[]{hostname, type, SecurityUtils.getFingerprint(key)});
        String response = this.console.readLine("Are you sure you want to continue connecting (yes/no)? ", new Object[0]);
        while (!response.equalsIgnoreCase(YES) && !response.equalsIgnoreCase(NO)) {
            response = this.console.readLine("Please explicitly enter yes/no: ", new Object[0]);
        }
        if (response.equalsIgnoreCase(YES)) {
            try {
                this.entries().add(new OpenSSHKnownHosts.HostEntry(null, hostname, KeyType.fromKey(key), key));
                this.write();
                this.console.printf("Warning: Permanently added '%s' (%s) to the list of known hosts.\n", new Object[]{hostname, type});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean hostKeyChangedAction(String hostname, PublicKey key) {
        KeyType type = KeyType.fromKey(key);
        String fp = SecurityUtils.getFingerprint(key);
        String path = this.getFile().getAbsolutePath();
        this.console.printf("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@    WARNING: REMOTE HOST IDENTIFICATION HAS CHANGED!     @\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\nIT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY!\nSomeone could be eavesdropping on you right now (man-in-the-middle attack)!\nIt is also possible that the host key has just been changed.\nThe fingerprint for the %s key sent by the remote host is\n%s.\nPlease contact your system administrator oradd correct host key in %s to get rid of this message.\n", new Object[]{type, fp, path});
        return false;
    }
}

