/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.stereotype.Component;

@Component
public class XlAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(XlAuthenticationProvider.class);
    private UserService userService;
    private GrantedAuthoritiesMapper authoritiesMapper = new NullAuthoritiesMapper();

    @Autowired
    public XlAuthenticationProvider(UserService userService) {
        this.userService = userService;
    }

    public Authentication authenticate(Authentication token) throws AuthenticationException {
        logger.debug("Authenticating for XL product: {}", token.getPrincipal());
        String username = token.getPrincipal().toString();
        String password = token.getCredentials().toString();
        return this.doAuthentication(username, password);
    }

    private Authentication doAuthentication(String username, String password) {
        if (Strings.isBlank((String)username)) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        try {
            logger.trace("Authenticating [{}]", (Object)username);
            this.userService.authenticate(username, password);
            User user = this.userService.read(username);
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            if (user.isAdmin() || "admin".equals(user.getUsername())) {
                authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
            }
            Collection mappedAuthorities = this.authoritiesMapper.mapAuthorities(authorities);
            return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, mappedAuthorities);
        }
        catch (NotFoundException | AuthenticationFailureException exc) {
            throw new BadCredentialsException("Cannot authenticate " + username, exc);
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class);
    }

    public GrantedAuthoritiesMapper getAuthoritiesMapper() {
        return this.authoritiesMapper;
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }
}

