/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.qom.QueryObjectModel;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.observation.EventImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.query.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.QueryHandlerFactory;
import org.apache.jackrabbit.core.query.QueryObjectModelImpl;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchManager
implements SynchronousEventListener {
    private static final Logger log = LoggerFactory.getLogger(SearchManager.class);
    private static final String NS_FN_PREFIX = "fn";
    public static final String NS_FN_URI = "http://www.w3.org/2005/xpath-functions";
    private static final String NS_FN_OLD_PREFIX = "fn_old";
    public static final String NS_FN_OLD_URI = "http://www.w3.org/2004/10/xpath-functions";
    private static final String NS_XS_PREFIX = "xs";
    public static final String NS_XS_URI = "http://www.w3.org/2001/XMLSchema";
    private final SharedItemStateManager itemMgr;
    private QueryHandler handler;
    private final QueryHandler parentHandler;
    private final NamespaceRegistryImpl nsReg;
    private Path excludePath;

    public SearchManager(String workspace, RepositoryContext repositoryContext, QueryHandlerFactory qhf, SharedItemStateManager itemMgr, PersistenceManager pm, NodeId rootNodeId, SearchManager parentMgr, NodeId excludedNodeId) throws RepositoryException {
        this.nsReg = repositoryContext.getNamespaceRegistry();
        this.itemMgr = itemMgr;
        this.parentHandler = parentMgr != null ? parentMgr.handler : null;
        this.safeRegisterNamespace(NS_XS_PREFIX, NS_XS_URI);
        try {
            if (this.nsReg.getPrefix(NS_FN_OLD_URI).equals(NS_FN_PREFIX)) {
                String prefix = NS_FN_OLD_PREFIX;
                try {
                    int i = 2;
                    while (true) {
                        this.nsReg.getURI(prefix);
                        prefix = NS_FN_OLD_PREFIX + i;
                        ++i;
                    }
                }
                catch (NamespaceException e) {
                    this.nsReg.registerNamespace(prefix, NS_FN_OLD_URI);
                }
            }
        }
        catch (NamespaceException e) {
            this.safeRegisterNamespace(NS_FN_OLD_PREFIX, NS_FN_OLD_URI);
        }
        this.safeRegisterNamespace(NS_FN_PREFIX, NS_FN_URI);
        if (excludedNodeId != null) {
            HierarchyManagerImpl hmgr = new HierarchyManagerImpl(rootNodeId, itemMgr);
            this.excludePath = hmgr.getPath(excludedNodeId);
        }
        this.handler = qhf.getQueryHandler(new QueryHandlerContext(workspace, repositoryContext, itemMgr, pm, rootNodeId, this.parentHandler, excludedNodeId));
    }

    private void safeRegisterNamespace(String prefixHint, String uri) throws NamespaceException, RepositoryException {
        try {
            this.nsReg.getPrefix(uri);
        }
        catch (NamespaceException e1) {
            String prefix = prefixHint;
            try {
                int suffix = 2;
                while (true) {
                    this.nsReg.getURI(prefix);
                    prefix = prefixHint + suffix;
                    ++suffix;
                }
            }
            catch (NamespaceException e2) {
                this.nsReg.registerNamespace(prefix, uri);
            }
        }
    }

    public void close() {
        try {
            this.shutdownQueryHandler();
        }
        catch (IOException e) {
            log.error("Exception closing QueryHandler.", (Throwable)e);
        }
    }

    public Query createQuery(SessionContext sessionContext, String statement, String language, Node node) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(sessionContext, this.handler, statement, language, node);
        return query;
    }

    public QueryObjectModel createQueryObjectModel(SessionContext sessionContext, QueryObjectModelTree qomTree, String langugage, Node node) throws InvalidQueryException, RepositoryException {
        QueryObjectModelImpl qom = new QueryObjectModelImpl();
        qom.init(sessionContext, this.handler, qomTree, langugage, node);
        return qom;
    }

    public Iterable<NodeId> getWeaklyReferringNodes(NodeId id) throws RepositoryException, IOException {
        return this.handler.getWeaklyReferringNodes(id);
    }

    private boolean isExcluded(EventImpl event) {
        try {
            return this.excludePath != null && this.excludePath.isAncestorOf(event.getQPath());
        }
        catch (MalformedPathException ex) {
            log.error("Error filtering events.", (Throwable)ex);
            return false;
        }
        catch (RepositoryException ex) {
            log.error("Error filtering events.", (Throwable)ex);
            return false;
        }
    }

    public QueryHandler getQueryHandler() {
        return this.handler;
    }

    public void onEvent(EventIterator events) {
        log.debug("onEvent: indexing started");
        long time = System.currentTimeMillis();
        HashSet<NodeId> removedNodes = new HashSet<NodeId>();
        final HashMap<NodeId, Object> addedNodes = new HashMap<NodeId, Object>();
        ArrayList<Object> propEvents = new ArrayList<Object>();
        while (events.hasNext()) {
            EventImpl e = (EventImpl)events.nextEvent();
            if (this.isExcluded(e)) continue;
            long l = e.getType();
            if (l == 1L) {
                addedNodes.put(e.getChildId(), e);
                if (!e.isShareableChildNode()) continue;
                removedNodes.add(e.getChildId());
                continue;
            }
            if (l == 2L) {
                removedNodes.add(e.getChildId());
                if (!e.isShareableChildNode() || !this.itemMgr.hasItemState(e.getChildId())) continue;
                addedNodes.put(e.getChildId(), e);
                continue;
            }
            propEvents.add(e);
        }
        for (EventImpl eventImpl : propEvents) {
            NodeId nodeId = eventImpl.getParentId();
            if (eventImpl.getType() == 4) {
                if (addedNodes.put(nodeId, eventImpl) != null) continue;
                removedNodes.add(nodeId);
                continue;
            }
            if (eventImpl.getType() == 16) {
                addedNodes.put(nodeId, eventImpl);
                removedNodes.add(nodeId);
                continue;
            }
            addedNodes.put(nodeId, eventImpl);
            removedNodes.add(nodeId);
        }
        Iterator<NodeState> addedStates = new Iterator<NodeState>(){
            private final Iterator<NodeId> iter;
            {
                this.iter = addedNodes.keySet().iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public NodeState next() {
                NodeState item = null;
                NodeId id = this.iter.next();
                try {
                    item = (NodeState)SearchManager.this.itemMgr.getItemState(id);
                }
                catch (ItemStateException ise) {
                    EventImpl e = (EventImpl)addedNodes.get(id);
                    if (e == null || !e.isExternal()) {
                        log.error("Unable to index node " + id + ": does not exist");
                    }
                    log.info("Node no longer available " + id + ", skipped.");
                }
                return item;
            }
        };
        Iterator<NodeId> iterator = removedNodes.iterator();
        if (removedNodes.size() > 0 || addedNodes.size() > 0) {
            try {
                this.handler.updateNodes(iterator, addedStates);
            }
            catch (RepositoryException e) {
                log.error("Error indexing node.", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Error indexing node.", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("onEvent: indexing finished in " + String.valueOf(System.currentTimeMillis() - time) + " ms.");
        }
    }

    protected AbstractQueryImpl createQueryInstance() throws RepositoryException {
        try {
            String queryImplClassName = this.handler.getQueryClass();
            Object obj = Class.forName(queryImplClassName).newInstance();
            if (obj instanceof AbstractQueryImpl) {
                return (AbstractQueryImpl)obj;
            }
            throw new IllegalArgumentException(queryImplClassName + " is not of type " + AbstractQueryImpl.class.getName());
        }
        catch (Throwable t) {
            throw new RepositoryException("Unable to create query: " + t.toString(), t);
        }
    }

    private void shutdownQueryHandler() throws IOException {
        if (this.handler != null) {
            this.handler.close();
            this.handler = null;
        }
    }
}

