/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.upgrade;

import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.server.api.upgrade.RepoType;
import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization;
import com.xebialabs.deployit.upgrade.InitializationStrategy;
import com.xebialabs.deployit.upgrade.JcrRepositoryInitialization;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JcrInitializationStrategy
implements InitializationStrategy {
    private JcrTemplate jcrTemplate;
    private static Logger logger = LoggerFactory.getLogger(JcrInitializationStrategy.class);

    @Autowired
    public JcrInitializationStrategy(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public Set<Class<? extends RepositoryInitialization>> findApplicableInitializerTypes() {
        return InitializationStrategy.findApplicableInitializerTypes((RepoType)RepoType.JCR);
    }

    public void doInitializations(List<RepositoryInitialization> sortedInitializations) {
        this.jcrTemplate.execute(session -> {
            for (RepositoryInitialization initialization : sortedInitializations) {
                logger.debug("Running initialization [{}]: {}", initialization.getClass(), (Object)initialization);
                if (initialization instanceof JcrRepositoryInitialization) {
                    ((JcrRepositoryInitialization)initialization).setRepository(new RawRepositoryImpl(session));
                }
                initialization.doInitialize();
            }
            session.save();
            return null;
        });
    }
}

