/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.PathHelper;
import com.xebialabs.deployit.repository.core.Securable;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPermissions {
    private static final Logger logger = LoggerFactory.getLogger(JcrPermissions.class);

    public static List<String> splitIds(String principals) {
        ArrayList<String> split = new ArrayList<String>();
        if (principals == null) {
            return split;
        }
        StringTokenizer tokens = new StringTokenizer(principals, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.isEmpty()) continue;
            split.add(token);
        }
        return split;
    }

    public static String joinIds(Collection<String> ids) {
        return JcrPermissions.joinIds(ids.stream());
    }

    public static String joinIds(Stream<String> roles) {
        return roles.collect(Collectors.joining(","));
    }

    static List<String> rolesToIds(Iterable<? extends Role> roles) {
        return StreamSupport.stream(roles.spliterator(), false).map(Role::getId).collect(Collectors.toList());
    }

    public static Map<String, Role> buildLookupById(List<Role> roles) {
        return roles.stream().collect(Collectors.toMap(r -> Optional.ofNullable(r.getId()).orElse(""), Function.identity()));
    }

    public static Map<String, Role> buildLookupByName(List<Role> roles) {
        return roles.stream().collect(Collectors.toMap(r -> Optional.ofNullable(r.getName()).orElse(""), Function.identity()));
    }

    static List<String> getFullTreeAsSeparateNodesInChildToRootOrder(String onConfigurationItem) {
        ArrayList<String> list = new ArrayList<String>();
        int index = onConfigurationItem.indexOf(47);
        while (index > -1) {
            list.add(onConfigurationItem.substring(0, index));
            index = onConfigurationItem.indexOf(47, index + 1);
        }
        list.add(onConfigurationItem);
        Collections.reverse(list);
        logger.debug("Split off tree: {} to {}", (Object)onConfigurationItem, list);
        return list;
    }

    static Node readSecurable(String securable, Session session) throws RepositoryException {
        Node node = session.getNode(PathHelper.getAbsolutePathFromId((String)securable));
        JcrPermissions.checkSecurable(node);
        return node;
    }

    static void checkSecurable(Node node) throws RepositoryException {
        String type = node.getProperty("$configuration.item.type").getString();
        Checks.checkArgument((boolean)JcrPermissions.isSecurable(node), (String)"Cannot set permission on [%s] because it is not Securable [%s]", (Object[])new Object[]{PathHelper.getIdFromAbsolutePath((String)node.getPath()), type});
    }

    static boolean isSecurable(Node node) throws RepositoryException {
        String type = node.getProperty("$configuration.item.type").getString();
        return Type.valueOf((String)type).isSubTypeOf(Type.valueOf(Securable.class));
    }

    static Map<String, String> readPermissionMap(Node s) throws RepositoryException {
        Map permissions = Maps.newHashMap();
        if (s.hasProperty("securityPermissions")) {
            Property securityPermissions = s.getProperty("securityPermissions");
            permissions = JcrUtils.readMap((Property)securityPermissions);
        }
        return permissions;
    }

    static void writePermissionMap(Node s, Map<String, String> permissions) throws RepositoryException {
        JcrUtils.writeMap((Node)s, (String)"securityPermissions", permissions);
    }

    public static Collection<Permission> isApplicableTo(Collection<Permission> values, String id) {
        return Collections2.filter(values, input -> !input.isApplicableTo(id));
    }
}

