/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;

public final class NodeInfo {
    private static final ConcurrentMap<NodeId, NodeId> nodeIdPool = new ConcurrentHashMap<NodeId, NodeId>(1000);
    private final NodeId nodeId;
    private final NodeId parentId;
    private List<NodeId> children;
    private Map<Name, List<NodeId>> references;
    private boolean isReferenceable;
    private boolean hasBlobsInDataStore;

    public NodeInfo(NodePropBundle bundle) {
        this.nodeId = NodeInfo.getNodeId(bundle.getId());
        this.parentId = NodeInfo.getNodeId(bundle.getParentId());
        List<NodePropBundle.ChildNodeEntry> childNodeEntries = bundle.getChildNodeEntries();
        if (!childNodeEntries.isEmpty()) {
            this.children = new ArrayList<NodeId>(childNodeEntries.size());
            for (NodePropBundle.ChildNodeEntry childNodeEntry : bundle.getChildNodeEntries()) {
                this.children.add(NodeInfo.getNodeId(childNodeEntry.getId()));
            }
        } else {
            this.children = Collections.emptyList();
        }
        block1: for (NodePropBundle.PropertyEntry propertyEntry : bundle.getPropertyEntries()) {
            if (propertyEntry.getType() == 9) {
                if (this.references == null) {
                    this.references = new HashMap<Name, List<NodeId>>(4);
                }
                ArrayList<NodeId> values = new ArrayList<NodeId>(propertyEntry.getValues().length);
                InternalValue[] internalValueArray = propertyEntry.getValues();
                int n = internalValueArray.length;
                for (int i = 0; i < n; ++i) {
                    InternalValue value = internalValueArray[i];
                    values.add(NodeInfo.getNodeId(value.getNodeId()));
                }
                this.references.put(propertyEntry.getName(), values);
                continue;
            }
            if (propertyEntry.getType() != 2) continue;
            for (InternalValue internalValue : propertyEntry.getValues()) {
                if (!internalValue.isInDataStore()) continue;
                this.hasBlobsInDataStore = true;
                continue block1;
            }
        }
        if (this.references == null) {
            this.references = Collections.emptyMap();
        }
        this.isReferenceable = bundle.isReferenceable();
    }

    public NodeId getId() {
        return this.nodeId;
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public List<NodeId> getChildren() {
        return this.children;
    }

    public Map<Name, List<NodeId>> getReferences() {
        return this.references;
    }

    public boolean isReferenceable() {
        return this.isReferenceable;
    }

    public boolean hasBlobsInDataStore() {
        return this.hasBlobsInDataStore;
    }

    private static NodeId getNodeId(NodeId nodeId) {
        if (nodeId == null) {
            return null;
        }
        NodeId cached = (NodeId)nodeIdPool.get(nodeId);
        if (cached == null && (cached = nodeIdPool.putIfAbsent(nodeId, nodeId)) == null) {
            cached = nodeId;
        }
        return cached;
    }

    public static void clearPool() {
        nodeIdPool.clear();
    }
}

