/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.pool;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.jackrabbit.core.util.StringIndex;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DbUtility;

public class DbNameIndex
implements StringIndex {
    protected final ConnectionHelper conHelper;
    protected String nameSelectSQL;
    protected String indexSelectSQL;
    protected String nameInsertSQL;
    private final HashMap<String, Integer> string2Index = new HashMap();
    private final HashMap<Integer, String> index2String = new HashMap();

    public DbNameIndex(ConnectionHelper conHlpr, String schemaObjectPrefix) throws SQLException {
        this.conHelper = conHlpr;
        this.init(schemaObjectPrefix);
    }

    protected void init(String schemaObjectPrefix) throws SQLException {
        this.nameSelectSQL = "select NAME from " + schemaObjectPrefix + "NAMES where ID = ?";
        this.indexSelectSQL = "select ID from " + schemaObjectPrefix + "NAMES where NAME = ?";
        this.nameInsertSQL = "insert into " + schemaObjectPrefix + "NAMES (NAME) values (?)";
    }

    public void close() {
    }

    @Override
    public int stringToIndex(String string) {
        Integer index = this.string2Index.get(string);
        if (index == null) {
            String dbString = string.length() == 0 ? " " : string;
            int idx = this.getIndex(dbString);
            if (idx == -1) {
                idx = this.insertString(dbString);
            }
            index = idx;
            this.string2Index.put(string, index);
            this.index2String.put(index, string);
            return idx;
        }
        return index;
    }

    @Override
    public String indexToString(int idx) throws IllegalArgumentException {
        Integer index = idx;
        String s = this.index2String.get(index);
        if (s == null) {
            s = this.getString(idx);
            if (s.equals(" ")) {
                s = "";
            }
            this.index2String.put(index, s);
            this.string2Index.put(s, index);
        }
        return s;
    }

    protected int insertString(String string) {
        int result = -1;
        ResultSet rs = null;
        try {
            rs = this.conHelper.exec(this.nameInsertSQL, new Object[]{string}, true, 0);
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (Exception e) {
            try {
                IllegalStateException ise = new IllegalStateException("Unable to insert index for string: " + string);
                ise.initCause(e);
                throw ise;
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                throw throwable;
            }
        }
        DbUtility.close((ResultSet)rs);
        if (result != -1) {
            return result;
        }
        return this.getIndex(string);
    }

    protected int getIndex(String string) {
        int n;
        ResultSet rs;
        block5: {
            rs = null;
            rs = this.conHelper.exec(this.indexSelectSQL, new Object[]{string}, false, 0);
            if (!rs.next()) break block5;
            int n2 = rs.getInt(1);
            DbUtility.close((ResultSet)rs);
            return n2;
        }
        try {
            n = -1;
        }
        catch (Exception e) {
            try {
                IllegalStateException ise = new IllegalStateException("Unable to read index for string: " + string);
                ise.initCause(e);
                throw ise;
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                throw throwable;
            }
        }
        DbUtility.close((ResultSet)rs);
        return n;
    }

    protected String getString(int index) throws IllegalArgumentException, IllegalStateException {
        String result = null;
        ResultSet rs = null;
        try {
            rs = this.conHelper.exec(this.nameSelectSQL, new Object[]{index}, false, 0);
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (Exception e) {
            try {
                IllegalStateException ise = new IllegalStateException("Unable to read name for index: " + index);
                ise.initCause(e);
                throw ise;
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                throw throwable;
            }
        }
        DbUtility.close((ResultSet)rs);
        if (result == null) {
            throw new IllegalArgumentException("Index not found: " + index);
        }
        return result;
    }
}

