/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.gc;

import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.service.gc.GarbageCollectionService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import nl.javadude.t2bus.Subscribe;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.gc.GarbageCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitGarbageCollectionService
implements GarbageCollectionService {
    private static final Logger logger = LoggerFactory.getLogger(JackrabbitGarbageCollectionService.class);
    private static final AtomicBoolean isInProgress = new AtomicBoolean(false);
    private static final AtomicBoolean isShutdownRequested = new AtomicBoolean(false);
    private Repository repository;

    public JackrabbitGarbageCollectionService(Repository jcrRepository) {
        this.repository = jcrRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runGarbageCollector() {
        if (!isInProgress.compareAndSet(false, true)) {
            logger.info("Garbage collector is already running");
            return;
        }
        logger.info("Garbage collector starting");
        try {
            Session garbageCollectionSession = this.repository.login((Credentials)new SimpleCredentials("anonymous", "".toCharArray()));
            try (GarbageCollector gc = ((RepositoryImpl)this.repository).createDataStoreGarbageCollector();){
                if (!isShutdownRequested.get()) {
                    logger.info("Garbage collector mark phase starting");
                    gc.mark();
                    logger.info("Garbage collector mark phase ended");
                }
                if (!isShutdownRequested.get()) {
                    logger.info("Garbage collector sweep phase starting");
                    gc.sweep();
                    logger.info("Garbage collector sweep phase ended");
                }
            }
            finally {
                garbageCollectionSession.logout();
            }
            logger.info("Garbage collector completed");
        }
        catch (RepositoryException exc) {
            logger.error("Cannot run the garbage collector", (Throwable)exc);
        }
        finally {
            isInProgress.set(false);
        }
    }

    @Subscribe
    public void onShutdown(ShutdownEvent sde) {
        isShutdownRequested.set(true);
    }
}

