/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.kerberos.KerberosPrincipal;
import scala.Array$;
import scala.Option;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import sun.security.util.HostnameChecker;

@ScalaSignature(bytes="\u0006\u0001a4AAC\u0006\u0001)!Aa\u0005\u0001B\u0001B\u0003%q\u0005C\u0003.\u0001\u0011\u0005a\u0006C\u00043\u0001\t\u0007I\u0011B\u001a\t\r]\u0002\u0001\u0015!\u00035\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u0015Q\u0007\u0001\"\u0001l\u0005]!UMZ1vYRDun\u001d;oC6,g+\u001a:jM&,'O\u0003\u0002\r\u001b\u0005\u00191o\u001d7\u000b\u00059y\u0011!C:tY\u000e|gNZ5h\u0015\t\u0001\u0012#\u0001\u0005usB,7/\u00194f\u0015\u0005\u0011\u0012aA2p[\u000e\u00011c\u0001\u0001\u0016;A\u0011acG\u0007\u0002/)\u0011\u0001$G\u0001\u0005Y\u0006twMC\u0001\u001b\u0003\u0011Q\u0017M^1\n\u0005q9\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001fI5\tqD\u0003\u0002\rA)\u0011\u0011EI\u0001\u0004]\u0016$(\"A\u0012\u0002\u000b)\fg/\u0019=\n\u0005\u0015z\"\u0001\u0005%pgRt\u0017-\\3WKJLg-[3s\u0003!i7\u000eT8hO\u0016\u0014\bC\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u000e\u0003\u0011)H/\u001b7\n\u00051J#!\u0004'pO\u001e,'OR1di>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0003_E\u0002\"\u0001\r\u0001\u000e\u0003-AQA\n\u0002A\u0002\u001d\na\u0001\\8hO\u0016\u0014X#\u0001\u001b\u0011\u0005!*\u0014B\u0001\u001c*\u00051qu\u000eR3qg2{wmZ3s\u0003\u001dawnZ4fe\u0002\nq\u0002[8ti:\fW.Z\"iK\u000e\\WM]\u000b\u0002uA\u00111(Q\u0007\u0002y)\u0011!&\u0010\u0006\u0003}}\n\u0001b]3dkJLG/\u001f\u0006\u0002\u0001\u0006\u00191/\u001e8\n\u0005\tc$a\u0004%pgRt\u0017-\\3DQ\u0016\u001c7.\u001a:\u0002\u001b5\fGo\u00195LKJ\u0014WM]8t)\r)5\n\u0017\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\b\u0005>|G.Z1o\u0011\u0015ae\u00011\u0001N\u0003!Awn\u001d;oC6,\u0007C\u0001(V\u001d\ty5\u000b\u0005\u0002Q\u000f6\t\u0011K\u0003\u0002S'\u00051AH]8pizJ!\u0001V$\u0002\rA\u0013X\rZ3g\u0013\t1vK\u0001\u0004TiJLgn\u001a\u0006\u0003)\u001eCQ!\u0017\u0004A\u0002i\u000b\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0011\u0005mkV\"\u0001/\u000b\u0005yJ\u0012B\u00010]\u0005%\u0001&/\u001b8dSB\fG.\u0001\u0006jg.+'OY3s_N$\"!R1\t\u000be;\u0001\u0019\u0001.\u0002\rY,'/\u001b4z)\r)E-\u001a\u0005\u0006\u0019\"\u0001\r!\u0014\u0005\u0006M\"\u0001\raZ\u0001\bg\u0016\u001c8/[8o!\tq\u0002.\u0003\u0002j?\tQ1k\u0015'TKN\u001c\u0018n\u001c8\u0002#5\fGo\u00195DKJ$\u0018NZ5dCR,7\u000fF\u0002FY6DQ\u0001T\u0005A\u00025CQA\\\u0005A\u0002=\f\u0001\u0003]3fe\u000e+'\u000f^5gS\u000e\fG/Z:\u0011\u0007\u0019\u0003(/\u0003\u0002r\u000f\n)\u0011I\u001d:bsB\u00111O^\u0007\u0002i*\u0011Q\u000fX\u0001\u0005G\u0016\u0014H/\u0003\u0002xi\nY1)\u001a:uS\u001aL7-\u0019;f\u0001")
public class DefaultHostnameVerifier
implements HostnameVerifier {
    private final NoDepsLogger logger;

    private NoDepsLogger logger() {
        return this.logger;
    }

    public HostnameChecker hostnameChecker() {
        return HostnameChecker.getInstance((byte)1);
    }

    public boolean matchKerberos(String hostname, Principal principal) {
        return HostnameChecker.match((String)hostname, (Principal)((KerberosPrincipal)principal));
    }

    public boolean isKerberos(Principal principal) {
        return principal != null && principal instanceof KerberosPrincipal;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        boolean bl;
        Base64.Encoder base64 = Base64.getMimeEncoder();
        this.logger().debug(new StringBuilder(42).append("verify: hostname = ").append(hostname).append(", sessionId (base64) = ").append(base64.encodeToString(session.getId())).toString());
        try {
            Certificate[] peerCertificates = session.getPeerCertificates();
            bl = this.matchCertificates(hostname, peerCertificates);
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            try {
                Principal principal = session.getPeerPrincipal();
                if (this.isKerberos(principal)) {
                    bl = this.matchKerberos(hostname, principal);
                } else {
                    this.logger().debug("verify: Can't verify principal, not Kerberos");
                    bl = false;
                }
            }
            catch (SSLPeerUnverifiedException e) {
                this.logger().debug(new StringBuilder(45).append("Can't verify principal, no principal. Cause: ").append(e).toString());
                bl = false;
            }
        }
        boolean result = bl;
        this.logger().debug(new StringBuilder(18).append("verify: returning ").append(result).toString());
        return result;
    }

    public boolean matchCertificates(String hostname, Certificate[] peerCertificates) {
        boolean bl;
        Certificate cert;
        HostnameChecker checker = this.hostnameChecker();
        Certificate[] certificateArray = peerCertificates;
        Option option = Array$.MODULE$.unapplySeq((Object)certificateArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) >= 0 && (cert = (Certificate)((SeqLike)option.get()).apply(0)) instanceof X509Certificate) {
            boolean bl2;
            X509Certificate x509Certificate = (X509Certificate)cert;
            try {
                checker.match(hostname, x509Certificate);
                bl2 = true;
            }
            catch (CertificateException e) {
                Collection<List<?>> subjectAltNames = x509Certificate.getSubjectAlternativeNames();
                this.logger().debug(new StringBuilder(84).append("verify: Certificate does not match hostname! subjectAltNames = ").append(subjectAltNames).append(", hostName = ").append(hostname).append(" Cause: ").append(e).toString());
                bl2 = false;
            }
            bl = bl2;
        } else {
            this.logger().debug(new StringBuilder(45).append("verify: Peer does not have any certificates: ").append(certificateArray).toString());
            bl = false;
        }
        return bl;
    }

    public DefaultHostnameVerifier(LoggerFactory mkLogger) {
        this.logger = mkLogger.apply(this.getClass());
    }
}

