/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.utils;

import com.ibm.mq.MQException;
import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.MQDataException;
import com.ibm.mq.headers.pcf.PCFException;
import com.ibm.mq.headers.pcf.PCFMessageAgent;
import com.xebialabs.deployit.StepExecutionContext;
import java.io.IOException;

public class PCF_CommonMethods {
    public String queueManager = "*";
    public String host = "localhost";
    public int port = 1414;
    public String channel = "SYSTEM.DEF.SVRCONN";
    public PCFMessageAgent agent = null;
    public boolean client = false;

    public void createAgent(int numOfArgs) throws MQDataException {
        if (numOfArgs == 1) {
            this.client = false;
            this.agent = new PCFMessageAgent(this.queueManager);
        } else {
            this.client = true;
            this.agent = new PCFMessageAgent(this.host, this.port, this.channel);
        }
    }

    public void destroyAgent() throws MQDataException {
        this.agent.disconnect();
    }

    public void displayException(Exception exception, StepExecutionContext ctx) {
        if (exception.getClass().equals(PCFException.class)) {
            PCFException pcfe = (PCFException)exception;
            if (pcfe.reasonCode == 4001) {
                ctx.logOutput("The Name already exists on the queue manager.");
            } else if (pcfe.reasonCode == 4032) {
                if (this.client) {
                    ctx.logError("Either the queue manager \"" + this.queueManager + "\"");
                } else {
                    ctx.logError("Either the default queue manager");
                }
            } else {
                ctx.logError(pcfe + ": " + MQConstants.lookupReasonCode((int)pcfe.reasonCode));
            }
        } else if (exception.getClass().equals(IOException.class)) {
            IOException ioe = (IOException)exception;
            ctx.logError("IOException:" + ioe);
        } else if (exception.getClass().equals(MQDataException.class)) {
            MQDataException de = (MQDataException)exception;
            ctx.logError(de + ": " + MQConstants.lookupReasonCode((int)de.reasonCode));
        } else if (exception.getClass().equals(MQException.class)) {
            MQException mqe = (MQException)exception;
            if (mqe.reasonCode == 2085) {
                ctx.logError("Unknown Object name");
            } else {
                ctx.logError(mqe + ": " + MQConstants.lookupReasonCode((int)mqe.reasonCode));
            }
        } else {
            ctx.logError("Exception:" + exception.getMessage());
        }
    }

    public String getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }
}

