/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqRequesterChannel;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMCAType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPutAuthority;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLClientAuthentication;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

/**
 * Creates a {@link WmqRequesterChannel} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqRequesterChannelStep extends BaseWmqStep {

	public WmqRequesterChannel wmqRequesterChannel;
	private int[] messageCompressionList = new int[1];

	public CreateWmqRequesterChannelStep(WmqRequesterChannel wmqRequesterChannel, WmqQueueManager wmqQmanager)

	{

		this.wmqRequesterChannel = wmqRequesterChannel;
		this.wmqQmanager = wmqQmanager;
	}

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_CREATE_CHANNEL;

	}

	@Override
	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// Setting MQ RequesterChannel ChannelName
		pcfCmd.addParameter(MQConstants.MQCACH_CHANNEL_NAME, wmqRequesterChannel.getChannelName());

		// Setting MQ RequesterChannel ChannelType
		pcfCmd.addParameter(MQConstants.MQIACH_CHANNEL_TYPE, MQConstants.MQCHT_REQUESTER);

		// Setting MQ RequesterChannel Channel Description
		if (StringUtils.isNotBlank(wmqRequesterChannel.getDescription())) {

			pcfCmd.addParameter(MQConstants.MQCACH_DESC, wmqRequesterChannel.getDescription());
		}

		// Setting MQ RequesterChannel Transport Type
		if (WmqTransmissionProtocolTypes.LU6 == wmqRequesterChannel.getTransportType()) {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_LU62);
		} else if (WmqTransmissionProtocolTypes.NET_BIOS == wmqRequesterChannel.getTransportType()) {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_NETBIOS);
		} else if (WmqTransmissionProtocolTypes.SPX == wmqRequesterChannel.getTransportType()) {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_SPX);
		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_TCP);
		}

		// Setting MQ RequesterChannel Connection name
		if (StringUtils.isNotBlank(wmqRequesterChannel.getConnectionName())) {

			pcfCmd.addParameter(MQConstants.MQCACH_CONNECTION_NAME, wmqRequesterChannel.getConnectionName());
		}

		// Setting MQ RequesterChannel Local communications address
		if (StringUtils.isNotBlank(wmqRequesterChannel.getLocalCommunicationAddress())) {

			pcfCmd.addParameter(MQConstants.MQCACH_LOCAL_ADDRESS, wmqRequesterChannel.getLocalCommunicationAddress());
		}

		// Setting MQ RequesterChannel HeaderCompression value
		if (WmqHeaderCompression.SYSTEM == wmqRequesterChannel.getHeaderCompression()) {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_SYSTEM;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		} else {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_NONE;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		}

		// Setting MQ RequesterChannel KeepAliveInterval
		if (wmqRequesterChannel.getKeepAliveInterval() > -1 && wmqRequesterChannel.getKeepAliveInterval() <= 99999) {
			pcfCmd.addParameter(MQConstants.MQIACH_KEEP_ALIVE_INTERVAL, wmqRequesterChannel.getKeepAliveInterval());
		}

		// Setting MQ RequesterChannel HeartbeatInterval
		pcfCmd.addParameter(MQConstants.MQIACH_HB_INTERVAL, wmqRequesterChannel.getHeartBeatInterval());

		// Setting MQ RequesterChannel MaximumMessageLength
		pcfCmd.addParameter(MQConstants.MQIACH_MAX_MSG_LENGTH, wmqRequesterChannel.getMaximumMessageLength());

		// Setting MQ RequesterChannel maximum message sequence number
		if (wmqRequesterChannel.getSequenceNumberWrap() < 100) {
			pcfCmd.addParameter(MQConstants.MQIACH_SEQUENCE_NUMBER_WRAP, 999999999);
		} else if (wmqRequesterChannel.getSequenceNumberWrap() != 0) {

			pcfCmd.addParameter(MQConstants.MQIACH_SEQUENCE_NUMBER_WRAP, wmqRequesterChannel.getSequenceNumberWrap());
		}

		// Setting MQ RequesterChannel MessageCompression Value
		if (WmqChannelMessageCompression.ANY == wmqRequesterChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ANY;

			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		} else if (WmqChannelMessageCompression.RLE == wmqRequesterChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_RLE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqChannelMessageCompression.ZLIBFAST == wmqRequesterChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBFAST;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqChannelMessageCompression.ZLIBHIGH == wmqRequesterChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBHIGH;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		} else {
			messageCompressionList[0] = MQConstants.MQCOMPRESS_NONE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		}

		// Setting MQ RequesterChannel NonPersistentMessageSpeed
		if (WmqNonpersistentMessageSpeed.NORMAL == wmqRequesterChannel.getNonPersistentMessageSpeed()) {

			pcfCmd.addParameter(MQConstants.MQIACH_NPM_SPEED, MQConstants.MQNPMS_NORMAL);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_NPM_SPEED, MQConstants.MQNPMS_FAST);
		}

		// Setting MQ RequesterChannel BatchSize
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_SIZE, wmqRequesterChannel.getBatchSize());

		// Setting MQ RequesterChannel PutAuthority
		if (WmqChannelPutAuthority.CONTEXT == wmqRequesterChannel.getPutAuthority()) {

			pcfCmd.addParameter(MQConstants.MQIACH_PUT_AUTHORITY, MQConstants.MQPA_CONTEXT);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_PUT_AUTHORITY, MQConstants.MQPA_DEFAULT);
		}

		// Setting MQ RequesterChannel MsgExit
		if (StringUtils.isNotBlank(wmqRequesterChannel.getMessageExitName())) {

			String[] messageExitList = StringUtils.split(wmqRequesterChannel.getMessageExitName(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_MSG_EXIT_NAME, messageExitList);
		}

		// Setting MQ RequesterChannel MsgUserData
		if (StringUtils.isNotBlank(wmqRequesterChannel.getMessageExitUserData())) {

			String[] messageExitUserList = StringUtils.split(wmqRequesterChannel.getMessageExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_MSG_EXIT_USER_DATA, messageExitUserList);
		}

		// Setting MQ RequesterChannel MessageRetryCount
		pcfCmd.addParameter(MQConstants.MQIACH_MR_COUNT, wmqRequesterChannel.getMessageRetryCount());

		// Setting MQ RequesterChannel MessageRetryInterval
		pcfCmd.addParameter(MQConstants.MQIACH_MR_INTERVAL, wmqRequesterChannel.getMessageRetryInterval());

		// Setting MQ RequesterChannel MessageRetryExitname
		if (StringUtils.isNotBlank(wmqRequesterChannel.getMessageRetryExitname())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MR_EXIT_NAME, wmqRequesterChannel.getMessageRetryExitname());

		}

		// Setting MQ RequesterChannel MessageRetryExitUserData
		if (StringUtils.isNotBlank(wmqRequesterChannel.getMessageRetryExitUserData())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MR_EXIT_USER_DATA, wmqRequesterChannel.getMessageRetryExitUserData());

		}

		// Setting MQ RequesterChannel Channel MCAUserID
		if (StringUtils.isNotBlank(wmqRequesterChannel.getMcaUserID())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MCA_USER_ID, wmqRequesterChannel.getMcaUserID());

		}

		// Setting MQ RequesterChannel Channel MCAType
		if (WmqChannelMCAType.THREAD == wmqRequesterChannel.getMcaType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_MCA_TYPE, MQConstants.MQMCAT_THREAD);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_MCA_TYPE, MQConstants.MQMCAT_PROCESS);
		}

		// Setting MQ RequesterChannel Channel SendExitname
		if (StringUtils.isNotBlank(wmqRequesterChannel.getSendExit())) {

			String[] sendExitList = StringUtils.split(wmqRequesterChannel.getSendExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_NAME, sendExitList);

		}

		// Setting MQ RequesterChannel Channel SendUserData
		if (StringUtils.isNotBlank(wmqRequesterChannel.getSendExitUserData())) {

			String[] sendExitUserDataList = StringUtils.split(wmqRequesterChannel.getSendExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_USER_DATA, sendExitUserDataList);
		}

		// Setting MQ RequesterChannel Channel ReceiveExit
		if (StringUtils.isNotBlank(wmqRequesterChannel.getReceiveExit())) {

			String[] receiveExitList = StringUtils.split(wmqRequesterChannel.getReceiveExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_NAME, receiveExitList);
		}

		// Setting MQ RequesterChannel Channel ReceiveUserData
		if (StringUtils.isNotBlank(wmqRequesterChannel.getReceiveExitUserData())) {

			String[] receiveExitUserDataList = StringUtils.split(wmqRequesterChannel.getReceiveExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_USER_DATA, receiveExitUserDataList);
		}

		// Setting MQ RequesterChannel Channel SecurityExit
		if (StringUtils.isNotBlank(wmqRequesterChannel.getSecurityExit())) {

			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_NAME, wmqRequesterChannel.getSecurityExit());
		}

		// Setting MQ RequesterChannel Channel SecurityUserData
		if (StringUtils.isNotBlank(wmqRequesterChannel.getSecurityExitUserData())) {

			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_USER_DATA, wmqRequesterChannel.getSecurityExitUserData());
		}

		// Setting MQ RequesterChannel Monitoring
		if (WmqChannelMonitoring.HIGH == wmqRequesterChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelMonitoring.LOW == wmqRequesterChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelMonitoring.MEDIUM == wmqRequesterChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelMonitoring.OFF == wmqRequesterChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting MQ RequesterChannel Statistics
		if (WmqChannelStatisticTypes.HIGH == wmqRequesterChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelStatisticTypes.LOW == wmqRequesterChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelStatisticTypes.MEDIUM == wmqRequesterChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelStatisticTypes.OFF == wmqRequesterChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting MQ RequesterChannel SSLCipherSpec
		if (wmqRequesterChannel.getSslCipherSpecification() != null) {

			pcfCmd.addParameter(MQConstants.MQCACH_SSL_CIPHER_SPEC, wmqRequesterChannel.getSslCipherSpecification().toString());
		}

		// Setting MQ RequesterChannel Client authentication
		if (WmqSSLClientAuthentication.OPTIONAL == wmqRequesterChannel.getSslClientAuth()) {

			pcfCmd.addParameter(MQConstants.MQIACH_SSL_CLIENT_AUTH, MQConstants.MQSCA_OPTIONAL);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_SSL_CLIENT_AUTH, MQConstants.MQSCA_REQUIRED);
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating RequesterChannel \"" + wmqRequesterChannel.getChannelName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName()
			        + "\"";
		}
		return "Creating RequesterChannel Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The RequesterChannel \"" + wmqRequesterChannel.getChannelName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName()
		        + "\"";

	}

}
