/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFException;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wmq.ci.WmqListener;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.PCF_CommonMethods;
import com.xebialabs.deployit.plugin.wmq.utils.WmqHelper;

public class StopWmqListenerStep
extends BaseWmqStep {
    private WmqListener wmqListener;

    public StopWmqListenerStep(WmqListener wmqListener, WmqQueueManager wmqQmanager) {
        this.wmqListener = wmqListener;
        this.wmqQmanager = wmqQmanager;
    }

    protected void init() {
        this.mqCommand = 142;
    }

    public boolean execute(StepExecutionContext ctx) {
        this.init();
        PCF_CommonMethods pcfCM = new PCF_CommonMethods();
        try {
            WmqHelper.createAgent(this.wmqQmanager, pcfCM, ctx);
            PCFMessage pcfCmd = new PCFMessage(this.mqCommand);
            this.setPCFMessageParameters(pcfCmd);
            PCFMessage pcfMessage = WmqHelper.sendPcfcmCommand(pcfCM, pcfCmd);
            this.readPCFMessageResponse(ctx, pcfMessage);
            pcfCM.destroyAgent();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw ie;
            }
        }
        catch (Exception e) {
            if (e.getClass().equals(PCFException.class)) {
                PCFException pcfe = (PCFException)e;
                if (pcfe.reasonCode == 3008) {
                    ctx.logOutput("Warning: Command Failed to stop the listener but continue step with delete");
                    return true;
                }
            }
            pcfCM.displayException(e, ctx);
            return false;
        }
        return true;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        pcfCmd.addParameter(3554, this.wmqListener.getListenerName());
    }

    public String getDescription() {
        return "Stopping the Listener \"" + this.wmqListener.getListenerName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }

    protected String getSuccessMessage() {
        return "The Listener  \"" + this.wmqListener.getListenerName() + "\" stopped successfully on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

